; FLOADFAR.ASM - Copyright (C) 1995 Douglas Herr
;  all rights reserved

; loads disk file to RAM
; call with [EDX] pointing to ASCIIZ filename
;
; returns:
;  if CF = 1, AX = DOS error code
;  if CF = 0, EAX = bytes loaded
;             BX = base selector address

include	model.inc

public	fileloadfar
extrn	fsize:near
IFDEF	DPMI
extrn	GetMem32:near
ENDIF

handle		equ	[ebp-2]
bytes		equ	[ebp-6]		; 4 bytes
base_seg	equ	[ebp-8]		; selector
temp_ptr	equ	[ebp-12]

include	codeseg.inc

fileloadfar	proc	near

	push	ecx
	push	edx
	push	ds
	push	es
	pushfd
	enter	12,0

; open the file
; [EDX] -> file name
	mov	ax,3D00h	; open file for read access
	int	21h
	jc	short f10	; exit if error
	mov	handle,ax	; save file handle

; get file size
; I only need this to calculate memory requirements
	mov	ebx,eax		; handle
	call	fsize
	jc	short f7	; exit if problem: close the file
	mov	bytes,eax	;  else save file size for exit

; allocate memory
	mov	ecx,eax		; bytes
IFDEF	DPMI
	call	GetMem32
ELSE
	sys	GetMem32	; get new selector
ENDIF
	jc	short f7	; exit if error: close the file
	mov	base_seg,bx	; save for exit
	jecxz	f7
	xor	edx,edx		; load file at start of segment
	mov	ecx,65532	; maximum to read: dword aligned for speed
	mov	bx,handle
	mov	ds,base_seg

; read from file to DOS
f5:	mov	ah,3Fh		; read file
	int	21h		; ret: AX = bytes read from file
	jc	short f6	; error exit: close file & de-allocate memory

; update buffer address & get another piece
	movzx	eax,ax
	add	edx,eax		; point to next part of buffer
	cmp	eax,ecx		; did I read 65532?
	je	f5		;  yup, probably more to read
	clc			;  CF = 0, no error
	jmp	short f7	; we done: close the file

; read error: de-allocate DOS buffer
f6:	push	eax		; save error code
	mov	ax,ss
	mov	ds,ax
	mov	es,base_seg	; initial segment address of block
	mov	ah,49h		; release memory
	int	21h
	pop	eax		; restore error code
	stc			; restore error flag

; exit sequence
; close the file
f7:	pushf			; save error flag & code
	push	eax
	mov	ax,ss
	mov	ds,ax
	mov	ah,3Eh
	int	21h
	pop	eax		; restore error code
	popf			; restore error flag
	jc	short f10

	mov	eax,bytes
	mov	bx,base_seg
f10:
	leave
	rcl	ecx,1		; capture CF
	popfd			; all other flags restored
	bt	ecx,0		; restore CF
	pop	es
	pop	ds
	pop	edx
	pop	ecx
	ret

fileloadfar	endp

@curseg	ends
	end
