			title	IOCTL Program

;This program is designed to use the I/O Control (IOCTL) 
;commands of the The Waite Group Printer Device Driver
;(PRN:). The DOS service 44h provides a read and write function
;for I/O Control strings to device drivers that allow IOCTL. 

code	segment				;define segment as code
	assume	cs:code, ds:code 	;COM file DS=CS
	org	100h			;COM file start

main	proc				;main procedure
start:					; start

;display a message to the console
	lea	dx,msg1		; banner
	call	display		;console display

;Determine if it is a Serial or a Parallel printer
ptype:	lea	dx,msg2		;prompt for printer type
	call	display		;console display
	call	input		;get input character
	cmp	al,'P'		;is it a [P]arallel printer?
	je	ptype1		;yes - store it
	cmp	al,'S'		;is it a [S]erial printer?
	je	ptype1		;yes - store it
	lea	dx,msg2e	;error message
	call	display		;console display
	jmp	ptype		;its neither - go back
ptype1:	mov	buf,al		;store the 'P' or 'S'

;get the device number: 1, 2, or 3 
;convert this to 0, 1, or 2 for use by the BIOS. 
pdev:	lea	dx,msg3		;prompt for device number
	call	display		;console display
	call	input		;get input character
	cmp	al,'3'		;is it greater than 3?
	ja	perr1		;yes - too large
	cmp	al,'1'		;is it below 1?
	jb	perr1		;yes - too small
	sub	al,30h		;convert ASCII to binary
	dec	al		;subtract one for driver use
	mov	buf+1,al	;store device number
	jmp	fopen		;go open PRN: file
perr1:	lea	dx,msg2e	;incorrect selection message
	call	display		;console display
	jmp	pdev		;go back & try again

;open PRN using file handle call
fopen:	mov	al,2		;read/write access
	mov	ah,3dh		;open file handle
	lea	dx,file		;address of filename
	int	21h		;DOS call
	jc	openerr		;error (carry set)?
	push	ax		;save file handle
	lea	dx,filemsg	;no error - tell user
	call	display		;console display
	jmp	ioctl		;get IOCTL function
openerr:lea	dx,msg5		;error message
	jmp	exit		;exit - problem in program

;get function type: Write IOCTL or Read IOCTL
ioctl:	lea	dx,msg4		;Read or Write IOCTL
	call	display		;console display
	call	input		;get input character
	cmp	al,'R'		;is it [R]ead?
	je	ioread		;yes - process it
	cmp	al,'W'		;is it [W]rite?
	je	iowrite		;yes - process it
	lea	dx,msg2e	;no - error message
	call	display		;console display
	jmp	ioctl		;try again

ioread:	mov	al,2		;read IOCTL string from driver
	jmp	doioctl		;process it
iowrite:mov	al,3		;write IOCTL string to driver

doioctl:pop	bx		;restore file handle to bx
	mov	ah,44h		;service = IOCTL
	mov	cx,2		;count = 2 bytes
	lea	dx,buf		;address of buffer
	int	21h		;DOS call
	jc	chkerr		;error (carry set)?
	or	al,30h		;make count ASCII
	mov	msg6a,al	;store count
	mov	al,buf+1	;get device unit number
	or	al,30h		;make it ASCII
	mov	buf+1,al	;store it back
	lea	dx,msg6		;display results
	call	display		;console display
	jmp	exit		;we are done!

;check error from IOCTL call
chkerr:	cmp	ax,1		;invalid function number?
	jne	err1		;no
	lea	dx,emsg1	;yes
	jmp	err		;display & exit
err1:	cmp	ax,4		;no handle?
	jne	err2		;no
	lea	dx,emsg2	;yes
	jmp	err
err2:	cmp	ax,5		;access denied?
	jne	err3		;no
	lea	dx,emsg3	;yes
	jmp	err		;display & exit
err3:	cmp	ax,6		;invalid handle or not open?
	jne	err4		;no
	lea	dx,emsg4	;yes
	jmp	err		;display & exit
err4:	cmp	ax,0dh		;invalid data?
	jne	err5		;no
	lea	dx,emsg5	;yes
	jmp	err		;display & exit
err5:	cmp	ax,0fh		;invalid drive?
	jne	err6		;no
	lea	dx,emsg6	;yes
	jmp	err		;display & exit
err6:	lea	dx,emsg7	;unknown error
err:	call	display		;display

exit:	lea	dx,msg7		;goodbye message
	call	display		;console display
	int	20h		;exit back to DOS

display	proc	near		;display message on screen
	mov	ah,9		;service = display
	int	21h		;DOS call
	ret			;return to caller
display	endp			;

input	proc	near		;get 1 character from the keyboard
	mov	ah,1		;service = keyboard input
	int	21h		;DOS call
	ret			;return to caller
input	endp			;

msg1	db	'IOCTL PROGRAM',0dh,0ah,'$'
msg2	db	0dh,0ah,'Select Printer type ',0dh,0ah,
	db	' "S" for serial or "P" for parallel :','$'
msg2e	db	0dh,0ah,'bad selection - try again!',0dh,0ah,'$'
msg3	db	0dh,0ah,'Enter printer number [1,2,3] :$'
msg4	db	0dh,0ah,'IOCTL type [W]rite or [R]ead :$'
msg5	db	0dh,0ah,'cannot open PRN!',0dh,0ah,'$'
msg6	db	0dh,0ah,'IOCTL call OK',0dh,0ah,' count transferred = ',
msg6a	db	'0',0dh,0ah,' IOCTL string = ',
buf	db	'S',0h,0dh,0ah,'$'
msg7	db	'Goodbye for now',0dh,0ah,'$'
filemsg	db	0dh,0ah,
file	db	'PRN',0h,
	db	' has been opened!',0d,0ah,'$'
emsg1	db 	0dh,0ah,'invalid function number',0dh,0ah,'$'
emsg2	db 	0dh,0ah,'no file handle',0dh,0ah,'$'
emsg3	db 	0dh,0ah,'access denied',0dh,0ah,'$'
emsg4	db 	0dh,0ah,'invalid handle or not open',0dh,0ah,'$'
emsg5	db 	0dh,0ah,'invalid data',0dh,0ah,'$'
emsg6	db 	0dh,0ah,'invalid drive number',0dh,0ah,'$'
emsg7	db 	0dh,0ah,'unknown error number',0dh,0ah,'$'

main	endp			;end of main procedure
code	ends			;end of code segment
	end	start		;	