dosver	proc	near		;set command limit
;
;This procedure is called from the Initialization 
;command processing code. The DOS version is retrieved
;and the maximum command number is set in variable
;cs:max_cmd. The INTERRUPT code uses the number contained
;in cs:max_cmd to determine if an invalid command number
;has been passed to the device driver.
;
	push	ax		;save ax
	push	cx		;save cx
	mov	ah,30h		;Get DOS version
	int	21h		;DOS service call
;DOS returns 	major version (2,3) in al and 
;		minor version (10,11,20) in ah
	cmp	al,2		;Version 2?
	jne	ver3		;no - assume three
	mov	cl,12		;13 commands for DOS 2
	jmp	ver4		;store it
ver3:	cmp	ah,20		;Version 3.20?
	je	ver320		;yes
	mov	cl,16		;17 commands for DOS 3, 3.1
	jmp	ver4		;store it
ver320:	mov	cl,24		;25 commands for DOS 3.20
ver4:	mov	cs:max_cmd,cl	;save command limit
	pop	cx		;restore cx
	pop	ax		;restore ax
	ret			;return to caller
dosver	endp			;end of dosver


