ROM	SEGMENT AT 0F000H		;ROM NMI AT 0F000H:0E2C3H
	ORG	0E2C3H
ROMADR	LABEL	FAR
ROM	ENDS
CODE	SEGMENT	PARA
	ASSUME	CS:CODE,DS:CODE
	ORG	100H		;NEEDED FOR A .COM FILE
START	PROC	FAR
	JMP	DONE		;INSTALL PROGRAM AND RETURN TO DOS
XFER	DW	?		;8087 - 8088 XFER AREA
DISPLAY	DW	0B000H		;START OF DISPLAY SEGMENT
ERROR:	PUSH	AX		;SAVE REGISTERS USED ON USERS STACK
	PUSH	BX
	PUSH	DS
	PUSH	ES
	MOV	AX,CS		;POINT DS AT CS
	MOV	DS,AX
	MOV	ES,DISPLAY	;POINT ES AT START OF DISPLAY MEMORY
	DB	0DBH,0E1H	;DISABLE 8087 INTERRUPT WITH ERROR PENDING
	ESC	2FH,XFER	;CHECK 8087 FOR ERRORS
	DB	9BH,0DBH,0E2H	;CLEAR 8087 EXCEPTION FLAGS
	DB	9BH,0DBH,0E0H	;ENABLE 8087 INTERRUPTS AGAIN
	MOV	BL,BYTE PTR XFER	;GET LOW BYTE WITH EXCEPTION FLAGS
	MOV	AH,70H		;REVERSE VIDEO ATTRIBUTE FOR CHARACTER
	RCR	BL,1D		;GET NEXT ERROR FLAG
	JNC	D		;JUMP IF NO INVALID OPERATION
	MOV	AL,'I'
	MOV	ES:[2*79D],AX	;WRITE ERROR FLAG TO SCREEN
D:	RCR	BL,1D		;GET NEXT ERROR FLAG
	JNC	Z		;JUMP IF NO DENORMALIZED OPERAND
	MOV	AL,'D'
	MOV	ES:[2*78D],AX	;WRITE ERROR FLAG TO SCREEN
Z:	RCR	BL,1D		;GET NEXT ERROR FLAG
	JNC	O		;JUMP IF NO DIVIDE BY ZERO
	MOV	AL,'Z'
	MOV	ES:[2*77D],AX	;WRITE ERROR FLAG TO SCREEN
O:	RCR	BL,1D		;GET NEXT ERROR FLAG
	JNC	U		;JUMP IF NO OVERFLOW
	MOV	AL,'O'
	MOV	ES:[2*76D],AX	;WRITE ERROR FLAG TO SCREEN
U:	RCR	BL,1D		;GET NEXT ERROR FLAG
	JNC	P		;JUMP IF NO UNDERFLOW
	MOV	AL,'U'
	MOV	ES:[2*75D],AX	;WRITE ERROR FLAG TO SCREEN
P:	RCR	BL,1D		;GET NEXT ERROR FLAG
	JNC	EXIT		;JUMP IF NO PRECISION ERROR
	MOV	AL,'P'
	MOV	ES:[2D*154D],AX	;WRITE ERROR FLAG TO SCREEN
EXIT:	POP	ES		;RESTORE REGISTERS USED
	POP	DS
	POP	BX
	POP	AX
	JMP	FAR PTR ROMADR	;JUMP TO NMI IN ROM TO FINISH UP
DONE:	MOV	DX,OFFSET ERROR	;OFFSET OF ERROR CODE
	MOV	AH,25H
	MOV	AL,2H		;NMI
	INT	21H		;MOVE INTERRUPT VECTOR INTO TABLE
	MOV	DX,OFFSET DONE
	INT	27H		;TERMINATE BUT STAY RESIDENT
START	ENDP
CODE	ENDS
	END	START
