;BIN_ASC.ASM
;
;This procedure converts a signed binary number to a six-
;byte ASCII string (sign plus five digits) in the data
;segment.  Upon entry, the number to be converted must be
;in AX and the starting addresss of the memory buffer
;must be in BX.  Upon return, BX holds the address of 
;the converted output string and CX holds the length
;of the string.  Other registers are preserved.
;
CODE SEGMENT PARA 'CODE'
     ASSUME CS:CODE
     PUBLIC BIN_ASCII

BIN_ASCII PROC FAR
       PUSH DX        ;SAVE AFFECTED REGISTERS
       PUSH SI
       PUSH AX        ;SAVE BINARY VALUE
       MOV  CX,6      ;FILL BUFFER WITH SPACES
FILL_BUFFER:
       MOV  BYTE PTR [BX],' '    ;BLANK
       INC  BX
       LOOP FILL_BUFFER
       MOV  SI,10     ;GET READY TO DIVIDE BY 10
       OR   AX,AX     ;IF VALUE IS NEGITIVE
       JNS  CLR_DVD
       NEG  AX        ;MAKE IT POSITIVE
CLR_DVD:
       SUB  DX,DX     ;CLEAR UPPER HALF OF DIVIDEND
       DIV  SI        ;DIVIDE AX BY 10
       ADD  DX,'0'    ;CONVERT REMAINDER TO ASCII DIGIT
       DEC  BX        ;BACK UP THROUGH BUFFER
       MOV  [BX],DL   ;STORE THIS CHAR IN THE STRING
       INC  CX        ;COUNT CONVERTED CHARACTER
       OR   AX,AX     ;ALL DONE?
       JNZ  CLR_DVD   ;N0. GO GET NEXT DIGIT
       POP  AX        ;YES. RETRIEVE ORIGINAL VALUE
       OR   AX,AX     ;WAS IT NEGITIVE?
       JNS  NO_MORE   
       DEC  BX        ;YES. STORE SIGN
       MOV  BYTE PTR [BX],'-'
       INC  CX        ;    AND INCREASE CHARACTER COUNT
NO_MORE:
       POP  SI
       POP  DX
       RET            ;RETURN TO CALLER

BIN_ASCII  ENDP
CODE       ENDS
           END
