		   PAGE      52,132
STACK		   SEGMENT   BYTE STACK 'STACK'  ;STACK SEGMENT
		   DB	     64 DUP ('STACK   ') ;INITIAL STACK VALUE
STACK		   ENDS 			 ;STACK SEGMENT END
		   PAGE
CSEG		   SEGMENT   BYTE PUBLIC 'CODE'  ;CODE SEGMENT
		   ASSUME    CS:CSEG,ES:CSEG	 ;ASSUME'S
INT5_OFF	   EQU	     14H		 ;INT 5 OFFSET ADDRESS
INT5_SEG	   EQU	     16H		 ;INT 5 SEG. ADDRESS
OLD_SEG 	   EQU	     -2 		 ;OLD SEQ. OFFSET
OLD_OFF 	   EQU	     -4 		 ;OLD OFFSET OFFSET
INT_27		   EQU	     27CDH		 ;INT 27 OP-CODE
CODE_9		   EQU	     9H 		 ;FUNCTION CODE 9
INT_21		   EQU	     21H		 ;INT 21 REQUEST VALUE
RET		   EQU	     0H 		 ;RETURN CODE OFFSET
BASIC_DS	   EQU	     510H		 ;BASIC DS SAVE ADDR.
PROTECT 	   EQU	     464H		 ;PROT OFFSET (IBM)
POINT		   EQU	     8			 ;OFFSET TO IDENT
BYTES		   EQU	     4			 ;SIZE OF IDENT
PRE		   EQU	     100H		 ;PREFIX SIZE
		   PAGE
START		   LABEL     NEAR		 ;START OF BODY
IDENT		   DB	     'PROT'              ;PROGRAM IDENT.
PRTSC_OFF	   DW	     0			 ;PRINT SCREEN OFFSET
PRTSC_SEG	   DW	     0			 ;PRINT SCREEN SEGMENT
INT		   LABEL     NEAR		 ;INTERRUPT ROUTINE
		   PUSH      DS 		 ;SAVE DS REGISTER
		   PUSH      AX 		 ;SAVE AX REGISTER
		   XOR	     AX,AX		 ;ZERO AX REGISTER
		   MOV	     DS,AX		 ;LOWER CORE POINTER
		   MOV	     DS,[DS:BASIC_DS]	 ;BASIC WORK AREA
		   XOR	     AL,AL		 ;ZERO AL REGISTER
		   MOV	     [DS:PROTECT],AL	 ;UN-PROTECT PROGRAM
		   POP	     AX 		 ;RESTORE AX REGISTER
		   POP	     DS 		 ;RESTORE DS REGISTER
		   STI				 ;ALLOW INTERRUPTS
		   IRET 			 ;INTERRUPT RETURN
I_END		   EQU	     $			 ;RESIDENT CODE END
		   PAGE
INITIAL 	   PROC      FAR		 ;INITIALIZATION CODE
		   PUSH      DS 		 ;SAVE RETURN SEGMENT
		   MOV	     AX,INT_27		 ;GET INT 27 OP-CODE
		   MOV	     [DS:RET],AX	 ;CHANGE RETURN CODE
		   XOR	     AX,AX		 ;ZERO AX REGISTER
		   PUSH      AX 		 ;SAVE RETURN OFFSET
		   MOV	     DS,AX		 ;POINT TO LOWER CORE
		   CLD				 ;SET DIRECTION FLAG
		   MOV	     DX,CS		 ;GET POINTER TO CODE
		   MOV	     ES,DX		 ;POINT TO CODE
		   MOV	     CX,BYTES		 ;GET LENGTH OF IDENT
		   MOV	     DI,OFFSET IDENT	 ;POINT TO IDENT
		   MOV	     BX,[DS:INT5_SEG]	 ;GET INT 5 SEGMENT
		   MOV	     SI,[DS:INT5_OFF]	 ;GET INT 5 OFFSET
		   MOV	     DS,BX		 ;POINT TO INT 5
		   SUB	     SI,POINT		 ;POINT TO ID LOC
		   REPZ      CMPSB		 ;CHECK IF LOADED
		   JNE	     LOAD		 ;GO LOAD IF NOT
		   PAGE
UNLOAD		   LABEL     NEAR		 ;UN-LOAD CODE
		   MOV	     DS,AX		 ;POINT TO LOWER CORE
		   MOV	     SI,[DS:INT5_OFF]	 ;GET INT 5 OFFSET
		   MOV	     DS,BX		 ;POINT TO INT 5
		   MOV	     BX,[OLD_SEG][SI]	 ;GET OLD SEGMENT
		   MOV	     CX,[OLD_OFF][SI]	 ;GET OLD OFFSET
		   MOV	     DS,AX		 ;POINT TO LOWER CORE
		   MOV	     [DS:INT5_SEG],BX	 ;RESTORE SEGMENT
		   MOV	     [DS:INT5_OFF],CX	 ;RESTORE OFFSET
		   MOV	     DS,DX		 ;POINT TO CODE
		   MOV	     DX,OFFSET OFF	 ;POINT TO OFF MESS.
		   MOV	     AH,CODE_9		 ;GET DESIRED CODE
		   INT	     INT_21		 ;PRINT MESSAGE
		   MOV	     DX,OFFSET START	 ;GET BODY OFFSET
		   PAGE
		   JMP	     EXIT		 ;GO EXIT FOR GOOD
LOAD		   LABEL     NEAR		 ;LOAD CODE
		   MOV	     DS,AX		 ;POINT TO LOWER CORE
		   MOV	     AX,[DS:INT5_OFF]	 ;INTERRUPT 5 OFFSET
		   MOV	     [CS:PRTSC_OFF],AX	 ;SAVE INT 5 OFFSET
		   MOV	     AX,[DS:INT5_SEG]	 ;INTERRUPT 5 SEGMENT
		   MOV	     [CS:PRTSC_SEG],AX	 ;SAVE INT 5 SEGMENT
		   CLI				 ;NO INTERRUPTIONS
		   MOV	     AX,OFFSET INT	 ;GET INTERRUPT OFFSET
		   MOV	     [DS:INT5_OFF],AX	 ;SAVE INT 5 OFFSET
		   MOV	     [DS:INT5_SEG],CS	 ;SAVE INT 5 SEGMENT
		   STI				 ;ALLOW INTERRUPTS
		   MOV	     DS,DX		 ;POINT TO CODE
		   MOV	     DX,OFFSET ON	 ;POINT TO ON MESS.
		   MOV	     AH,CODE_9		 ;GET DESIRED CODE
		   INT	     INT_21		 ;PRINT MESSAGE
		   MOV	     DX,OFFSET I_END+PRE ;GET END POINTER
		   PAGE
EXIT		   LABEL     NEAR		 ;EXIT CODE
		   RET				 ;TERMINATE RESIDENT
INITIAL 	   ENDP 			 ;END OF INITIAL
ON		   DB	     "Protect Bypass Enabled$"
OFF		   DB	     "Protect Bypass Disabled$"
CSEG		   ENDS 			 ;CODE SEGMENT END
		   END	     INITIAL		 ;SET TRANSFER ADDRESS
