        NAME    OPTEST
        PAGE    55,132
        TITLE   'OPTEST - TEST MICROSOFT ASSEMBLER OPERATORS'
;
; SHOW OPERATION OF VARIOUS OPERATORS AND DEMONSTRATE SOME
; NOTATIONAL IDIOSYNCRACIES IN THE MICROSOFT IBM PC ASSEMBLER.
;
; RAY DUNCAN, NOVEMBER 1983
;
;
; EVERY OTHER ASSEMBLER I HAVE EVER ENCOUNTERED WILL DISPLAY
; THE TRUE HEX EQUIVALENT OF AN EQUATE IN THE OBJECT CODE COLUMN.
; THE MICROSOFT ASSEMBLER, HOWEVER, SHOWS A SIGNED HEX INTEGER!
;
NEG_ONE EQU     -1      ;SHOULD DISPLAY AS FFFF


; FOR UNKNOWN REASONS, THE MICROSOFT ASSEMBLER ALSO FAILS TO DISPLAY
; THE BYTE SWAPPED NATURE OF SOME 16 BIT VALUES.

        DW      1


; THE MICROSOFT ASSEMBLER MANUAL SAYS NOTHING ABOUT THE SHR
; AND SHL OPERATORS.  HOWEVER, AN EXAMPLE ON PAGE 4-21 STATES
; THAT THE OPERATION 101B SHL (2*2) SHOULD RETURN 01010000B OR 50H,
; IMPLYING THAT THE ORDER OF ARGUMENTS IS DATA SHL SHIFT_COUNT.

        DW      101B SHL (2*2)

; SINCE MICROSOFT'S OWN EXAMPLE DOESN'T WORK WITH THEIR ASSEMBLER,
; BY EXPERIMENTING WE FIND THAT THE EXPECTED ORDER OF ARGUMENTS IS
; SHIFT_COUNT SHL DATA. THIS CONFLICTS WITH THE INTEL SPECIFICATION.

        DW      0 SHL 1
        DW      1 SHL 1
        DW      2 SHL 1

; THE SHR OPERATOR DOESN'T WORK CORRECTLY.  APPARENTLY GIVES
; THE SAME RESULTS AS SHL...

        DW      2 SHL 1
        DW      2 SHR 1

; EXCEPT WHEN IT GIVES NO RESULT AT ALL...

        DW      1 SHL 8
        DW      1 SHR 8

; SHR MAY EVEN GIVE DIFFERENT RESULTS WITH EQUIVALENT DATA

        DW      16 SHR -1
        DW      16 SHR 0FFFFH

; SOMETIMES THE SHL OPERATOR SEEMS TO PERFORM A "LOGICAL SHIFT"

        DW      1 SHL -1
        DW      15 SHL -1

; OTHER TIMES, IT APPEARS TO PERFORM A CIRCULAR SHIFT

        DW      16 SHL -1

; THE EQ OPERATOR DOESN'T WORK PROPERLY

        DW      1 EQ 1
        DW      1 EQ -1

; THE EQ OPERATOR CAN GIVE DIFFERENT RESULTS WITH EQUIVALENT DATA

        DW      1 EQ -1
        DW      1 EQ 0FFFFH

; THE NE OPERATOR IS SIMILARLY AFFLICTED

        DW      1 NE 1
        DW      1 NE -1
        DW      1 NE 0FFFFH

; THE LE, LT, GE, AND GT OPERATORS GIVE CONFUSING RESULTS

        DW      -1 LT 1
        DW      -1 LE 1
        DW      -1 GT 1
        DW      -1 GE 1

; AGAIN, THESE OPERATORS CAN GIVE DIFFERENT RESULTS WITH
; EQUIVALENT DATA

        DW      1 GE -1
        DW      1 GE 0FFFFH

; THE NOT OPERATOR FAILS MISERABLY ON SOME SIGNED INTEGERS

        DW      NOT -1



; SIMILARLY, THE OR OPERATOR FLUBS WITH SIGNED INTEGERS

        DW      -1 OR 0
        DW      0FFFFH OR 0

; THE XOR OPERATOR APPARENTLY WORKS AS AN INCLUSIVE OR
; INSTEAD OF EXCLUSIVE OR

        DW      0 XOR 0
        DW      1 XOR 0
        DW      0 XOR 1
        DW      1 XOR 1

        END
