;up.com patch file	02/20/84
;	The up program is distributed with the Gemini printer equate
;	set to true. This should work with the Epson also.
;
;	For a list of the commands just type UP with nothing else
;	on the command line.
;
;	example of a valid command:
;
;	up uppatch.asm [dl8h]
;
;	The above line will cause the printer to print 8 lines per inch
;	in the compressed print mode with two pages of the file on one
;	page of the paper and cause a big block header page to be printed.
;
;	Set the equate for your printer and assemble this program.
;	If your printer is not listed here enter the values in the same format
;	as shown below.
;
;	Do the following steps to patch in the printer codes:
;
;	ASM UPPATCH;
;	LINK UPPATCH;
;	EXE2BIN UPPATCH UPPACTH.COM
;	DEBUG UP.COM
;	-NUPPATCH.COM
;	-L
;	-RCX
;	cx 009b
;	:3131
;	-NUPGEMINI.COM
;	-W
;	-Q
;
;
TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE

OKIDATA EQU	FALSE		;okidata 84 step 2
GEMINI	EQU	TRUE		;10x and also Epson
TI810	EQU	FALSE
;
;
codeseg segment public 'code'

assume cs:codeseg,ds:codeseg,es:codeseg,ss:codeseg

	org	100h
;
begg:
	db	0e9h				;jump intruction
	dw	1fd1h				;start of program
;
	IF	OKIDATA
COMPRESS DB	29,0FFH,0,0,0,0,0,0		;COMPRESS PRINTING 17 CPI
NORMALW  DB	30,0FFH,0,0,0,0,0,0		;NORMAL PRINTING 10 CPI
LINESP8  DB	27,56,0FFH,0,0,0,0,0		;8 LINES PER INCH
LINEPAG8 DB	27,70,56,56,0FFH,0,0,0		;88 LINES PER PAGE
LINESP6  DB	27,54,0FFH,0,0,0,0,0		;6 LINES PER INCH
LINEPAG6 DB	27,70,54,54,0FFH,0,0,0		;66 LINES PER PAGE
SETTOF	 DB	27,53,0FFH,0,0,0,0,0		;SETS TOF
DOUBLEW  DB	31,0FFH,0,0,0,0,0,0		;DOUBLE WIDTH CHARACTER
EGRAPHIC DB	14,0FFH,0,0,0,0,0,0		;ENTER GRAPHIC MODE
XGRAPHIC DB	15,0FFH,0,0,0,0,0,0		;EXIT GRAPHIC MODE
TAB72	 DB	27,9,'072',0DH,0FFH,0           ;SETS TAB AT COLUMN 72
TAB116	 DB	27,9,'116',0DH,0FFH,0           ;SETS TAB AT COLUMN 116
EMPHAS	 DB	27,'H',0FFH,0,0,0,0,0           ;EMPHASIZED PRINTING
OFFEMPH  DB	27,'I',0FFH,0,0,0,0,0           ;TURN OFF EMPHASIZE PRINTING
;
;
;
RESTORE DB	1BH,30H,27,70,54,54,30,27	;RESTORE PRINTER TO NORMAL
	DB	54,27,53,0FFH,0,0,0,0
	DB	0,0,0,0,0,0,0,0
;
LPAGE6	DB	60			;DATA LINES PER PAGE FOR 6
LPAGE8	DB	82			;DATA LINES PER PAGE FOR 8
GRAPHIC DB	78			;GRAPHIC CHARACTER FOR HEADING
GRAPHSP DB	63			;GRAPHIC SPACE FOR HEADING
DOUBCOL DB	70			;NUMBER OF DATA COLUMNS DOUBLE PAGE
DOUBCOLW DB	116			;NUMBER OF DATA COLUMNS DOUBLE WIDE
;
	ENDIF
;
	IF	GEMINI
COMPRESS DB	27,66,3,0FFH,0,0,0,0		;COMPRESS PRINTING 17 CPI
NORMALW  DB	27,66,1,0FFH,0,0,0,0		;NORMAL PRINTING 10 CPI
LINESP8  DB	27,48,0FFH,0,0,0,0,0		;8 LINES PER INCH
LINEPAG8 DB	27,67,88,0FFH,0,0,0,0		;88 LINES PER PAGE
LINESP6  DB	27,50,0FFH,0,0,0,0,0		;6 LINES PER INCH
LINEPAG6 DB	27,67,66,0FFH,0,0,0,0		;66 LINES PER PAGE
SETTOF	 DB	0FFH,0,0,0,0,0,0,0		;SETS TOF
DOUBLEW  DB	14,0FFH,0,0,0,0,0,0		;DOUBLE WIDTH CHARACTER
EGRAPHIC DB	27,62,0FFH,0,0,0,0,0		;ENTER GRAPHIC MODE
XGRAPHIC DB	27,35,0FFH,0,0,0,0,0		;EXIT GRAPHIC MODE
TAB72	 DB	27,68,66,0,0FFH,0,0,0		;SETS TAB AT COLUMN 66
TAB116	 DB	27,68,66,0,0FFH,0,0,0		;SETS TAB AT COLUMN 66
EMPHAS	 DB	27,'G',0FFH,0,0,0,0,0           ;EMPHASIZED PRINTING
OFFEMPH  DB	27,'H',0FFH,0,0,0,0,0           ;TURN OFF EMPHASIZE PRINTING
;
;
;
RESTORE  DB	1BH,64,0FFH,0,0,0,0,0		;RESTORE PRINTER TO NORMAL
	 DB	0,0,0,0,0,0,0,0
	 DB	0,0,0,0,0,0,0,0
;
LPAGE6	 DB	60			;DATA LINES PER PAGE FOR 6
LPAGE8	 DB	82			;DATA LINES PER PAGE FOR 8
GRAPHIC  DB	239			;GRAPHIC CHARACTER FOR HEADING
GRAPHSP  DB	224			;GRAPHIC SPACE FOR HEADING
DOUBCOL  DB	64			;NUMBER OF DATA COLUMNS DOUBLE PAGE
DOUBCOLW DB	64			;NUMBER OF DATA COLUMNS DOUBLE WIDE
;
	ENDIF
;
	IF	TI810
COMPRESS DB	27,'7',0DH,0FFH,0,0,0,0         ;COMPRESS PRINTING 17 CPI
NORMALW  DB	27,'6',0DH,0FFH,0,0,0,0         ;NORMAL PRINTING 10 CPI
LINESP8  DB	27,'5',0DH,0FFH,0,0,0,0         ;8 LINES PER INCH
LINEPAG8 DB	27,'2',88,0DH,0FFH,0,0,0        ;88 LINES PER PAGE
LINESP6  DB	27,'4',0DH,0FFH,0,0,0,0         ;6 LINES PER INCH
LINEPAG6 DB	27,'2',66,0DH,0FFH,0,0,0        ;66 LINES PER PAGE
SETTOF	 DB	0FFH,0,0,0,0,0,0,0		;SETS TOF
DOUBLEW  DB	14,0FFH,0,0,0,0,0,0		;DOUBLE WIDTH CHARACTER
EGRAPHIC DB	0FFH,0,0,0,0,0,0,0		;ENTER GRAPHIC MODE
XGRAPHIC DB	0FFH,0,0,0,0,0,0,0		;EXIT GRAPHIC MODE
TAB72	 DB	27,'3',66,0,0DH,0FFH,0,0        ;SETS TAB AT COLUMN 66
TAB116	 DB	27,'3',66,0,0DH,0FFH,0,0        ;SETS TAB AT COLUMN 116
EMPHAS	 DB	0FFH,0,0,0,0,0,0,0		;EMPHASIZED PRINTING
OFFEMPH  DB	0FFH,0,0,0,0,0,0,0		;TURN OFF EMPHASIZE PRINTING
;
;
;
RESTORE DB	1BH,64,0FFH,0,0,0,0,0		;RESTORE PRINTER TO NORMAL
	DB	0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0
;
LPAGE6	DB	60			;DATA LINES PER PAGE FOR 6
LPAGE8	DB	82			;DATA LINES PER PAGE FOR 8
GRAPHIC DB	'#'                     ;GRAPHIC CHARACTER FOR HEADING
GRAPHSP DB	' '                     ;GRAPHIC SPACE FOR HEADING
DOUBCOL DB	64			;NUMBER OF DATA COLUMNS DOUBLE PAGE
DOUBCOLW	DB	64		;NUMBER OF DATA COLUMNS DOUBLE WIDE
;
	ENDIF
;
;	IF THE '[' IS NOT ENTERED IN THE COMMAND LINE THE PROGRAM WILL
;	SEARCH THIS LOCATION FOR A LIST OF OPTIONS. ENTER THE ASCII VALUES
;	OF THE COMMANDS YOU WISH TO DEFAULT TO.
;
;NOTE:
;	IF THE `[` IS ENTERED BUT NO OPTIONS ARE ENTERED THE PROGRAM
;	WILL DEFAULT TO THE FOLLOWING:
;			6 LINES PER INCH
;			10 CPI
;			66 LINES PER PAGE
;			PAGE NUMBERING
;			FILTERING OF FORM FEEDS
;			NORMAL TABS
;			NO INDENT
;			AUTO TIME AND DATE
;
;
;	DEFAULT COMMANDS (UP TO TEN CHARACTERS ALLOWED)
;
;
DEFAULT:
	DB	0,0,0,0,0,0,0,0,0,0	;DEFAULT COMMANDS LOOKED AT
					;IF NO [ ENTERED
;
codeseg ends
	end	begg
;
;
;	For those who do not have the assembler the following
;	locations must be patched. End each escape seq. with a 0ffh
;
;
;memory location	description
;---------------	-----------
;0103			COMPRESS PRINTING 17 CPI
;010B			NORMAL PRINTING 10 CPI
;0113			8 LINES PER INCH
;011B			88 LINES PER PAGE
;0123			6 LINES PER INCH
;012B			66 LINES PER PAGE
013			SETS TOF
;013B			DOUBLE WIDTH CHARACTER
;0143			ENTER GRAPHIC MODE
;014B			EXIT GRAPHIC MODE
;0153			SETS TAB AT COLUMN 66
;015B			SETS TAB AT COLUMN 66
;0163			EMPHASIZED PRINTING
;016B			TURN OFF EMPHASIZE PRINTING
;0173			RESTORE PRINTER TO NORMAL
;018B			DATA LINES PER PAGE FOR 6
;018C			DATA LINES PER PAGE FOR 8
;018D			GRAPHIC CHARACTER FOR HEADING
;018E			GRAPHIC SPACE FOR HEADING
;018F			NUMBER OF DATA COLUMNS DOUBLE PAGE
;0190			NUMBER OF DATA COLUMNS DOUBLE WIDE
;0191			DEFAULT COMMANDS LOOKED AT
;019B			start of the program
