         name      vmode
         page      55,132
         title     'VMODE --- Set PC Video Mode'
;
; VMODE utility to set display
; mode on IBM Personal Coeputer
;
; Ray Duncan, July 1983   (Transcribed from Sept 1983 Softtalk p.181)
;
input    equ       080h           ;address of command tail
                                  ;buffer (set up by DOS)
blank    equ       20h            ;ASCII blank code
cr       equ       0dh            ;ASCII carriage return
lf       equ       0ah            ;ASCII line feed
;
;
cseg     segment   byte
         assume    cs:cseg,ds:cseg
         org       100h
;
vmode:                            ;initialize DI to the
                                  ;address of the input buffer
         mov       di,offset input
         mov       al,[di]        ;check if any command tail
         or        al,al          ;and exit if not
         jz        vmode7
         mov       al,blank       ;load ASCII blank for scan
         inc       di             ;increment address in DI
                                  ;past the input count byte
         mov       cx,80          ;scan max of 80 chars.
         cld                      ;clear direction flag
         repz scasb               ;look for first non-blank
                                  ;character in input buffer
         jz        vmode7         ;jump if none found
                                  ;load the non-blank char.,
                                  ;use offset 0f -1 since DI
                                  ;will be pointing past it
         mov       al,-1[di]
         cmp       al,cr          ;if first non-blank char
                                  ;was RETURN, mode was missing
         jz        vmode7         ;so go print error message
         cmp       al,'0'         ;make sure it is range 0-7
         jb        vmode8         ;exit if ASCII code is <'0'
         cmp       al,'7'         ;compare for '7'
         ja        vmode8         ;exit if ASCII code >'7'
         mov       vmodeb,al      ;store mode number into
                                  ;output string
         and       al,0fh         ;mask off upper four bits
                                  ;of character. to get 0-7
         push      ax             ;save mode for later
         xor       bx,bx          ;zero BX
         mov       es,bx          ;set ES=zero
         mov       bx,410h        ;set BX=addr of DOS's
                                  ;equipment flags word
         cmp       al,7           ;check if monochrome
                                  ;or graphics board
         mov       al,30h         ;assume monochrome
         jz        vmode6
         mov       al,20h         ;no, was graphics board
vmode6:                           ;mask off the old
                                  ;display equipment flags
         and   byte ptr es:[bx],0cfh
                                  ;merge in the proper flag
                                  ;for the newly selected display
         or        es:[bx],al
         pop       ax             ;recover mode
         xor       ah,ah          ;force AH=zero
         int       10h            ;and call ROM BIOS
                                  ;to set new display,
                                  ;go print success message,
                                  ;and exit
         mov       dx,offset vmodea
         jmp       short vmode9
vmode7:                           ;print "missing mode number"
         mov       dx,offset vmodec
         jmp       short vmode9
vmode8:                           ;print "illegal mode number"
         mov       dx,offset vmoded
vmode9:                           ;print the message whose
                                  ;address is in reg DX
         mov       ah,9           ;function 9 = print string
         int       21h            ;call DOS to print
                                  ;and exit back to DOS
         int       20h
;
vmodea   db        cr,lf
         db        'Video mode set to '
vmodeb   db        ' ',cr,lf,'$'
vmodec   db        cr,lf
         db        'Missing mode number '
         db        cr,lf,'$'
vmoded   db        cr,lf
         db        'Illegal mode number '
         db        cr,lf,'$'
;
cseg     ends
;
         end       vmode
                                                                                                       