; ** This source file was designed for TASM **
;
; This program inplements a screen blanker in as little space as possible.
; To do this it uses a program minimizing and cloaking technology
; developed by Don Neufeld.  So far no virus checkers have mistaken this
; software for a virus.
;
; The minimizing consists of allocating a block of DOS memory (preferably
; high memory) and copying the resident part of the TSR into it.  The
; cloaking is done by marking the allocated memory block as part of the
; first process started, namely MSDOS.SYS.
;
; Blanks both VGA and Monochrome screens.  This will blank both screens
; if a VGA and MDA coexist.
;
; Revision History
;
; 1.00 First working version, does the job
; 1.01 Eats the keystroke it recieves to redisplay the screen
; 1.10 Gets the time before blanking from the command line
; 1.11 Updated Copyright to 1996

.model tiny
.386

; some defines to simplify writing the segment independent section

_count           equ (offset __count) - (offset _start)       
_offflag         equ (offset __offflag) - (offset _start)         
_waittime        equ (offset __waittime) - (offset _start)
_oldkbhandler    equ (offset __oldkbhandler) - (offset _start)         
_oldtimerhandler equ (offset __oldtimerhandler) - (offset _start)

; some defines for the command line params

_args   equ     81h

CR      equ     10
LF      equ     13

.code
.startup
        jmp _install

 _start:
 _newkbhandler:

        cmp     ah, 4Fh                                 ; our subfunction?
        jne     _donttouch
        cmp     byte ptr cs:[_offflag], 0               ; is screen off?
        je      _resetcounter                           ; no, leave off        
        test    al, 80h                                 ; is it a key up?
        mov     al, 0
        jz      _donttouch                              ; no? then we'll wait
        mov     word ptr cs:[_count], 0                 ; when the key comes up
        iret

 _resetcounter:
        mov     word ptr cs:[_count], 0                 ; when the key comes up
 _donttouch:
        jmp     dword ptr cs:[_oldkbhandler]

 _newtimerhandler:
	pushf
	call    dword ptr cs:[_oldtimerhandler]
	push    ax
	mov     ax, word ptr cs:[_count]
	cmp     ax, word ptr cs:[_waittime]
	jl      _on
	jmp short _off

 _on:   inc     word ptr cs:[_count]
	cmp     byte ptr cs:[_offflag], 0
	je      _exit
 
 _turnon:
	not     byte ptr cs:[_offflag]    ; turn on mono
	push    dx
	mov     dx, 3B8h
	in      al, dx
	or      al, 08h
	out     dx, al

	mov     dx, 3c4h             ; turn on VGA
	mov     al, 1
	out     dx, al
	inc     dx
	in      al, dx
	and     al, 0dfh
	out     dx, al
	pop     dx
	jmp short _exit

 _off:  cmp     byte ptr cs:[_offflag], 0
	jne     _exit     

 _turnoff:
	not     byte ptr cs:[_offflag] ; turn off mono
	push    dx
	mov     dx, 3B8h
	in      al, dx
	and     al, 0F7h
	out     dx, al
	
	mov     dx, 3c4h             ; turn off VGA
	mov     al, 1
	out     dx, al
	inc     dx
	in      al, dx
	or      al, 20h
	out     dx, al
	pop     dx

 _exit: pop     ax
	iret

	__oldkbhandler: dd 0
	__oldtimerhandler: dd 0
        __waittime: dw 5400
	__count: dw 0
	__offflag: db 0

 _end:
 _install:

        mov     savedpsp, es;

	; first thing to do is see if we've got a decent version of DOS
	mov     ah, 30h
	int     21h
	cmp     al, 5
	jg      _version_ok
	mov     ah, 9
	mov     dx, offset versionmsg
	int     21h
	mov     ax, 4c01h
	int     21h
 _version_ok:
	; free environment block
	mov     es, es:[2ch]            
	mov     ah, 49h
	int     21h                     

	; shrink ourselves so we can allocate memory via dos
	mov     bx, (offset _last_byte) + 16
	shr     bx, 4
	push    cs
	pop     es
	assume es:@code
	mov     ah, 4ah                  
	int     21h

        ; check for the command line arg to tell us how long before blanking

        mov     si, savedpsp
        mov     es, si
        assume es:nothing
        mov     si, _args
        xor     ax, ax
        mov     cx, 10
        xor     bx, bx
        
_beginwhile:                            ; translate the first number on the 
        mov     bl, es:[si]             ; command line into the time to wait
        cmp     bl, CR
        je      _endwhile
        cmp     bl, 20h                 ; check for space
        je      _incvariable
        cmp     bl, 09h                 ; check for tab
        je      _incvariable
        cmp     bl, '0'
        jl      _endwhile
        cmp     bl, '9'
        jg      _endwhile        
        mul     cx
        xor     dx, dx
        sub     bl, '0'
        add     ax, bx
        inc     si
        jmp     _beginwhile

_incvariable:
        cmp     ax, 0
        jne     _endwhile
        inc     si
        jmp     _beginwhile
_endwhile:
        cmp     ax, 0        
        je      _donewhile
        mov     bx, 18        
        mul     bx
        mov     word ptr cs:[__waittime], ax
_donewhile:

	; save access rights to the high memory area
	mov     ax, 5802h
	int     21h
	mov     dl, al

	; allow access to the high memory area
	mov     ax, 5803h
	mov     bx, 1
	int     21h

	; save the dos allocation strategy
	mov     ax, 5800h
	int     21h
	mov     dh, al

	; set the strategy so we get high memory blocks if we can 
	; (best fit first)

	mov     ax, 5801h
	mov     bl, 81h
	int     21h

	; allocate a dos memory block and copy the code and data into it
	mov     ah, 48h
	mov     bx, (((offset _end) - (offset _start)) / 16) + 2
	int     21h
	jnc      _memory_ok

	mov     dx, offset errmsg
	mov     ah, 9
	int     21h

	mov     ax, 4c01h
	int     21h
	
 _memory_ok:
	mov     es, ax        ; save the block we just got
	assume es:nothing

	; restore the dos allocation strategy
	mov     ax, 5801h
	mov     bl, dh
	int     21h

	; restore the upper memory link
	mov     ax, 5803h
	xor     bh, bh     
	mov     bl, dl
	int     21h

	xor     di, di
	mov     si, offset _start
	mov     cx, (offset _end) - (offset _start) + 1
	rep     movsb
	push    es        
	pop     ds              ; ds now points to the new block
	assume ds:nothing
	
	cli
        mov     ax, 3515h
	int     21h
	mov     word ptr ds:[_oldkbhandler], bx
	mov     word ptr ds:[_oldkbhandler+2], es

        mov     ax, 2515h
	mov     dx, (offset _newkbhandler) - (offset _start)
	int     21h

	mov     ax, 351ch
	int     21h
	mov     word ptr ds:[_oldtimerhandler], bx
	mov     word ptr ds:[_oldtimerhandler+2], es
	
	mov     ax, 251ch
	mov     dx, (offset _newtimerhandler) - (offset _start)
	int     21h      
	sti

	mov     ax, ds
	dec     ax
	mov     es, ax            ; es now points to the memory control block
	assume es:nothing
	push    cs
	pop     ds
	assume ds:@code
	
	; now we fool DOS into thinking that this block was created before 
	; the first user process was started, so it doesn't free it when we
	; terminate

	mov     di, 1
	mov     word ptr es:[di], 8 

	mov     di, 8
	xor     ax, ax
	mov     cx, 4
	rep     stosw
	
	mov     dx, offset loadmsg ; show a message saying we've installed! 
	mov     ah, 9
	int     21h

	mov    ax, 4c00h
	int    21h

loadmsg: db 'Blank-It v1.11, The Invisible Screen Saver!', CR, LF
         db 'Copyright 1995-1996 Don Neufeld.', CR, LF, '$'
errmsg: db 'Error allocating memory. Blank-It not installed.', CR, LF, '$'
versionmsg: db 'Blank-It requires DOS v5.0 or higher to run.', CR, LF, '$'

savedpsp dw ?        

_last_byte:

end
