comment $*********************************************************************

			 MEMALLOC.ASM

    Example using Peter Anderson's memory routines. DOS32 supports basic
memory manigment routines which are limited in a number of ways.
* No ore than 64 allocations should be made.
* Sizes are restriced to multiple of 4Kb blocks.
* They are relativly slow.

Peter's memory sub routines are in directory \pal\malloc\. These were
written for C applications are also ideal for use in pure ASM programs.
They will allow your programs to handle memory manigment
much more efficently than just the using DOS32 allocation routines.
Please read the README.TXT and the ASM files for more information of
using these functions. Below is a list of all the nessaccary files from 
PAL you will need to link;

malloc.obj
setmem.obj
memory.obj
calloc.obj   (optional)
resize.obj   (optional)
free.obj     (optional)
realloc.obj  (optional)
memcpy.obj   (optional)
memset.obj   (optional)

You may wan to combine all these obj files into a small libray file so
it easier and quicker to link in them.

	To build this program...

 tasm memalloc
 dlink -c memalloc memory free setmem malloc resize

Good luck.
*************************************************************************** $

.386

.MODEL FLAT, C                                  ; Define segments.

.STACK 1000h                                    ; Define initial stack.

.CODE

MemPtr	DD ?
intro_mesg LABEL BYTE
DB "MEMALLOC.EXE: example program using the sub-memory functions from",13,10
DB "              the PAL library. See source for info",13,10,36
exit_mesg  LABEL BYTE
DB " Everthing was successful ",13,10,36

ifdef masm
NoLanguage equ syscall
endif

;
; Define externals of all PAL memory routines.
;

extrn NoLanguage @malloc :Near
extrn NoLanguage @setmem :Near
extrn NoLanguage @free   :Near
extrn NoLanguage @realloc:Near
extrn NoLanguage @calloc :Near
extrn NoLanguage @resize :Near
extrn NoLanguage @maxavail:Near
extrn NoLanguage @memset :Near
extrn NoLanguage @memcpy :Near


My_program:                                     ; Start of program

    ; print a message to output
        mov edx,Offset intro_mesg
        mov ah,9
        int 21h


 ; Allocate a single DOS32 system memory block. This is the memory pool
 ; that the malloc routines will use. Please read README.TXT for more
 ; information on the @setmem function.
 ;
        mov edx,-1
        mov ax,0EE42h
        int 31h	                            ; Returns EDX -> block, EAX = size
        Test eax,eax
        jz @@ErrorExit

        xchg eax,edx
        call @setmem


;******* The PAL memory routines now ready for the application to use ******

	 ;--------- Allocate 100Kb ------------
        mov     eax,1024*100
        call    @malloc
        Test    eax,eax
        jz      @@ErrorExit
        mov	[MemPtr],eax

	 ;--------- Resize block to 77Kb  ------------
        mov     eax,[MemPtr]
        mov     edx,77*1024
        call    @resize
        Test    eax,eax
        jz      @@ErrorExit

	 ;--------- Free  ------------
        mov     eax,[MemPtr]
        call    @free


	 ;--------- print mesg  ------------
        mov edx,Offset exit_mesg
        mov ah,9
        int 21h


	 ;--------- Exit program  ------------

Exit:
        mov   ax,4C00h                          ; Termiate the program
        int   21h


        ;----- print an error mesage --------
err_msg db 'An error happened',13,10,36

@@ErrorExit:
        mov edx,Offset err_msg
        mov ah,9
        int 21h
        jmp Exit


END  My_program

