;**************************************************************************
;  TSR.ASM
;
; This program hooks the timer interrupt and stays resident.
;
;**************************************************************************
.386
.MODEL  FLAT
.STACK 
.CODE

saved_INT8              DF ?
mesg_tsr        	DB ' DOS32 TSR program resident ',10,13,36


StartIt:               


      ; *****************  print a message *****************

        mov edx,offset mesg_tsr
        mov ah,9
        int 21h                     ; print string




    ;********** Hook Timer inerrupt ( IRQ 0 )  ****************

        mov     bl,8                        ;Save IRQ 0 interrupt vector
        mov     ax,204h
        int     31h
        mov     dword ptr saved_INT8 , edx
        mov     word ptr saved_INT8+4 , cx

        mov     bl,8                      ; Set the new IRQ 0 vector
        mov     edx,offset  timer_int     ; See below
        mov     cx,cs                     ; CS:EDX = selector:offset
        mov     ax,205h
        int     31h

    ;
    ; ************* Terminate and stay resident ******************
    ;
        mov   ax,0ee30h
        int   31h


;
; *****************  IRQ 0  interrupt  handler *****************
;
timer_int:
        push  ds                        ; must save all registers used
        push  eax
        mov   ax,_TEXT
        mov   ds,ax                     ; Load DS with data selector
        inc   word ptr ds:[0b8000h]     ; increment character on the screen
                                        ; just to show it's doing something
        pop   eax
        pop   ds
        jmp   cs:saved_INT8             ; continue on interrupt chain.
                                        ; must use CS because DS is unknown

END StartIt
