;
;  A keyboard polling routine written by Jason Nunn
;
; requires DOS32 V3.5+
;
.386
.model flat
.code

public key_pressed,get_key


;*********************************************************************
;funciton:       key_pressed
;
;Description:   Detects if the BIOS keyboad buffer is empty.
;
;Returns:       Carry = 0 if key is empty
;               Carry = 1 if key is not empty
;*********************************************************************

;*********************************************************************
;funciton:       get_key
;
;Description:    gets the next key from the BIOS keyboad buffer.
;                if not availible then waits for one.
;Returns:       AL = ascii code
;               AH = scan code
;*********************************************************************

key_pressed Proc
  mov    ax,ds:[41ah]
  cmp    ax,ds:[41ah+2]
  jne    @@w
  clc
  ret
@@w:
  movzx  eax,ax
  mov    ax,ds:[400h+eax]
  stc
  ret
key_pressed endp

Align 4
get_key Proc
@@l:
  call   key_pressed
  jnc    @@l
  mov    eax,0
  int    16h
  mov    [last_get_key],al
  ret
get_key endp

last_get_key          db ?

end