;****************************************************************************
; Filename: LOADDLL.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.Dec.01
;  Updated: -
;****************************************************************************
; Copyright Adam Seychell, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: void* loadlibrary(char * filename, int seek);
;    Input: Eax = pointer to file name/path
;           Edx = number of bytes to seek from beginning of file
;   Output: pointer to public varible address or NULL if error
;           if [errno] = 1 then cannot open file.
;           if [errno] = 2 then library has bad format.
;           if [errno] = 3 then library if for different DOS32 version.
;           if [errno] = 4 not enough memory.
;  Comment: loads a DOS32 dynamic library file.
;****************************************************************************
; Function: int GetLibrarySize(void);
;    Input: nothing
;   Output: size of file.
;  Comment: returns the size of the previously loaded DOS32 dynamic library
;           file. Always sucessful.
;****************************************************************************
; Function: int GetLibraryMemSize(void);
;    Input: nothing
;   Output: size of file.
;  Comment: returns the size of the memory block require by the previously
;			loaded DOS32 dynamic library file. Always sucessful.
;****************************************************************************

        Include STDDEF.INC

        Codeseg


Proc    loadlibrary, 2
                Push    Ebx
                Mov     Ebx,Edx
                Mov     Edx,Eax
                Mov     AX,0EE10h       ; set up a library file
                Int     31h
                Mov     [_previous_library_file_size],Ebx
                Mov     [_previous_library_memory_size],Eax
                Pop     Ebx
                jc      @@error
                call    @malloc         ; allocate memory
                TestZ   Eax
                jz      @@memerror
                Mov     Edx,Eax         ; load in library file
                Mov     Ecx,Edx         ; save address
                Mov     AX,0EE11h
                Int     31h
                jc      @@errorload
                Mov     Eax,Edx
                Ret

@@errorload:
                Mov     dl,1
                Mov     Eax,Ecx          ; free data
                call    @free
@@memerror:
                Mov     dl,4
@@error:
                Clear   Eax
                Movzx   Edx,Dl
                Mov     [errno],Edx
                Ret
Endp


Proc    GetLibrarySize
                Mov     Eax,[_previous_library_file_size]
                Ret
Endp

Proc    GetLibraryMemSize
                Mov     Eax,[_previous_library_memory_size]
                Ret
Endp

      Dataseg

_previous_library_file_size   DD ?
_previous_library_memory_size   DD ?
        End
