ASC16    PROC     NEAR
;***************************************************************
;                    Converts a 16-bit signed integer to ASCII
;                    SI offset to integer; DI to last byte of 
;                    ASCII location. BX returns offset to first
;                    character (sign) of ASCII value
;***************************************************************
         PUSH     SI
         SUB      AX,AX           ;clear AX
         OR       AX,[SI]         ;get binary integer
;                            check sign
         MOV      SI," "          ;assume sign positive
         JNS      ASC16A
         MOV      SI,"-"          ;save negative sign
         NEG      AX              ;and make integer positive
;                            convert to ASCII decimal
ASC16A:  MOV      BX,DI           ;initial offset in BX
         MOV      CX,10           ;decimal 10 in CX
ASC16B:  SUB      DX,DX           ;clear DX
         DIV      CX              ;divide by 10
         ADD      DX,48           ;convert remainder to ASCII
         MOV      [BX],DL         ;save it
         DEC      BX              ;point to next position
         OR       AX,AX           ;if quotient is not zero
         JNZ      ASC16B          ;do it again
;                            set sign
         MOV      AX,SI           ;sign in AL
         MOV      [BX],AL         ;save it
;                              
         POP      SI
         RET
ASC16    ENDP