ASC_F    PROC     NEAR
;****************************************************************
;                    converts a binary floating point operand
;                    to ASCII decimal. SI points to f.p. number
;                    DI points to end of ASCII location. Returns
;                    offset to first character (sign) in BX
;****************************************************************
         PUSH     SI
         PUSH     DI
         SUB      DX,DX           ;clear DX & CX
         MOV      CX,DX
;                            check for zero
         MOV      AX,[SI]+2    
         OR       AX,AX
         JNZ      ASCF0
         JMP      ASCF11
ASCF0:   PUSH     BP              ;we'll use BP to address stack
;                            get sign
         MOV      BL," "          ;assume sign positive
         OR       AL,AL
         JNS      ASCF1 
         MOV      BL,"-"          ;sign is negative
ASCF1:   PUSH     BX              ;save sign
;                          compute LOG10(X)=LOG2(X)xLOG10(2)
;                               =(E-1) x 0.3 (approximately)
;                               do this in fixed point
         MOV      AL,AH           ;exponent in AX
         MOV      AH,DH
         SUB      AX,129          ;unbiased E=E-1 (E-128-1)
         JGE      ASCF2           ;if negative
         NEG      AX              ;make it positive
         DEC      CX              ;and set flag in CX
ASCF2:   MOV      BX,4CCDH        ;.3 decimal = .4CCD hex
         MUL      BX              ;U=E * LOG10(2) =DX.AX
         JCXZ     ASCF3           ;if E was negative
         NEG      DX              ;make U negative
;                          adjust for number of places
ASCF3:   SUB      DX,6            ;V=U+1-7
         MOV      CX,DX
         CMP      CX,-38          ;V < -38 will give overflow
         JGE      ASCF4
         MOV      CX,-38          ;so make it -38
;                          compute 10^V
ASCF4:   MOV      SI,OFFSET IM2   ;set pointers to parameter
         MOV      DI,OFFSET IM1   ;areas IM1 & IM2
ASCF5:   PUSH     CX              ;keep V--it is decimal exponent
         MOV      IM1,0           ;floating point ten in IM1
         MOV      IM1+2,8420H
         MOV      IM2,CX          ;V in IM2
         CALL     IPOWER_F        ;raise 10 to the V
;                          compute W=ABS(X)/10^V
         MOV      IM2,AX          ;10^V in IM2
         MOV      IM2+2,DX
         MOV      BP,SP
         MOV      BX,[BP]+4       ;get address of X from stack
         MOV      AX,[BX]         ;get f.p. operand X 
         MOV      DX,[BX]+2
         AND      DL,7FH          ;delete its sign--ABS(X)
         MOV      IM1,AX          ;and put it in IM1
         MOV      IM1+2,DX
         CALL     DIV_F           ;DX:AX=W=IM1/IM2=ABS(X)/10^V
         POP      CX              ;V in CX
;                           adjust W--maximum 7 digits
         CMP      DX,9818H        ;if W >= 10^7
         JA       ASCF6
         JB       ASCF7
         CMP      AX,9680H
         JB       ASCF7 
ASCF6:   ADD      CX,1            ;V=V+1
         JMP      ASCF5           ;do it again
ASCF7:   CMP      CX,-38          ;can V be decremented?
         JLE      ASCF9
         CMP      DX,9474H        ;if W <= 10^6-1
         JA       ASCF9
         JB       ASCF8
         CMP      AX,23F0H
         JA       ASCF9
ASCF8:   DEC      CX              ;V=V-1
         JMP      ASCF5           ;do it again
;                           convert to ASCII
ASCF9:   MOV      BP,SP
         MOV      DI,[BP]+4       ;point to ASCII location
         MOV      IM1,AX          ;W in IM1
         MOV      IM1+2,DX
         MOV      IM2,CX          ;exponent in IM2
         CALL     ASC16           ;convert exponent to ASCII      
         MOV      DI,BX           ;BX points to sign
         CMP BYTE PTR [DI]," "    ;if positive exponent
         JNE      ASCF10
         MOV BYTE PTR [DI],"+"    ;make sign explicit
ASCF10:  DEC      DI              ;point to next byte
         MOV BYTE PTR [DI],"E"    ;store the E
         DEC      DI              ;and point to next postion
;                            convert mantissa--W
         PUSH     DI
         MOV      DI,OFFSET IM1   ;point to W
         CALL     INT_F           ;convert W to two-word integer
         MOV      [DI],AX         ;integer W in IM1
         MOV      [DI]+2,DX
         MOV      SI,DI           ;W is second operand
         POP      DI              ;ASCII location is first
         CALL     ASC32           ;convert it
         POP      AX              ;get the sign
         MOV      [BX],AL         ;and store it
         POP      BP
         JMP      EXIT
;                            here for zero input
ASCF11:  MOV WORD PTR [DI],"0 "   ;this will be stored as " 0"
         MOV      BX,DI
         DEC      BX              ;offset in BX
         JMP      EXIT        
ASC_F    ENDP