BIN_F    PROC     NEAR
;*************************************************************
;                  converts an ASCII decimal number to 
;                  binary floating point
;                  Input--DI points to points to end of ASCII
;                         string; SI points to start
;*************************************************************
         PUSH     SI
         PUSH     DI
;                            convert ASCII mantissa to integer
         CALL     BIN32           ;integer in DX:AX
         OR       BX,BX           ;did it convert OK?
         JZ       BINF1           ;if error
         JMP      BINF9           ;jump
;                            check for zero result
BINF1:   MOV      BX,DX
         OR       BX,AX
         JNZ      BINF2           ;finished if zero
         JMP      BINF8 
;                            get sign
BINF2:   PUSH     CX              ;save count of decimal places
         SUB      CX,CX           ;assume positive sign
         OR       DX,DX
         JNS      BINF3
         DEC      CX              ;negative sign
         NOT      AX              ;make it positive
         NOT      DX
         ADD      AX,1
         ADC      DX,0
;                            convert 32-bit integer to f.p
BINF3:   MOV      BX,152          ;initial exponent=24+bias
         OR       DH,DH           ;if DH
         JZ       BINF4           ;is not zero
         XCHG     AH,AL           ;shift right 8 bits
         XCHG     DL,AH
         XCHG     DH,DL           ;integer now in DL:AX:DH
         ADD      BX,8            ;increment exponent
;                            normalize
BINF4:   OR       DL,DL
         JS       BINF5           ;if no sign bit
         SHL      DH,1            ;shift integer left
         RCL      AX,1
         RCL      DL,1
         DEC      BX              ;and decrement exponent
         JMP      BINF4
BINF5:   MOV      DH,BL           ;exponent in DH
;                            ;restore sign
         OR       CX,CX
         JNZ      BINF6
         AND      DL,07FH         ;make sign positive
BINF6:   PUSH     AX              ;save result--ASCII mantissa
         PUSH     DX
;                            check for exponent
         SUB      AX,AX           ;zero exponent
         MOV      DX,AX
         CMP      SI,DI           ;if at end of ASCII string
         JAE      BINF7           ;no ASCII exponent
         MOV      BL,[SI]         ;next unconverted char in BL
         OR       BL,32           ;convert to lower case
         CMP      BL,"e"          ;if not an "E"
         JNE      BINF7           ;there is no exponent
;                            convert exponent
         INC      SI              ;point to next char
         CALL     BIN32           ;convert exponent to binary
         OR       BX,BX           ;check for error
         JNZ      BINF9  
;                            check exponent range
         OR       DX,DX           ;DX should be zero if exponent
         JZ       BINF7           ;positive and less than 2^16
         CMP      DX,-1           ;or -1 if negative
         JNE      BINF9           ;jump if out of range
;                            apply exponent to mantissa
BINF7:   MOV      BX,AX           ;signed exponent in BX
         POP      DX              ;retrieve mantissa in DX:AX
         POP      AX
         POP      CX              ;count of decimal places
         ADD      BX,CX           ;subtract decimal places
         JZ       BINF8           ;finished if exponent is zero
;                            compute exponent power of 10
         PUSH     AX              ;save mantissa while we 
         PUSH     DX              ;compute exponent
         MOV      IM2,BX          ;integer exponent in IM2
         MOV      SI,OFFSET IM2   ;address in SI
         MOV      IM1,0           ;floating point 10
         MOV      IM1+2,8420H     ;in IM1
         MOV      DI,OFFSET IM1   ;address in DI
         CALL     IPOWER_F        ;compute exponent
         POP      [DI]+2          ;retrieve mantissa and 
         POP      [DI]            ;put it in IM1
         OR       BX,BX           ;check for errors
         JNZ      BINF9  

         MOV      IM2,AX          ;put exponent in IM2
         MOV      IM2+2,DX
;                            multiply mantissa x exponent
         CALL     MUL_F
         OR       BX,BX           ;check for errors
         JNZ      BINF9 
;                            exit with result in DX:AX
BINF8:   SUB      BX,BX           ;BX=0--status OK
         JMP      EXIT
BINF9:   MOV      BX,1            ;exit with error
         JMP      EXIT
BIN_F    ENDP