
'================================ D e m o ===================================

'            This program was written to test the BASM compiler.

Setup
Elements = LoadFileBuffer (Buffer$(),Mask$,1000)    '.. fill the buffer
Chosen   = ListBox(33,4,Buffer$(),15,Elements,12)   '.. do the magic!
ShowResult 
 
 
'================================= E n d =================================== 

 
 
 
 

'========================================================================= 
FUNCTION ListBox (X,Y,A$(),WinSize,Elements,Width) 
'========================================================================= 

'X............top left corner of Box Col Position
'Y............top left corner of Box Row Position 
'A$().........any single string array
'WinSize......number of data rows to display 
'Elements.....total Number of elements within array to manipulate
'Width........displayable length of each maximum array element
 
'============================================================================
LOCAL  Tmp$        ' temporary 
LOCAL  TheTop      ' top data display line coordinate 
LOCAL  TheBottom   ' bottom data display line coordinate 
LOCAL  Rows        ' Number of displayable Rows between top & bottom 
LOCAL  CurX        ' X coordinate For the Cursor
LOCAL  CurY        ' Y coordinate For the Cursor 
LOCAL  Index       ' pointer into array
LOCAL  Ylimit      ' temporary
LOCAL  Ypos        ' temporary
LOCAL  XX          '
LOCAL  YY          '
LOCAL  Tmp         '
LOCAL  Z           ' temporary loop counter
LOCAL  Count       ' temporary loop counter
LOCAL  RX          ' Right Column Position of Frame
LOCAL  RY          ' Right Row Position of Frame
LOCAL  ShowRows    ' Adjusts the displayable window size for small dir's
'============================================================================

IF WinSize > Elements THEN
  ShowRows = Elements
Else
  ShowRows = WinSize
END IF

XX = X + 1
YY = Y + 1
TheTop = YY
TheBottom = YY + ShowRows -1
CurX = XX
CurY = YY
Index = 1

Ylimit = ShowRows + YY - 1
Rows = TheBottom - TheTop + 1

'========================= Draw a frame around the data ===================

COLOR 0,7
RX = X + Width + 1
RY = Y + ShowRows +1
FRAME (X,Y,RX,RY)

'=====================[ t h e  m a i n  e v e n t !  ]=====================
DO
  GOSUB MoveCursor

  Keypress = GetKey

  SELECT CASE Keypress

    CASE 13                                     'enter Key

    ListBox=Index
    EXIT FUNCTION


    CASE -81                                    'page down

    FOR Z=1 TO ShowRows
      INCR Index
      IF Index > Elements THEN
        Index  = Elements
      END IF
      INCR CurY
      IF CurY > Ylimit THEN
        CurY  = Ylimit
      END IF
    NEXT


    CASE -73                                      'page up
    FOR Z = 1 TO ShowRows
      DECR Index
      IF Index < 1 THEN
        Index  = 1
      END IF
      DECR CurY
      IF CurY < YY THEN
        CurY  = YY
      END IF
      IF Index >= ShowRows THEN
        INCR CurY
      END IF
    NEXT


    CASE -72                                      'up arrow
    DECR Index
    IF Index < 1 THEN
      Index  = 1
    END IF
    DECR CurY
    IF CurY < YY THEN
      CurY = YY
    END IF
    IF Index >= ShowRows THEN
      INCR CurY
    END IF


    CASE -80                                      'down arrow
    INCR Index
    IF Index > Elements THEN
      Index  = Elements
    END IF
    INCR CurY
    IF CurY > Ylimit THEN
      CurY  = Ylimit
    END IF
  END SELECT
LOOP

'==========================  manipulate the Cursor  =========================

MoveCursor:

GOSUB RefreshDisplay
COLOR 7,0
LOCATE CurY,CurX,0
Tmp$ = SPACE$(Width)
PRINT Tmp$
Tmp$ = A$(Index)
COLOR 7,0
LOCATE CurY,CurX
PRINT Tmp$
COLOR 0,7
RETURN

'=====================  Display the data column(s)  =========================

RefreshDisplay:

IF Index <= ShowRows THEN
  FOR Count= 1 to Rows
    Ypos = YY - 1 + Count
    Tmp$ = A$(Count)
    Tmp  = LEN(Tmp$)
    Tmp  = Width - Tmp
    Tmp$ = Tmp$ + SPACE$(Tmp)
    LOCATE Ypos,XX
    PRINT Tmp$
  NEXT
ELSE
  FOR Count= TheTop to TheBottom
    Tmp = Index - TheTop + Count - ShowRows + 1
    Tmp$ = A$(Tmp)
    Tmp  = LEN(Tmp$)
    Tmp  = Width - Tmp
    Tmp$ = Tmp$ + SPACE$(Tmp)
    LOCATE Count,XX
    PRINT Tmp$
  NEXT
END IF
RETURN
'============================================================================
END FUNCTION






FUNCTION LoadFileBuffer (Buf$(),Mask$,MaxAllowed)
LOCAL A$,Count

'============================================================================
'Buf$() will receive the Directory files
'Mask$ is the search file specification
'MaxAllowed is used to protect against memory overwrites
'returns the number of files Buf$() received
'============================================================================

A$=DIR$(Mask$,0)

IF Err THEN
 COLOR 0,7
 FRAME 1,1,80,5
 LOCATE 2,2
 PRINT "Usage: FILEBOX  [Drive:] \ [Directory] \ FileName.Ext
 LOCATE 3,2
 PRINT "FileName and Ext must be specified. ( Wildcards are allowed. )
 LOCATE 4,2,1
 PRINT "[Drive] and [directory] are optional. Example: FILEBOX C:\DOS\*.SYS
 END
END IF

WHILE A$ > ""
 INCR Count
 Buf$ (Count) = A$
 A$ = DIR$
 IF Count = MaxAllowed THEN
  EXIT WHILE
 END IF
WEND

LoadFileBuffer = Count
END FUNCTION




Sub ShowResult
Result$  = Space$(78)
LOCATE 2,2
PRINT Result$
Result$ =  Buffer$(Chosen)       '.. You picked this one!
LOCATE 2,3,1
PRINT "You selected ";Result$
Result$ = Space$(80)
COLOR 7,0
LOCATE 4,1,0
FOR A = 4 TO 23
 PRINT Result$                           '.. Recycle this variable
NEXT
LOCATE 3,3,1
Print ;
END SUB



SUB Setup
DIM Buffer$(13,1000)                         '.. will hold 1000 filenames
CLS                                          '.. clear screen
Mask$ = Command$
IF Mask$ = "" THEN
 Mask$ = "*.*"                              '.. default filespec
END IF
COLOR 0,7
LOCATE 1,1,0
END SUB
