 Rem dndutil.bas v2.9c
 Rem $Include: 'dndbbs.inc'

 Rem Purpose: Utility program to be shelled to or called from DOS to
 Rem    create bulletin files for your main BBS using dndbbs as a door.

 On Error Goto 10002
 Select Case Command$
 Case "/L"
    TempA=False
 Case "/P"
    TempA=True
 Case Else
    Print "DNDUTIL Usage:"
    Print "   DNDUTIL (option)"
    Print "        where option is:"
    Print "        /L makes report files, or"
    Print "        /P makes & prints reports."
    End
 End Select
 Call Read.Config
 If Data.Error Then
    Strng="Error reading "+FileName+". Writing configure file."
    Print Strng
    Call Write.Config
    Call Read.Config
    If Data.Error Then
       Strng="Error writing "+FileName+". Aborting program."
       Print Strng
       End
    Endif
 Endif
 Call Top.Ten
 Call User.List
 Call Last.User
 Strng="Bulletin files created."
 Print Strng
10001
 End
10002
 Strng="Error in dndutil. Quitting."
 Print Strng
 Resume 10001

Sub Read.Config
 On Local Error Goto 10004
 DND.Path=Environ$("DNDBBS")
 If DND.Path<>Nul Then
    If Right$(DND.Path,1)<>"\" Then
       DND.Path=DND.Path+"\"
    Endif
 Endif
 Restore Config.Array.Data
 For Temp=1 To 8
    Read Race(Temp)
 Next
 FileName="dndutil.cfg"
 Close
 Data.Error=False
 Open DND.Path+FileName For Input Shared As #1
 Line Input #1,TempX$
 Line Input #1,TempX$
 Line Input #1,TempA$ ' User.Dat file (input)
 Line Input #1,TempX$
 Line Input #1,TempB$ ' Top ten rank bulletin file (output)
 Line Input #1,TempX$
 Line Input #1,TempC$ ' User list bulletin file (output)
 Line Input #1,TempX$
 Line Input #1,TempD$ ' Lastuser.Dat file (input)
 Line Input #1,TempX$
 Line Input #1,TempX$ ' Last user bulletin file (output)
 Line Input #1,TempZ$
10003
 Exit Sub
10004
 Data.Error=True
 Resume 10003
End Sub

Sub Write.Config
 On Local Error Goto 10006
 Close
 Data.Error=False
 Restore Config.Data
 Open DND.Path+FileName For Output Shared As #1
 For Temp=1 To 12
    Read Temp$
    Print #1,Temp$
 Next
10005
 Exit Sub
10006
 Data.Error=True
 Resume 10005
End Sub

Sub Top.Ten
 On Local Error Goto 10015
 Close
10007
 Data.Error=False
 Open TempA$ For Random Shared As #1 Len=Len(UserRecord)
 Open TempB$ For Output Shared As #2
10008
 If Data.Error Then
    Strng="Error opening "+TempB$+". Edit DNDUTIL.CFG."
    Print Strng
    End
 Endif
 Print "Writing Top Ten report."
 TempX=Lof(1)/Len(UserRecord)
 Redim Temp.Array1(1 To TempX) As Integer,_
       Temp.ArrayZ(1 To TempX) As Double
 Strng="DNDBBS V"+Version$+" Top Ten Player Rankings For "+_
 Left$(FNclock$,13)+"."
 Print #2,Strng
 Strng=Nul
 Print #2,Strng
 TempZ=False
 For Temp.User.Index=1 To TempX
    Get 1,Temp.User.Index,UserRecord
    Strng=UserRecord.CodeName
    Call Decrypt(Strng)
    If (UserRecord.Flags And Locked.User)=False Then
       If Left$(Strng,9)<>Deleted$ Then
          If UserRecord.Level>1 Then
             TempZ=TempZ+1
             Temp.Array1(TempZ)=Temp.User.Index
10009        TempA#=UserRecord.PlayersKilled*UserRecord.Level*2+_
             UserRecord.MonstersKilled*UserRecord.Level
10010        Temp.ArrayZ(TempZ)=TempA#
          Endif
       Endif
    Endif
 Next
 TempQ=4
 While TempQ<=TempZ
    TempQ=TempQ*2
 Wend
 TempQ=Int((TempQ-1)/2)
 While TempQ>False
    For Var=1 To TempZ-TempQ
       VarX=Var
       While VarX>False
          If Temp.ArrayZ(VarX)<Temp.ArrayZ(VarX+TempQ) Then
             Swap Temp.Array1(VarX),Temp.Array1(VarX+TempQ)
             Swap Temp.ArrayZ(VarX),Temp.ArrayZ(VarX+TempQ)
             VarX=VarX-TempQ
          Else
             VarX=False
          Endif
       Wend
    Next
    TempQ=Int(TempQ/2)
 Wend
 If TempZ>10 Then
    TempZ=10
 Endif
 Strng="Username                      Level Classname            Ranking"
 Print #2,Strng
 Strng=String$(64,"-")
 Print #2,Strng
 TempX=False
 For Temp1=1 To TempZ
    Get 1,Temp.Array1(Temp1),UserRecord
    Strng=UserRecord.CodeName
    Call Decrypt(Strng)
    Strng=Lcase$(Strng)
    Mid$(Strng,1,1)=Ucase$(Mid$(Strng,1,1))
    If UserRecord.Level>32000 Then
       Strng=Strng+"Ghod  "
    Else
       Strng=Strng+Str$(UserRecord.Level)
       Strng=Strng+Space$(6-Len(Str$(UserRecord.Level)))
    Endif
    Out2=UserRecord.ClassName
    Call Decrypt(Out2)
    Strng=Strng+Out2
    TempX=True
    Strng=Strng+Str$(Temp.ArrayZ(Temp1))
    Print #2,Strng
 Next
 If TempX=False Then
    Strng="No users have top scores."
    Print #2,Strng
 Endif
 Close
 If TempA Then
    Open TempB$ For Input Shared As #1
    Do Until Eof(1)
       Line Input #1,Strng
       Lprint Strng
    Loop
    Lprint Chr$(12);
 Endif
10014
 Exit Sub
10015
 If Erl=10007 Then
    Data.Error=True
    Resume 10008
 Endif
 If Erl=10009 Then
    Resume 10010
 Endif
 Resume 10014
End Sub

Sub User.List
 On Local Error Goto 10019
 Close
10016
 Data.Error=False
 Open TempA$ For Random Shared As #1 Len=Len(UserRecord)
 Open TempC$ For Output Shared As #2
10017
 If Data.Error Then
    Strng="Error opening "+TempC$+". Edit DNDUTIL.CFG."
    Print Strng
    End
 Endif
 Print "Writing User List report."
 Strng="DNDBBS V"+Version$+" User List For "+Left$(FNclock$,13)+"."
 Print #2,Strng
 Strng=Nul
 Print #2,Strng
 Strng="Number User Name                      Class Name"
 Strng=Strng+"           Race     Level"
 Print #2,Strng
 Strng=String$(73,"-")
 Print #2,Strng
 For Temp.User.Index=1 To Lof(1)/Len(UserRecord)
    Get 1,Temp.User.Index,UserRecord
    Strng=UserRecord.CodeName
    Call Decrypt(Strng)
    If Left$(Strng,9)<>Deleted$ Then
       If (UserRecord.Flags And Locked.User)=False Then
          Strng=Mid$(Str$(Temp.User.Index),2)+"."
          Strng=Strng+Space$(7-Len(Strng))
          Out2=UserRecord.CodeName
          Call Decrypt(Out2)
          Strng=Strng+Out2+" "
          Out2=UserRecord.ClassName
          Call Decrypt(Out2)
          Strng=Strng+Out2+" "
          If UserRecord.Race<1 Then
             UserRecord.Race=1
          Endif
          Out2=Race(UserRecord.Race)
          Out2=Rtrim$(Out2)
          Out2=Out2+Space$(8-Len(Out2))
          Strng=Strng+Out2
          If UserRecord.Level<=False Then
             Out2=" -dead-"
          Else
             Out2=Str$(UserRecord.Level)
          Endif
          Out2=Out2+Space$(7-Len(Out2))
          If UserRecord.ClassType>8 Then
             Out2=Out2+"*"
          Endif
          Strng=Strng+Out2
          Print #2,Strng
       Endif
    Endif
 Next
 Close
 If TempA Then
    Open TempC$ For Input Shared As #1
    Do Until Eof(1)
       Line Input #1,Strng
       Lprint Strng
    Loop
    Lprint Chr$(12);
 Endif
10018
 Exit Sub
10019
 If Erl=10016 Then
    Data.Error=True
    Resume 10017
 Endif
 Resume 10018
End Sub

Sub Last.User
 On Local Error Goto 10024
 Close
10021
 Data.Error=False
 Open TempD$ For Input Shared As #1
 Open TempX$ For Output Shared As #2
10022
 If Data.Error Then
    Strng="Error opening "+TempD$+". Edit DNDUTIL.CFG."
    Print Strng
    End
 Endif
 Print "Writing Last User report."
 Strng="DNDBBS V"+Version$+" Last User For "+Left$(FNclock$,13)+"."
 Print #2,Strng
 Strng=Nul
 Print #2,Strng
 Strng="# Username                      Room"
 Strng=Strng+"  Timeon   Timeoff  Total    Score"
 Print #2,Strng
 Strng=String$(70,"-")
 Print #2,Strng
 Redim Temp.ArrayS(1 To 5) As String
 Temp1=False
 Do While Not Eof(1)
    Line Input #1,TempZ$
    Temp1=Temp1+1
    If Temp1>5 Then
       Temp1=5
       For Temp2=1 To 4
          Temp.ArrayS(Temp2)=Temp.ArrayS(Temp2+1)
       Next
    Endif
    Temp.ArrayS(Temp1)=TempZ$
 Loop
 If Temp1>5 Then
    Temp1=5
 Endif
 For Temp2=1 To Temp1
    Strng=Mid$(Str$(Temp2),2)+" "+Temp.ArrayS(Temp2)
    Print #2,Strng
 Next
 Close
 If TempA Then
    Open TempX$ For Input Shared As #1
    Do Until Eof(1)
       Line Input #1,Strng
       Lprint Strng
    Loop
    Lprint Chr$(12);
 Endif
10023
 Exit Sub
10024
 If Erl=10021 Then
    Data.Error=True
    Resume 10022
 Endif
 Resume 10023
End Sub

Sub Decrypt(Var$)
 On Local Error Goto 10042
 Var1$=Nul
 For Var=1 To Len(Var$) Step 2
    Var1=Cvi(Mid$(Var$,Var,2))
    Var2=Var1\100
    VarA=Var1-Var2*100
    Var1=Var2
    VarA=VarA+32
    Var2=Var1\100
    VarB=Var1-Var2*100
    VarB=VarB+32
    If Var2=0 Then
       If ((VarA+VarB)/2)=((VarA+VarB)\2) Then
          Var$=Nul
          Exit Sub
       Endif
    Endif
    If Var2=1 Then
       If ((VarA+VarB)/2)<>((VarA+VarB)\2) Then
          Var$=Nul
          Exit Sub
       Endif
    Endif
    Var1$=Var1$+Chr$(VarB)+Chr$(VarA)
 Next
 Var$=Var1$
10041
 Exit Sub
10042
 Resume 10041
End Sub

Config.Data:
 Data "'Editable configure file for dndutil:"
 Data "'Datapath\filename for users.dat file(input)"
 Data "\dnd\data\users.dat"
 Data "'Datapath\filename for user list file(output)"
 Data "\dnd\userlist.txt"
 Data "'Datapath\filename for top ten file(output)"
 Data "\dnd\ranklist.txt"
 Data "'Datapath\filename for lastuser.dat file(input)"
 Data "\dnd\data\lastuser.dat"
 Data "'Datapath\filename for last five users file(output)"
 Data "\dnd\lastlist.txt"
 Data "'End of configure file."

Config.Array.Data:
 Data "Human","Elf","Gnome","Dwarf","Halfling","Half-elf","Half-orc","Ogre"
