' Hey you!  Yeah, you!  Read this stuff!  I KNOW you were just going to skip
' it all!  Don't try to lie!  Admit it!  C'mon!  No?  Fine then!  Just keep
' tricking yourself into believing you were REALLY going to read this.  While
' you do that...Read this stuff!  :)

' Alright, I've discovered a way to make Role Playing Games (RPGs) in QBasic
' REALLY easily!  Instead of keeping this code all to myself (nyeheheheh), I
' have decided to share my knowledge with everyone!  I hope that ALL these
' comments explain what you need to know, because I spent a heck of a long
' time making them!  (I really hate commenting my programs!)  :)  If you are
' one of those people who haven't yet discovered SUBs (I was once like that),
' don't look at this and say, "Hey...Where's the program?"  Instead, hit the
' F2 key and check out all the SUBs.  :)  If you run this program, you should
' have an example of what the code can do.  I was going to make a bit of a
' game, but between school and stuff, I haven't got much time.  So, the "game"
' is basically a example of all the cool stuff I put in!  :)  Well, I'm
' probably babbling on and on, and you're probably eager to get to the code,
' so I'll let you do that now!  Just one thing...If you're doing graphics,
' find a WAY easier way to do it!  I used a bunch of annoying DRAW and LINE
' etc. commands.  It works, but it takes a long time to do.  If I may make a
' suggestion, get a sprite editor for QBasic!  (Might I suggest JSprite?  I
' made that pretty much for that purpose!)  :)  Okay, well, here's the LAST
' little bit of stuff...

' Take ANYTHING you want from this code!  Take parts, take SUBs, take some
' techniques, take ANYTHING!  That's why I made the darn thing!  You need
' not give me credit, either!  If you feel like it (maybe you're doing a
' credits screen), then throw me in there, but if not, then don't!  I just
' want people to make really good games!  "Why?" you might be asking.  So I
' can play them!  :)
'                                                                   - Jeff

' One LAST thing!  (Ha, thought I was done?)  If you have ANY questions, or
' comments, or ideas, or whatever, you can E-Mail me at:
'                               jhangart@oanet.com
' ...and I'll be REALLY happy to answer ANYTHING at all!  "Why?" you may ask
' once more.  Because that means that you've used this program!  :)

' Okay, I'm really done this time!  :)

DECLARE SUB WriteText ()                ' These are all the SUBs
DECLARE SUB CheckTileSpace ()           '
DECLARE SUB CheckTileDown ()            '
DECLARE SUB CheckTileRight ()           '
DECLARE SUB CheckTileLeft ()            '
DECLARE SUB CheckTileUp ()              '
DECLARE SUB DrawPlayer ()               '
DECLARE SUB LoadGraphics ()             '
DECLARE SUB DrawScreen ()               '
DECLARE SUB OpenMap ()                  '
DECLARE SUB LoadMap ()                  '

COMMON SHARED ppx, ppy, pmx, pmy, mapx, mapy, map$, tileup, tiledown, tileright, tileleft, text$, morearrow, warptomap2
' This above line makes all of these variable accessable to any of the SUBs.
' without this, the variables would be changed to 0 if you tried to use one
' in a SUB.  Here's a list of the variables :

' ppx        : The player's permanent X position
' ppy        : The player's permanent Y position
' pmx        : The player's map X position
' pmy        : The player's map Y position
' mapx       : The number of tiles on the map (Horizontally)
' mapy       : The number of tiles on the map (Vertically)
' map$       : The name of the map to load
' tileup     : The tile above the player when they hit space
' tiledown   : The tile below the player when they hit space
' tileright  : The tile to the right of the player when they hit space
' tileleft   : The tile to the left of the player when they hit space
' text$      : The text to display with the scrolling technique
' morearrow  : Whether or not to put the down arrow during text scrolling
' warptomap2 : Tells the program to load MAP2.MAP

SCREEN 13                               ' Change to VGA (320x200, 256 colors)

DIM SHARED blank(57), grass(57), wall(57), player(57), playermask(57), tree(57), wizard(57), downarrow(57)
' The above defines arrays for each graphic.  For each, it reserves 57 bytes.
' 57 is just enough for a 15x15 square of pixels.  If you had a different size
' of tiles, then you'd have to change this.

ppx = 150                               ' These two put the player in the
ppy = 85                                ' middle of the screen.
pmx = 13                                ' Starts the player off at 13,8 on
pmy = 8                                 ' the map.
map$ = "MAP1.MAP"                       ' Sets the first map to MAP1.MAP

LoadGraphics                            ' Runs the LoadGraphics SUB

OpenMap                                 ' Runs the OpenMap SUB
REDIM SHARED map(mapx, mapy)            ' REDIMs the array called map, and
                                        ' makes it the size of mapx and mapy
                                        ' which are defined in the .MAP file.
                                        ' This MUST go in the MAIN SUB,
                                        ' because the command REDIM won't work
                                        ' in a SUB.  Why?  I don't know!
LoadMap                                 ' Runs the LoadMap SUB
DrawScreen                              ' Runs the DrawScreen SUB
DrawPlayer                              ' Runs the DrawPlayer SUB

MovementCode:                           ' The MovementCode label.  Usually,
                                        ' this is only gone to if something on
                                        ' the screen changes, otherwise there
                                        ' is no point in redrawing everything.

IF warptomap2 = 1 THEN                  ' If the warptomap2 flag is on THEN
warptomap2 = 0                          ' Set it back to 0 so it doesn't keep
                                        ' doing this over and over.
pmx = 6                                 ' Set the NEW pmx and pmy position for
pmy = 5                                 ' the new map.
map$ = "MAP2.MAP"                       ' Next time it loads a map, it will
                                        ' load up MAP2.MAP
OpenMap                                 ' Runs the OpenMap SUB
REDIM SHARED map(mapx, mapy)            ' REDIMs map to the NEW mapx, mapy
LoadMap                                 ' Runs the LoadMap SUB
END IF                                  ' ENDs the "IF warptomap2 = 1 THEN" IF

DrawScreen                              ' Runs the DrawScreen SUB
DrawPlayer                              ' Runs the DrawPlayer SUB

'LOCATE 21, 1                            ' This part is for debugging.  This
'PRINT pmx; " "; pmy                     ' just prints your map position.

DO                                      ' Start the DO:LOOP
kbd$ = INKEY$                           ' This command gives the user an
                                        ' opportunity to hit a key.
IF kbd$ <> "" THEN                      ' If they hit a key...
kbd$ = RIGHT$(kbd$, 1)                  ' Get rid of the CHR$(0) + stuff.
SELECT CASE kbd$                        ' SELECT the CASE

CASE CHR$(27)                           ' Esc Key
END                                     ' END  :)

CASE CHR$(32)                           ' Space Bar
tileup = map(pmx, pmy - 1)              ' gets the number tile above.
tiledown = map(pmx, pmy + 1)            ' gets the number tile below.
tileright = map(pmx + 1, pmy)           ' gets the number tile to the right.
tileleft = map(pmx - 1, pmy)            ' gets the number tile to the left.
CheckTileSpace                          ' Runs the CheckTileSpace SUB
GOTO MovementCode                       ' Go to the label.

CASE CHR$(72)                           ' Up Arrow
pmy = pmy - 1                           ' Decrease the player's map Y position
                                        ' by 1.
CheckTileUp                             ' Runs the CheckTileUp SUB
GOTO MovementCode                       ' Go to the label.

CASE CHR$(80)                           ' Down Arrow
pmy = pmy + 1                           ' Increase the player's map Y position
                                        ' by 1.
CheckTileDown                           ' Runs the CheckTileDown SUB
GOTO MovementCode                       ' Go to the label.

CASE CHR$(77)                           ' Right Arrow
pmx = pmx + 1                           ' Increase the player's map X position
                                        ' by 1.
CheckTileRight                          ' Runs the CheckTileRight SUB
GOTO MovementCode                       ' Go to the label.

CASE CHR$(75)                           ' Left Arrow
pmx = pmx - 1                           ' Decrease the player's map X position
                                        ' by 1.
CheckTileLeft                           ' Runs the CheckTileLeft SUB
GOTO MovementCode                       ' Go to the label.

END SELECT                              ' END the SELECT CASE
END IF                                  ' END the "IF kbd$ <> "" THEN" SUB
LOOP                                    ' LOOP back to DO

SUB CheckTileDown

tile = map(pmx, pmy)                    ' Gets the number of the tile the
                                        ' player is standing on.  Note : The
                                        ' player hasn't been drawn yet, so
                                        ' this is the spot where he WILL be.
                                        ' Unless something it hit he will be
                                        ' drawn here.

IF tile = 0 OR tile = 2 OR tile = 3 OR tile = 4 THEN
' This above line can be added on to.  If the user will be standing on a
' 0 (blank) or a 2 (wall) or a 3 (tree) or a 4 (wizard) THEN...

pmy = pmy - 1                           ' Decrease the player's map Y position
                                        ' by 1, cancelling out the increase
                                        ' before this SUB was run.
SOUND 80, 1                             ' Make that annoying bumping sound.
END IF                                  ' END the "If tile = # THEN" IF

END SUB

SUB CheckTileLeft

tile = map(pmx, pmy)                    ' Gets the number of the tile the
                                        ' player is standing on.  Note : The
                                        ' player hasn't been drawn yet, so
                                        ' this is the spot where he WILL be.
                                        ' Unless something it hit he will be
                                        ' drawn here.

IF tile = 0 OR tile = 2 OR tile = 3 OR tile = 4 THEN
' This above line can be added on to.  If the user will be standing on a
' 0 (blank) or a 2 (wall) or a 3 (tree) or a 4 (wizard) THEN...

pmx = pmx + 1                           ' Increase the player's map X position
                                        ' by 1, cancelling out the decrease
                                        ' before this SUB was run.
SOUND 80, 1                             ' Make that annoying bumping sound.
END IF                                  ' END the "If tile = # THEN" IF

END SUB

SUB CheckTileRight

tile = map(pmx, pmy)                    ' Gets the number of the tile the
                                        ' player is standing on.  Note : The
                                        ' player hasn't been drawn yet, so
                                        ' this is the spot where he WILL be.
                                        ' Unless something it hit he will be
                                        ' drawn here.

IF tile = 0 OR tile = 2 OR tile = 3 OR tile = 4 THEN
' This above line can be added on to.  If the user will be standing on a
' 0 (blank) or a 2 (wall) or a 3 (tree) or a 4 (wizard) THEN...

pmx = pmx - 1                           ' Decrease the player's map X position
                                        ' by 1, cancelling out the increase
                                        ' before this SUB was run.
SOUND 80, 1                             ' Make that annoying bumping sound.
END IF                                  ' END the "If tile = # THEN" IF

END SUB

SUB CheckTileSpace

text$ = "                                      -                                      "
' This above line is just for reference of the length of text.  The - marks
' the last letter that will appear on that line.  After that, the rest goes on
' the next line.  See like what I wrote down below...

IF tileup = 4 OR tiledown = 4 OR tileright = 4 OR tileleft = 4 THEN
' The above line checks if the wizard is above, below, or to the left or right
' of the player.

SOUND 1000, 1                           ' High-pitched BEEP.
text$ = "Good day to you.  My name is Merklin,  and I am a magician!  I will soon warp"
' The above is text.

morearrow = 1
' Tell the program to put the down arrow at the end because there's more text
' to come.

WriteText
' Runs the WriteText SUB

text$ = "you to another world, to show that withthis RPG code, you can load up more"
morearrow = 1
WriteText
text$ = "than one .MAP file!  But first, I wouldlike to point out that if you look at"
morearrow = 1
WriteText
text$ = "the bottom of these words, you see an  arrow pointing down.  This arrow means"
morearrow = 1
WriteText
text$ = "that there's more text, and is set by  the variable `morearrow'.  For more"
morearrow = 1
WriteText
text$ = "information, look at the CheckTileSpaceSUB in the code!  When you are at the"
morearrow = 1
WriteText
text$ = "end of a conversation, the last bit of writing won't have an arrow.  This"
morearrow = 1
WriteText
text$ = "just tells you that what you're lookingat is the last phrase."
morearrow = 1
WriteText
text$ = "And now, I shall teleport you.  This   won't look really spiffy, because it"
morearrow = 1
WriteText
text$ = "takes a while to program in effects.   But what WILL happen, is the program"
morearrow = 1
WriteText
text$ = "will load up MAP2.MAP!  Bye!"
WriteText

' Note that on this last phrase, there's no "morearrow = 1".  That way, the
' down arrow won't show up.

PLAY "O1 L20 C D E F G A B"             ' REALLY pathetic song.  :)
warptomap2 = 1                          ' Next time it goes through the MAIN
                                        ' SUB, it'll see that the warptomap2
                                        ' flag is on.
END IF                                  ' END the "IF near wizard" IF

END SUB

SUB CheckTileUp

tile = map(pmx, pmy)                    ' Gets the number of the tile the
                                        ' player is standing on.  Note : The
                                        ' player hasn't been drawn yet, so
                                        ' this is the spot where he WILL be.
                                        ' Unless something it hit he will be
                                        ' drawn here.

IF tile = 0 OR tile = 2 OR tile = 3 OR tile = 4 THEN
' This above line can be added on to.  If the user will be standing on a
' 0 (blank) or a 2 (wall) or a 3 (tree) or a 4 (wizard) THEN...

pmy = pmy + 1                           ' Increase the player's map Y position
                                        ' by 1, cancelling out the decrease
                                        ' before this SUB was run.
SOUND 80, 1                             ' Make that annoying bumping sound.
END IF                                  ' END the "If tile = # THEN" IF

END SUB

SUB DrawPlayer

PUT (ppx, ppy), playermask, AND         ' Puts the mask of the player using
                                        ' AND.
PUT (ppx, ppy), player, OR              ' Puts the player using OR.

' "Why did you do that?" you may ask.  What happens is that in playermask, the
' background color is color 255, and in player, the background color is 0.
' When displayed like this (mask using AND, then the sprite using OR), any
' pixel on the mask that is color 255 will dissapear, leaving the background
' behind it.  If you were to JUST display the player sprite using PSET, then
' you would get an annoying black box behind the player.  So when you make a
' graphic that you want to have maybe a hole in it or something, you need to
' do a mask for it.  See the LoadGraphics SUB...

END SUB

SUB DrawScreen

FOR x = -5 TO 5                         ' From 5 blocks above the player's
                                        ' map position, to 5 blocks below...
FOR y = -4 TO 4                         ' From 4 blocks to the left of the
                                        ' player's map position, to 4 blocks
                                        ' to the right...
tile = map(pmx + x, pmy + y)            ' If pmx were 5, pmy were 5, x were -3
                                        ' and y were -3, then the program
                                        ' would display the block at 2,2 in
                                        ' the map array.
spotx = ppx + x * 15                    ' This is the X spot for the tile to
                                        ' be put at.  The permanent X, plus
                                        ' the x up above, times 15 (for the
                                        ' tiles are 15x15 blocks)
spoty = ppy + y * 15                    ' This is the Y spot for the tile to
                                        ' be put at.  The permanent Y, plus
                                        ' the y up above, times 15 (for the
                                        ' tiles are 15x15 blocks)
IF tile = 0 THEN PUT (spotx, spoty), blank, PSET
' If the number is a 0, then put a blank

IF tile = 1 THEN PUT (spotx, spoty), grass, PSET
' If the number is a 1, then put a patch of grass

IF tile = 2 THEN PUT (spotx, spoty), wall, PSET
' If the number is a 2, then put a wall

IF tile = 3 THEN PUT (spotx, spoty), tree, PSET
' If the number is a 3, then put a tree

IF tile = 4 THEN PUT (spotx, spoty), wizard, PSET
' If the number is a 4, then put the wizard

' With the above "IF tile =..."'s, the more of those you have, the slower the
' screen is redrawn.  If you had 500 different tiles/textures/characters/etc,
' then the program would have to check each tile it draws to see which of the
' 500 tiles it is.  This demo only has 4 textures, so the screen is drawn
' REALLY fast!  So DON'T be thinking, "Oh, I've got to have small maps because
' they redraw slower if they're big," because that's NOT true!  You can have
' maps ANY size you want, because the program only reads the -5 to 5 by -4 to
' 4 numbers ANYWAYS.  Although, I've never REALLY tested this, but hey, it
' makes sense, doesn't it?  :)

NEXT y                                  ' Increase y by 1
NEXT x                                  ' Increase x by 1

END SUB

SUB LoadGraphics

CLS                                     ' Clear the screen.

GET (1, 1)-(15, 15), blank              ' Get a blank square.

LINE (5, 5)-(15, 5), 7: LINE (15, 5)-(10, 10), 7: LINE (10, 10)-(5, 5), 7: PAINT (10, 8), 15, 7
GET (1, 1)-(15, 15), downarrow          ' Get the down arrow.

LINE (1, 1)-(15, 15), 2, BF: PSET (2, 2), 10: PSET (4, 6), 10: PSET (7, 4), 10: PSET (12, 3), 10: PSET (10, 8), 10: PSET (15, 9), 10: PSET (4, 12), 10: PSET (12, 13), 10
GET (1, 1)-(15, 15), grass              ' Get the grass.

LINE (1, 1)-(15, 15), 12, BF: LINE (1, 5)-(15, 5), 15: LINE (1, 10)-(15, 10), 15: LINE (1, 15)-(15, 15), 15: LINE (1, 1)-(1, 5), 15: LINE (8, 5)-(8, 10), 15: LINE (15, 10)-(15, 15), 15
GET (1, 1)-(15, 15), wall               ' Get the wall.

LINE (1, 1)-(15, 15), 0, BF: LINE (5, 1)-(10, 1), 12: LINE (4, 2)-(11, 2), 12: PSET (4, 3), 12: LINE (5, 3)-(5, 4), 12: LINE (5, 5)-(5, 6), 88: LINE (6, 3)-(11, 6), 88, BF: LINE (6, 7)-(10, 7), 88
PSET (8, 8), 88: LINE (6, 3)-(7, 5), 15, BF: LINE (9, 3)-(10, 5), 15, BF: LINE (7, 4)-(7, 5), 0: LINE (9, 4)-(9, 5), 0: LINE (6, 9)-(10, 9), 7: LINE (6, 10)-(10, 10), 25, BF: LINE (7, 11)-(9, 11), 25
LINE (7, 12)-(9, 12), 9: LINE (7, 13)-(9, 13), 9: LINE (6, 14)-(7, 14), 9: LINE (9, 14)-(10, 14), 9: LINE (5, 15)-(6, 15), 15: LINE (10, 15)-(11, 15), 15: LINE (5, 9)-(5, 11), 88: LINE (4, 10)-(4, 12), 88
LINE (11, 9)-(11, 11), 88: LINE (12, 10)-(12, 12), 88
GET (1, 1)-(15, 15), player             ' Get the player.

LINE (1, 1)-(15, 15), 255, BF: LINE (5, 1)-(10, 1), 12: LINE (4, 2)-(11, 2), 12: PSET (4, 3), 12: LINE (5, 3)-(5, 4), 12: LINE (5, 5)-(5, 6), 88: LINE (6, 3)-(11, 6), 88, BF: LINE (6, 7)-(10, 7), 88
PSET (8, 8), 88: LINE (6, 3)-(7, 5), 15, BF: LINE (9, 3)-(10, 5), 15, BF: LINE (7, 4)-(7, 5), 0: LINE (9, 4)-(9, 5), 0: LINE (6, 9)-(10, 9), 7: LINE (6, 10)-(10, 10), 25, BF: LINE (7, 11)-(9, 11), 25
LINE (7, 12)-(9, 12), 9: LINE (7, 13)-(9, 13), 9: LINE (6, 14)-(7, 14), 9: LINE (9, 14)-(10, 14), 9: LINE (5, 15)-(6, 15), 15: LINE (10, 15)-(11, 15), 15: LINE (5, 9)-(5, 11), 88: LINE (4, 10)-(4, 12), 88
LINE (11, 9)-(11, 11), 88: LINE (12, 10)-(12, 12), 88
GET (1, 1)-(15, 15), playermask         ' Get the player mask.  Note that the
                                        ' first command tells it to fill in
                                        ' the background of the player with
                                        ' color 255.  See the DrawPlayer SUB
                                        ' for more info...

LINE (1, 1)-(15, 15), 2, BF: PSET (2, 2), 10: PSET (4, 6), 10: PSET (7, 4), 10: PSET (12, 3), 10: PSET (10, 8), 10: PSET (15, 9), 10: PSET (4, 12), 10: PSET (12, 13), 10
LINE (6, 1)-(10, 1), 88: LINE (5, 2)-(11, 6), 88, BF: LINE (6, 7)-(10, 7), 88: LINE (6, 2)-(7, 4), 15, BF: LINE (9, 2)-(10, 4), 15, BF: LINE (7, 3)-(7, 4), 0: LINE (9, 3)-(9, 4), 0
LINE (7, 6)-(6, 7), 15: LINE (9, 6)-(10, 7), 15: LINE (5, 8)-(11, 14), 13, BF: PSET (6, 8), 15: PSET (8, 8), 88: PSET (10, 8), 15: LINE (4, 9)-(4, 12), 13: LINE (12, 9)-(12, 12), 13: PSET (4, 13), 88
PSET (12, 13), 88: LINE (4, 15)-(6, 15), 0: LINE (10, 15)-(12, 15), 0
GET (1, 1)-(15, 15), wizard             ' Get the wizard.  He doesn't move
                                        ' anywhere, so there's no point in
                                        ' making a mask for him.

LINE (1, 1)-(15, 15), 2, BF: PSET (2, 2), 10: PSET (4, 6), 10: PSET (7, 4), 10: PSET (12, 3), 10: PSET (10, 8), 10: PSET (15, 9), 10: PSET (4, 12), 10: PSET (12, 13), 10
CIRCLE (8, 5), 4, 0: PAINT (8, 5), 10, 0: LINE (8, 9)-(8, 13), 6
GET (1, 1)-(15, 15), tree               ' Get the tree.

CLS                                     ' Clear the screen.

END SUB

SUB LoadMap

FOR y = 1 TO mapy                       ' For y equals 1 to the maps vertical
                                        ' number of tiles.
FOR x = 1 TO mapx                       ' For x equals 1 to the maps
                                        ' horizontal number of tiles.  Note
                                        ' that you must NOT change the order
                                        ' of these or anything, or your map
                                        ' may be read side-ways, upside-down,
                                        ' mirrored, etc.
INPUT #1, map(x, y)                     ' Read the number in the .MAP file,
                                        ' and put it into the map array.
NEXT x                                  ' Increase x by 1
NEXT y                                  ' Increase y by 1

CLOSE #1                                ' Close the .MAP file (you don't need
                                        ' it open anymore).

END SUB

SUB OpenMap

OPEN map$ FOR INPUT AS #1               ' Open the .MAP file for INPUT.  Note
                                        ' that the file need not be a .MAP
                                        ' file.  You can have it load up .DAT,
                                        ' .BLA, .anything filenames.  I just
                                        ' use .MAP because it tells me it's a
                                        ' map when I do a DIR.  If you want to
                                        ' keep losers from editing your map
                                        ' files, call them .EXE files or
                                        ' something so they don't think to
                                        ' edit them.  :)
                                        ' Also, the file reads the maps like
                                        ' so : the first number is the number
                                        ' of tiles across the map, and the
                                        ' second is the number of tiles down
                                        ' the map.  The rest is the map.  Open
                                        ' the maps and check them out to see
                                        ' how it works.  If you imagine that
                                        ' each different number is a different
                                        ' tile, you can see the level.  The
                                        ' map's x and y (the first two
                                        ' numbers) can be anything you want.
INPUT #1, mapx, mapy                    ' Read the first two numbers, which
                                        ' are the map's horizontal number of
                                        ' tiles, and the map's vertical number
                                        ' of tiles.

END SUB

SUB WriteText

' *** WARNING ***
' Prepare to be confused!  :)

LINE (0, 0)-(319, 24), 0, BF            ' Clear the top two lines of text and
                                        ' the down arrow if it's there.

a = LEN(text$)                          ' a equals the length of text$.
b = 0                                   ' b equals 0.
c = 0                                   ' c equals 0.
d = 1                                   ' d equals 0.
DO                                      ' Start the DO:LOOP
FOR Z = 1 TO 1000: NEXT Z               ' Delay for a second, so it looks like
                                        ' typing or whatever.
b = b + 1                               ' Increase b by 1
c = c + 1                               ' Increase c by 1

IF c = 40 THEN d = d + 1: text$ = RIGHT$(text$, a - b + 1): b = 1: c = 1: a = LEN(text$)

' Okay, the above line does this, in this order :
' - If 40 characters are displayed, THEN...
' - Increase d by 1.
' - text$ = from this number : the length of text$ minus b plus 1 : on.  So
'   basically it gets rid of a character in the string.
' - Set b back to 1.
' - Set c back to 1.
' - a equals the NEW length of text$ which was shortened by 3 steps above this
'   line.

b$ = LEFT$(text$, b)                    ' b$ equals b number of characters
                                        ' from the left of text$.
COLOR 15                                ' Change the color.
LOCATE d, 1                             ' LOCATE d, the first column of text.
PRINT b$                                ' PRINT what's in b$.
LOOP UNTIL b = a                        ' loop until the length of b$ equals
                                        ' the length of a$.

IF morearrow = 1 THEN                   ' If the morearrow flag is set THEN...
morearrow = 0                           ' Set it back to 0.
PUT (0, 15), downarrow, PSET            ' PUT the down arrow under the text.
END IF                                  ' END the "IF morearrow..." IF

DO: LOOP UNTIL INKEY$ <> ""             ' Wait for the user to hit a key.
LINE (0, 0)-(319, 24), 0, BF            ' Clear the top two lines of text and
                                        ' the down arrow if it's there.

' Wasn't that fun?  :)

END SUB

