#ifndef lint
static char yysccsid[] = "@(#)yaccpar     1.7 (Berkeley) 09/09/90";
#endif
#define YYBYACC 1
#line 64 "grammar.y"
#include <stdio.h>
#include "cproto.h"
#include "symbol.h"
#include "semantic.h"

#define YYMAXDEPTH 150

/* declaration specifier attributes for the typedef statement currently being
 * scanned
 */
static int cur_decl_spec_flags;

/* pointer to parameter list for the current function definition */
static ParameterList *func_params;

/* A parser semantic action sets this pointer to the current declarator in
 * a function parameter declaration in order to catch any comments following
 * the parameter declaration on the same line.  If the lexer scans a comment
 * and <cur_declarator> is not NULL, then the comment is attached to the
 * declarator.  To ignore subsequent comments, the lexer sets this to NULL
 * after scanning a comment or end of line.
 */
static Declarator *cur_declarator;

/* temporary string buffer */
static char buf[MAX_TEXT_SIZE];

/* table of typedef names */
static SymbolTable *typedef_names;

/* table of type qualifiers */
static SymbolTable *type_qualifiers;

/* information about the current input file */
typedef struct {
    char *base_name;		/* base input file name */
    char *file_name;		/* current file name */
    FILE *file; 		/* input file */
    unsigned line_num;		/* current line number in input file */
    FILE *tmp_file;		/* temporary file */
    long begin_comment; 	/* tmp file offset after last written ) or ; */
    long end_comment;		/* tmp file offset after last comment */
    boolean convert;		/* if TRUE, convert function definitions */
    boolean changed;		/* TRUE if conversion done in this file */
} IncludeStack;

static IncludeStack *cur_file;	/* current input file */

extern void yyerror();
#line 56 "y_tab.c"
#define T_IDENTIFIER 257
#define T_TYPEDEF_NAME 258
#define T_AUTO 259
#define T_EXTERN 260
#define T_REGISTER 261
#define T_STATIC 262
#define T_TYPEDEF 263
#define T_INLINE 264
#define T_CHAR 265
#define T_DOUBLE 266
#define T_FLOAT 267
#define T_INT 268
#define T_VOID 269
#define T_LONG 270
#define T_SHORT 271
#define T_SIGNED 272
#define T_UNSIGNED 273
#define T_ENUM 274
#define T_STRUCT 275
#define T_UNION 276
#define T_TYPE_QUALIFIER 277
#define T_BRACKETS 278
#define T_LBRACE 279
#define T_MATCHRBRACE 280
#define T_ELLIPSIS 281
#define T_INITIALIZER 282
#define T_STRING_LITERAL 283
#define T_ASM 284
#define T_ASMARG 285
#define T_VA_DCL 286
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    0,   24,   24,   25,   25,   25,   25,   25,   25,
   25,   29,   28,   28,   26,   26,   31,   26,   30,   30,
   32,   32,   34,   35,   27,   36,   37,   27,   33,   33,
   33,   38,   38,    1,    1,    2,    2,    2,    3,    3,
    3,    3,    3,    4,    4,    4,    4,    4,    4,    4,
    4,    4,    4,    4,    5,    5,    6,    6,    6,   19,
   19,    8,    8,    9,   39,    9,    7,    7,    7,   23,
   23,   10,   10,   11,   11,   11,   11,   11,   20,   20,
   21,   21,   22,   22,   14,   14,   15,   15,   16,   16,
   16,   17,   17,   18,   18,   12,   12,   12,   13,   13,
   13,   13,   13,   13,   13,
};
short yylen[] = {                                         2,
    0,    1,    1,    2,    1,    1,    2,    1,    3,    2,
    2,    2,    3,    3,    2,    3,    0,    5,    0,    1,
    1,    3,    0,    0,    7,    0,    0,    6,    0,    1,
    1,    1,    2,    1,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    3,    2,    2,    1,
    1,    1,    3,    1,    0,    4,    3,    2,    2,    1,
    1,    2,    1,    1,    3,    2,    4,    4,    2,    3,
    0,    1,    1,    2,    1,    3,    1,    3,    2,    2,
    1,    0,    1,    1,    3,    1,    2,    1,    3,    2,
    1,    4,    3,    3,    2,
};
short yydefred[] = {                                      0,
    0,    0,    0,   74,   56,   39,    0,   41,   42,    0,
   43,   44,   45,   46,   47,   52,   48,   49,   50,   51,
    0,   60,   61,   55,    0,    0,    0,   34,   36,   37,
   38,   53,   54,   26,    0,    0,    0,    0,    3,    5,
    0,    8,   11,   10,    0,   83,    0,    0,    0,   40,
    0,   70,   71,    0,    0,   68,    0,   15,   35,    0,
   62,    0,    0,    0,   76,    0,   58,    0,    4,    7,
   75,   80,   84,    0,   14,   13,    0,   12,   67,    9,
   16,    0,   65,    0,   30,   32,    0,    0,   94,    0,
    0,    0,   87,    0,    0,   57,    0,   21,    0,    0,
   63,    0,    0,   27,   33,    0,  101,   89,   90,    0,
    0,   77,    0,   78,    0,   18,    0,   66,   24,    0,
  105,    0,    0,    0,  100,    0,   86,   88,   95,   22,
    0,   28,   99,  104,  103,    0,   25,  102,
};
short yydgoto[] = {                                      26,
   74,   28,   29,   30,   31,   32,   33,   60,   61,   34,
   35,  109,  110,   91,   92,   93,   94,   95,   36,   37,
   47,   48,   55,   38,   39,   40,   41,   42,   56,   99,
   77,  100,   87,   84,  131,   63,  120,   88,  102,
};
short yysindex[] = {                                     59,
  -34,  -16, -247,    0,    0,    0, -277,    0,    0,  456,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -242,    0,    0,    0, -272,    0,  393,    0,    0,    0,
    0,    0,    0,    0,  -38, -242,   -8,   59,    0,    0,
  -37,    0,    0,    0,  -14,    0,  -13, -247,  332,    0,
  456,    0,    0, -240, -237,    0,  -11,    0,    0,  -25,
    0,  -17,  285,  355,    0, -237,    0,  -38,    0,    0,
    0,    0,    0,  393,    0,    0,  -16,    0,    0,    0,
    0,  -16,    0,  285,    0,    0, -233,  413,    0,  197,
   15,   13,    0,   22,   24,    0,  -17,    0,   -7,   30,
    0, -206, -201,    0,    0,  153,    0,    0,    0,  -36,
  175,    0,  308,    0, -177,    0,  -16,    0,    0, -199,
    0,   42,   43,  265,    0,  -36,    0,    0,    0,    0,
 -194,    0,    0,    0,    0,   47,    0,    0,
};
short yyrindex[] = {                                     91,
    0,    0,  159,    0,    0,    0,  436,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  -41,    0,    0,   92,    0,    0,
    1,    0,    0,    0,    0,    0,  203,  239,    0,    0,
   -9,    0,    0,    0,  109,    0,    0,    0,    0,    0,
    0,   86, -186,   53,    0,  131,    0,   28,    0,    0,
    0,    0,    0,    0,    0,    0,   36,    0,    0,    0,
    0,    0,    0, -186,    0,    0,    0, -183,    0,   14,
    0,   56,    0,    0,   61,    0,  -21,    0,    0,   41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   20,
   21,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   29,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,
};
short yygindex[] = {                                      0,
    7,  -15,    0,    0,    6,    0,    0,    0,   23,    8,
  -32,   -3,   -5,  -85,    0,   -6,    0,    0,    0,  -39,
    0,    0,   68,    0,   70,  -35,    0,    0,   11,    0,
    0,    0,   25,    0,    0,    0,    0,    0,    0,
};
#define YYTABLESIZE 733
short yytable[] = {                                      73,
    6,   64,   73,  124,   68,   49,   27,   72,   46,   45,
    5,   59,   57,   75,   52,   53,   51,   73,   82,   73,
  123,   70,   64,    2,   44,    3,   71,   86,    3,   24,
   17,    2,   17,   81,   62,   59,   54,   64,  136,   78,
    6,   54,    6,   83,   27,  104,   67,   80,   86,   17,
  111,  116,  105,   73,   91,  112,  113,   91,   59,   76,
   98,   96,  114,   98,   96,   79,  111,  115,   72,   97,
   90,   72,   97,  117,   59,  118,   96,  119,   68,  129,
  132,   97,  133,  134,   98,  137,   72,  138,   72,   97,
    1,    2,   29,   92,   19,   31,   85,  108,    2,   20,
    3,   93,  122,   66,  101,  126,  128,   69,  103,    0,
    0,    0,   90,   45,    0,    0,    0,    0,    0,   90,
    0,    0,    0,    0,  130,    0,    0,    0,    0,   64,
   90,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   64,    0,    0,    0,   69,   69,
   69,    0,   69,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   69,    0,    0,
   59,   59,   59,    0,   59,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   59,
    0,    0,  106,  121,    3,    0,    0,    0,   81,   81,
   81,    0,   81,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  106,    0,   73,   73,   73,   73,
   73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
   73,   73,   73,   73,   73,   73,  106,   73,    3,   65,
    4,  125,   79,   79,   73,   43,   79,   17,    4,    0,
    0,    0,    0,    0,    0,    0,    6,    6,    6,    6,
    6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
    6,    6,    6,    6,    6,    6,    6,    6,   82,   82,
   82,    0,   82,    0,    6,   72,   72,   72,   72,   72,
   72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
   72,   72,   72,   72,   72,  135,   72,    0,    0,    0,
    0,    0,    0,   72,    1,    4,    5,    6,    7,    8,
    9,   10,   11,   12,   13,   14,   15,   16,   17,   18,
   19,   20,   21,   22,   23,   24,    0,    0,    0,    0,
    0,    0,   25,   23,   23,   23,   23,   23,   23,   23,
   23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
   23,   23,   23,    0,   23,   69,   69,   69,   69,   69,
   69,   23,   69,   69,   69,   69,   69,   69,   69,   69,
   69,   69,   69,   69,   69,   69,   69,   59,   59,   59,
   59,   59,   59,    0,   59,   59,   59,   59,   59,   59,
   59,   59,   59,   59,   59,   59,   59,   59,   59,    4,
    5,    6,   50,    8,    9,   81,   11,   12,   13,   14,
   15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
  107,    4,    2,    0,    3,    0,   81,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   58,  107,    4,    5,    6,   50,    8,    9,   79,
   11,   12,   13,   14,   15,   16,   17,   18,   19,   20,
   21,   22,   23,   24,  107,   40,    0,   40,    0,    0,
   79,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   40,   82,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   82,    0,    0,    0,
    0,    0,    5,    6,   50,    8,    9,    0,   11,   12,
   13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
   23,   24,    5,    6,   50,    8,    9,   10,   11,   12,
   13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
   23,   24,    0,    0,    0,    5,    6,   50,    8,    9,
   85,   11,   12,   13,   14,   15,   16,   17,   18,   19,
   20,   21,   22,   23,   24,    0,    0,    0,  127,    5,
    6,   50,    8,    9,   10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,    0,
   54,   89,    5,    6,   50,    8,    9,    0,   11,   12,
   13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
   23,   24,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    4,
    5,    6,   50,    8,    9,    0,   11,   12,   13,   14,
   15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
    5,    6,   50,    8,    9,   10,   11,   12,   13,   14,
   15,   16,   17,   18,   19,   20,   21,   22,   23,   24,
    0,    0,   40,   40,   40,   40,   40,   40,    0,   40,
   40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
   40,   40,   40,    5,    6,   50,    8,    9,    0,   11,
   12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
   22,   23,   24,
};
short yycheck[] = {                                      41,
    0,   40,   44,   40,   37,  283,    0,   47,    3,    2,
  258,   27,  285,   49,  257,  258,   10,   59,   44,   61,
  106,   59,   44,   40,   59,   42,   41,   63,   42,  277,
   40,   40,   42,   59,   27,   51,  279,   59,  124,  280,
   40,  279,   42,   61,   38,  279,   36,   59,   84,   59,
   90,   59,   88,   48,   41,   41,   44,   44,   74,   49,
   41,   41,   41,   44,   44,   55,  106,   44,   41,   41,
   64,   44,   44,   44,   90,  282,   66,  279,  111,  257,
  280,   74,   41,   41,   77,  280,   59,   41,   61,   82,
    0,    0,  279,   41,   59,  279,   41,   90,   40,   59,
   42,   41,  106,   36,   82,  111,  113,   38,   84,   -1,
   -1,   -1,  106,  106,   -1,   -1,   -1,   -1,   -1,  113,
   -1,   -1,   -1,   -1,  117,   -1,   -1,   -1,   -1,   44,
  124,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   40,   41,
   42,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,
   40,   41,   42,   -1,   44,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,
   -1,   -1,   40,   41,   42,   -1,   -1,   -1,   40,   41,
   42,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   40,   -1,  258,  259,  260,  261,
  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,
  272,  273,  274,  275,  276,  277,   40,  279,   42,  278,
  257,  278,   40,   41,  286,  280,   44,  257,  257,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,
  260,  261,  262,  263,  264,  265,  266,  267,  268,  269,
  270,  271,  272,  273,  274,  275,  276,  277,   40,   41,
   42,   -1,   44,   -1,  284,  258,  259,  260,  261,  262,
  263,  264,  265,  266,  267,  268,  269,  270,  271,  272,
  273,  274,  275,  276,  277,   41,  279,   -1,   -1,   -1,
   -1,   -1,   -1,  286,  256,  257,  258,  259,  260,  261,
  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,
  272,  273,  274,  275,  276,  277,   -1,   -1,   -1,   -1,
   -1,   -1,  284,  258,  259,  260,  261,  262,  263,  264,
  265,  266,  267,  268,  269,  270,  271,  272,  273,  274,
  275,  276,  277,   -1,  279,  257,  258,  259,  260,  261,
  262,  286,  264,  265,  266,  267,  268,  269,  270,  271,
  272,  273,  274,  275,  276,  277,  278,  257,  258,  259,
  260,  261,  262,   -1,  264,  265,  266,  267,  268,  269,
  270,  271,  272,  273,  274,  275,  276,  277,  278,  257,
  258,  259,  260,  261,  262,  257,  264,  265,  266,  267,
  268,  269,  270,  271,  272,  273,  274,  275,  276,  277,
  278,  257,   40,   -1,   42,   -1,  278,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   59,  278,  257,  258,  259,  260,  261,  262,  257,
  264,  265,  266,  267,  268,  269,  270,  271,  272,  273,
  274,  275,  276,  277,  278,   40,   -1,   42,   -1,   -1,
  278,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   59,  257,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  278,   -1,   -1,   -1,
   -1,   -1,  258,  259,  260,  261,  262,   -1,  264,  265,
  266,  267,  268,  269,  270,  271,  272,  273,  274,  275,
  276,  277,  258,  259,  260,  261,  262,  263,  264,  265,
  266,  267,  268,  269,  270,  271,  272,  273,  274,  275,
  276,  277,   -1,   -1,   -1,  258,  259,  260,  261,  262,
  286,  264,  265,  266,  267,  268,  269,  270,  271,  272,
  273,  274,  275,  276,  277,   -1,   -1,   -1,  281,  258,
  259,  260,  261,  262,  263,  264,  265,  266,  267,  268,
  269,  270,  271,  272,  273,  274,  275,  276,  277,   -1,
  279,  257,  258,  259,  260,  261,  262,   -1,  264,  265,
  266,  267,  268,  269,  270,  271,  272,  273,  274,  275,
  276,  277,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,
  258,  259,  260,  261,  262,   -1,  264,  265,  266,  267,
  268,  269,  270,  271,  272,  273,  274,  275,  276,  277,
  258,  259,  260,  261,  262,  263,  264,  265,  266,  267,
  268,  269,  270,  271,  272,  273,  274,  275,  276,  277,
   -1,   -1,  257,  258,  259,  260,  261,  262,   -1,  264,
  265,  266,  267,  268,  269,  270,  271,  272,  273,  274,
  275,  276,  277,  258,  259,  260,  261,  262,   -1,  264,
  265,  266,  267,  268,  269,  270,  271,  272,  273,  274,
  275,  276,  277,
};
#define YYFINAL 26
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 286
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'('","')'","'*'",0,"','",0,0,0,0,0,0,0,0,0,0,0,0,0,0,"';'",0,"'='",
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"T_IDENTIFIER","T_TYPEDEF_NAME","T_AUTO","T_EXTERN","T_REGISTER","T_STATIC",
"T_TYPEDEF","T_INLINE","T_CHAR","T_DOUBLE","T_FLOAT","T_INT","T_VOID","T_LONG",
"T_SHORT","T_SIGNED","T_UNSIGNED","T_ENUM","T_STRUCT","T_UNION",
"T_TYPE_QUALIFIER","T_BRACKETS","T_LBRACE","T_MATCHRBRACE","T_ELLIPSIS",
"T_INITIALIZER","T_STRING_LITERAL","T_ASM","T_ASMARG","T_VA_DCL",
};
char *yyrule[] = {
"$accept : program",
"program :",
"program : translation_unit",
"translation_unit : external_declaration",
"translation_unit : translation_unit external_declaration",
"external_declaration : declaration",
"external_declaration : function_definition",
"external_declaration : function_definition ';'",
"external_declaration : linkage_specification",
"external_declaration : T_ASM T_ASMARG ';'",
"external_declaration : error ';'",
"external_declaration : error T_MATCHRBRACE",
"braces : T_LBRACE T_MATCHRBRACE",
"linkage_specification : T_EXTERN T_STRING_LITERAL braces",
"linkage_specification : T_EXTERN T_STRING_LITERAL declaration",
"declaration : decl_specifiers ';'",
"declaration : decl_specifiers init_declarator_list ';'",
"$$1 :",
"declaration : T_TYPEDEF decl_specifiers $$1 opt_declarator_list ';'",
"opt_declarator_list :",
"opt_declarator_list : declarator_list",
"declarator_list : declarator",
"declarator_list : declarator_list ',' declarator",
"$$2 :",
"$$3 :",
"function_definition : decl_specifiers declarator $$2 opt_declaration_list T_LBRACE $$3 T_MATCHRBRACE",
"$$4 :",
"$$5 :",
"function_definition : declarator $$4 opt_declaration_list T_LBRACE $$5 T_MATCHRBRACE",
"opt_declaration_list :",
"opt_declaration_list : T_VA_DCL",
"opt_declaration_list : declaration_list",
"declaration_list : declaration",
"declaration_list : declaration_list declaration",
"decl_specifiers : decl_specifier",
"decl_specifiers : decl_specifiers decl_specifier",
"decl_specifier : storage_class",
"decl_specifier : type_specifier",
"decl_specifier : type_qualifier",
"storage_class : T_AUTO",
"storage_class : T_EXTERN",
"storage_class : T_REGISTER",
"storage_class : T_STATIC",
"storage_class : T_INLINE",
"type_specifier : T_CHAR",
"type_specifier : T_DOUBLE",
"type_specifier : T_FLOAT",
"type_specifier : T_INT",
"type_specifier : T_LONG",
"type_specifier : T_SHORT",
"type_specifier : T_SIGNED",
"type_specifier : T_UNSIGNED",
"type_specifier : T_VOID",
"type_specifier : struct_or_union_specifier",
"type_specifier : enum_specifier",
"type_qualifier : T_TYPE_QUALIFIER",
"type_qualifier : T_TYPEDEF_NAME",
"struct_or_union_specifier : struct_or_union any_id braces",
"struct_or_union_specifier : struct_or_union braces",
"struct_or_union_specifier : struct_or_union any_id",
"struct_or_union : T_STRUCT",
"struct_or_union : T_UNION",
"init_declarator_list : init_declarator",
"init_declarator_list : init_declarator_list ',' init_declarator",
"init_declarator : declarator",
"$$6 :",
"init_declarator : declarator '=' $$6 T_INITIALIZER",
"enum_specifier : T_ENUM any_id braces",
"enum_specifier : T_ENUM braces",
"enum_specifier : T_ENUM any_id",
"any_id : T_IDENTIFIER",
"any_id : T_TYPEDEF_NAME",
"declarator : pointer direct_declarator",
"declarator : direct_declarator",
"direct_declarator : T_IDENTIFIER",
"direct_declarator : '(' declarator ')'",
"direct_declarator : direct_declarator T_BRACKETS",
"direct_declarator : direct_declarator '(' parameter_type_list ')'",
"direct_declarator : direct_declarator '(' opt_identifier_list ')'",
"pointer : '*' opt_type_qualifiers",
"pointer : '*' opt_type_qualifiers pointer",
"opt_type_qualifiers :",
"opt_type_qualifiers : type_qualifier_list",
"type_qualifier_list : type_qualifier",
"type_qualifier_list : type_qualifier_list type_qualifier",
"parameter_type_list : parameter_list",
"parameter_type_list : parameter_list ',' T_ELLIPSIS",
"parameter_list : parameter_declaration",
"parameter_list : parameter_list ',' parameter_declaration",
"parameter_declaration : decl_specifiers declarator",
"parameter_declaration : decl_specifiers abs_declarator",
"parameter_declaration : decl_specifiers",
"opt_identifier_list :",
"opt_identifier_list : identifier_list",
"identifier_list : T_IDENTIFIER",
"identifier_list : identifier_list ',' T_IDENTIFIER",
"abs_declarator : pointer",
"abs_declarator : pointer direct_abs_declarator",
"abs_declarator : direct_abs_declarator",
"direct_abs_declarator : '(' abs_declarator ')'",
"direct_abs_declarator : direct_abs_declarator T_BRACKETS",
"direct_abs_declarator : T_BRACKETS",
"direct_abs_declarator : direct_abs_declarator '(' parameter_type_list ')'",
"direct_abs_declarator : direct_abs_declarator '(' ')'",
"direct_abs_declarator : '(' parameter_type_list ')'",
"direct_abs_declarator : '(' ')'",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 600
#define YYMAXDEPTH 600
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#line 666 "grammar.y"

#ifdef MSDOS
#include "lex_yy.c"
#else
#include "lex.yy.c"
#endif

void
yyerror (msg)
char *msg;
{
    func_params = NULL;
    put_error();
    fprintf(stderr, "%s\n", msg);
}

/* Initialize the table of type qualifier keywords recognized by the lexical
 * analyzer.
 */
void
init_parser ()
{
    static char *keywords[] = {
	"const", "volatile", "interrupt",
#ifdef MSDOS
	"cdecl", "far", "huge", "near", "pascal",
	"_cdecl", "_export", "_far", "_fastcall", "_fortran", "_huge",
	"_interrupt", "_loadds", "_near", "_pascal", "_saveregs", "_segment",
	"_cs", "_ds", "_es", "_ss", "_seg",
	"__cdecl", "__export", "__far", "__fastcall", "__fortran", "__huge",
	"__inline", "__interrupt", "__loadds", "__near", "__pascal",
	"__saveregs", "__segment", "__stdcall", "__syscall",
	"__cs", "__ds", "__es", "__ss", "__seg",
#endif
    };
    int i;

    /* Initialize type qualifier table. */
    type_qualifiers = new_symbol_table();
    for (i = 0; i < sizeof(keywords)/sizeof(keywords[0]); ++i) {
	new_symbol(type_qualifiers, keywords[i], DS_NONE);
    }
}

/* Process the C source file.  Write function prototypes to the standard
 * output.  Convert function definitions and write the converted source
 * code to a temporary file.
 */
void
process_file (infile, name)
FILE *infile;
char *name;
{
    char *s;

    if (strlen(name) > 2) {
	s = name + strlen(name) - 2;
	if (*s == '.') {
	    ++s;
	    if (*s == 'l' || *s == 'y')
		BEGIN LEXYACC;
#ifdef MSDOS
	    if (*s == 'L' || *s == 'Y')
		BEGIN LEXYACC;
#endif
	}
    }

    included_files = new_symbol_table();
    typedef_names = new_symbol_table();
    inc_depth = -1;
    curly = 0;
    ly_count = 0;
    func_params = NULL;
    yyin = infile;
    include_file(name, func_style != FUNC_NONE);
    if (proto_comments)
	printf("/* %s */\n", cur_file_name());
    yyparse();
    free_symbol_table(typedef_names);
    free_symbol_table(included_files);
}
#line 564 "y_tab.c"
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 10:
#line 133 "grammar.y"
{
	    yyerrok;
	}
break;
case 11:
#line 137 "grammar.y"
{
	    yyerrok;
	}
break;
case 13:
#line 148 "grammar.y"
{
	    /* Provide an empty action here so bison will not complain about
	     * incompatible types in the default action it normally would
	     * have generated.
	     */
	}
break;
case 14:
#line 155 "grammar.y"
{
	    /* empty */
	}
break;
case 15:
#line 162 "grammar.y"
{
	    free_decl_spec(&yyvsp[-1].decl_spec);
	}
break;
case 16:
#line 166 "grammar.y"
{
	    if (func_params != NULL) {
		set_param_types(func_params, &yyvsp[-2].decl_spec, &yyvsp[-1].decl_list);
	    } else {
		gen_declarations(&yyvsp[-2].decl_spec, &yyvsp[-1].decl_list);
		free_decl_list(&yyvsp[-1].decl_list);
	    }
	    free_decl_spec(&yyvsp[-2].decl_spec);
	}
break;
case 17:
#line 176 "grammar.y"
{
	    cur_decl_spec_flags = yyvsp[0].decl_spec.flags;
	    free_decl_spec(&yyvsp[0].decl_spec);
	}
break;
case 21:
#line 190 "grammar.y"
{
	    int flags = cur_decl_spec_flags;

	    /* If the typedef is a pointer type, then reset the short type
	     * flags so it does not get promoted.
	     */
	    if (strcmp(yyvsp[0].declarator->text, yyvsp[0].declarator->name) != 0)
		flags &= ~(DS_CHAR | DS_SHORT | DS_FLOAT);
	    new_symbol(typedef_names, yyvsp[0].declarator->name, flags);
	    free_declarator(yyvsp[0].declarator);
	}
break;
case 22:
#line 202 "grammar.y"
{
	    int flags = cur_decl_spec_flags;

	    if (strcmp(yyvsp[0].declarator->text, yyvsp[0].declarator->name) != 0)
		flags &= ~(DS_CHAR | DS_SHORT | DS_FLOAT);
	    new_symbol(typedef_names, yyvsp[0].declarator->name, flags);
	    free_declarator(yyvsp[0].declarator);
	}
break;
case 23:
#line 214 "grammar.y"
{
	    check_untagged(&yyvsp[-1].decl_spec);
	    if (yyvsp[0].declarator->func_def == FUNC_NONE) {
		yyerror("syntax error");
		YYERROR;
	    }
	    func_params = &(yyvsp[0].declarator->head->params);
	    func_params->begin_comment = cur_file->begin_comment;
	    func_params->end_comment = cur_file->end_comment;
	}
break;
case 24:
#line 225 "grammar.y"
{
	    func_params = NULL;

	    if (cur_file->convert)
		gen_func_definition(&yyvsp[-4].decl_spec, yyvsp[-3].declarator);
	    gen_prototype(&yyvsp[-4].decl_spec, yyvsp[-3].declarator);
	    free_decl_spec(&yyvsp[-4].decl_spec);
	    free_declarator(yyvsp[-3].declarator);
	}
break;
case 26:
#line 236 "grammar.y"
{
	    if (yyvsp[0].declarator->func_def == FUNC_NONE) {
		yyerror("syntax error");
		YYERROR;
	    }
	    func_params = &(yyvsp[0].declarator->head->params);
	    func_params->begin_comment = cur_file->begin_comment;
	    func_params->end_comment = cur_file->end_comment;
	}
break;
case 27:
#line 246 "grammar.y"
{
	    DeclSpec decl_spec;

	    func_params = NULL;

	    new_decl_spec(&decl_spec, "int", yyvsp[-3].declarator->begin, DS_NONE);
	    if (cur_file->convert)
		gen_func_definition(&decl_spec, yyvsp[-3].declarator);
	    gen_prototype(&decl_spec, yyvsp[-3].declarator);
	    free_decl_spec(&decl_spec);
	    free_declarator(yyvsp[-3].declarator);
	}
break;
case 35:
#line 275 "grammar.y"
{
	    join_decl_specs(&yyval.decl_spec, &yyvsp[-1].decl_spec, &yyvsp[0].decl_spec);
	    free(yyvsp[-1].decl_spec.text);
	    free(yyvsp[0].decl_spec.text);
	}
break;
case 39:
#line 290 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, DS_NONE);
	}
break;
case 40:
#line 294 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, DS_EXTERN);
	}
break;
case 41:
#line 298 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, DS_NONE);
	}
break;
case 42:
#line 302 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, DS_STATIC);
	}
break;
case 43:
#line 306 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, DS_JUNK);
	}
break;
case 44:
#line 313 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, DS_CHAR);
	}
break;
case 45:
#line 317 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, DS_NONE);
	}
break;
case 46:
#line 321 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, DS_FLOAT);
	}
break;
case 47:
#line 325 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, DS_NONE);
	}
break;
case 48:
#line 329 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, DS_NONE);
	}
break;
case 49:
#line 333 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, DS_SHORT);
	}
break;
case 50:
#line 337 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, DS_NONE);
	}
break;
case 51:
#line 341 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, DS_NONE);
	}
break;
case 52:
#line 345 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, DS_NONE);
	}
break;
case 55:
#line 354 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, DS_NONE);
	}
break;
case 56:
#line 358 "grammar.y"
{
	    /* A typedef name is actually a type specifier, but since the
	     * typedef symbol table also stores #define names, this production
	     * is here so the <pointer> nonterminal will scan #define names.
	     */
	    Symbol *s;
	    s = find_symbol(typedef_names, yyvsp[0].text.text);
	    new_decl_spec(&yyval.decl_spec, yyvsp[0].text.text, yyvsp[0].text.begin, s->flags);
	}
break;
case 57:
#line 371 "grammar.y"
{
	    sprintf(buf, "%s %s", yyvsp[-2].text.text, yyvsp[-1].text.text);
	    new_decl_spec(&yyval.decl_spec, buf, yyvsp[-2].text.begin, DS_NONE);
	}
break;
case 58:
#line 376 "grammar.y"
{
	    sprintf(buf, "%s {}", yyvsp[-1].text.text);
	    new_decl_spec(&yyval.decl_spec, buf, yyvsp[-1].text.begin, DS_NONE);
	}
break;
case 59:
#line 381 "grammar.y"
{
	    sprintf(buf, "%s %s", yyvsp[-1].text.text, yyvsp[0].text.text);
	    new_decl_spec(&yyval.decl_spec, buf, yyvsp[-1].text.begin, DS_NONE);
	}
break;
case 62:
#line 394 "grammar.y"
{
	    new_decl_list(&yyval.decl_list, yyvsp[0].declarator);
	}
break;
case 63:
#line 398 "grammar.y"
{
	    add_decl_list(&yyval.decl_list, &yyvsp[-2].decl_list, yyvsp[0].declarator);
	}
break;
case 64:
#line 405 "grammar.y"
{
	    if (yyvsp[0].declarator->func_def != FUNC_NONE && func_params == NULL &&
		func_style == FUNC_TRADITIONAL && cur_file->convert) {
		gen_func_declarator(yyvsp[0].declarator);
		fputs(cur_text(), cur_file->tmp_file);
	    }
	    cur_declarator = yyval.declarator;
	}
break;
case 65:
#line 414 "grammar.y"
{
	    if (yyvsp[-1].declarator->func_def != FUNC_NONE && func_params == NULL &&
		func_style == FUNC_TRADITIONAL && cur_file->convert) {
		gen_func_declarator(yyvsp[-1].declarator);
		fputs(" =", cur_file->tmp_file);
	    }
	}
break;
case 67:
#line 426 "grammar.y"
{
	    sprintf(buf, "enum %s", yyvsp[-1].text.text);
	    new_decl_spec(&yyval.decl_spec, buf, yyvsp[-2].text.begin, DS_NONE);
	}
break;
case 68:
#line 431 "grammar.y"
{
	    new_decl_spec(&yyval.decl_spec, "enum {}", yyvsp[-1].text.begin, DS_NONE);
	}
break;
case 69:
#line 435 "grammar.y"
{
	    sprintf(buf, "enum %s", yyvsp[0].text.text);
	    new_decl_spec(&yyval.decl_spec, buf, yyvsp[-1].text.begin, DS_NONE);
	}
break;
case 72:
#line 448 "grammar.y"
{
	    yyval.declarator = yyvsp[0].declarator;
	    sprintf(buf, "%s%s", yyvsp[-1].text.text, yyval.declarator->text);
	    free(yyval.declarator->text);
	    yyval.declarator->text = xstrdup(buf);
	    yyval.declarator->begin = yyvsp[-1].text.begin;
	    yyval.declarator->pointer = TRUE;
	}
break;
case 74:
#line 461 "grammar.y"
{
	    yyval.declarator = new_declarator(yyvsp[0].text.text, yyvsp[0].text.text, yyvsp[0].text.begin);
	}
break;
case 75:
#line 465 "grammar.y"
{
	    yyval.declarator = yyvsp[-1].declarator;
	    sprintf(buf, "(%s)", yyval.declarator->text);
	    free(yyval.declarator->text);
	    yyval.declarator->text = xstrdup(buf);
	    yyval.declarator->begin = yyvsp[-2].text.begin;
	}
break;
case 76:
#line 473 "grammar.y"
{
	    yyval.declarator = yyvsp[-1].declarator;
	    sprintf(buf, "%s%s", yyval.declarator->text, yyvsp[0].text.text);
	    free(yyval.declarator->text);
	    yyval.declarator->text = xstrdup(buf);
	}
break;
case 77:
#line 480 "grammar.y"
{
	    yyval.declarator = new_declarator("%s()", yyvsp[-3].declarator->name, yyvsp[-3].declarator->begin);
	    yyval.declarator->params = yyvsp[-1].param_list;
	    yyval.declarator->func_stack = yyvsp[-3].declarator;
	    yyval.declarator->head = (yyvsp[-3].declarator->func_stack == NULL) ? yyval.declarator : yyvsp[-3].declarator->head;
	    yyval.declarator->func_def = FUNC_ANSI;
	}
break;
case 78:
#line 488 "grammar.y"
{
	    yyval.declarator = new_declarator("%s()", yyvsp[-3].declarator->name, yyvsp[-3].declarator->begin);
	    yyval.declarator->params = yyvsp[-1].param_list;
	    yyval.declarator->func_stack = yyvsp[-3].declarator;
	    yyval.declarator->head = (yyvsp[-3].declarator->func_stack == NULL) ? yyval.declarator : yyvsp[-3].declarator->head;
	    yyval.declarator->func_def = FUNC_TRADITIONAL;
	}
break;
case 79:
#line 499 "grammar.y"
{
	    sprintf(yyval.text.text, "*%s", yyvsp[0].text.text);
	    yyval.text.begin = yyvsp[-1].text.begin;
	}
break;
case 80:
#line 504 "grammar.y"
{
	    sprintf(yyval.text.text, "*%s%s", yyvsp[-1].text.text, yyvsp[0].text.text);
	    yyval.text.begin = yyvsp[-2].text.begin;
	}
break;
case 81:
#line 512 "grammar.y"
{
	    strcpy(yyval.text.text, "");
	    yyval.text.begin = 0L;
	}
break;
case 83:
#line 521 "grammar.y"
{
	    sprintf(yyval.text.text, "%s ", yyvsp[0].decl_spec.text);
	    yyval.text.begin = yyvsp[0].decl_spec.begin;
	    free(yyvsp[0].decl_spec.text);
	}
break;
case 84:
#line 527 "grammar.y"
{
	    sprintf(yyval.text.text, "%s%s ", yyvsp[-1].text.text, yyvsp[0].decl_spec.text);
	    yyval.text.begin = yyvsp[-1].text.begin;
	    free(yyvsp[0].decl_spec.text);
	}
break;
case 86:
#line 537 "grammar.y"
{
	    add_ident_list(&yyval.param_list, &yyvsp[-2].param_list, "...");
	}
break;
case 87:
#line 544 "grammar.y"
{
	    new_param_list(&yyval.param_list, yyvsp[0].parameter);
	}
break;
case 88:
#line 548 "grammar.y"
{
	    add_param_list(&yyval.param_list, &yyvsp[-2].param_list, yyvsp[0].parameter);
	}
break;
case 89:
#line 555 "grammar.y"
{
	    check_untagged(&yyvsp[-1].decl_spec);
	    yyval.parameter = new_parameter(&yyvsp[-1].decl_spec, yyvsp[0].declarator);
	}
break;
case 90:
#line 560 "grammar.y"
{
	    check_untagged(&yyvsp[-1].decl_spec);
	    yyval.parameter = new_parameter(&yyvsp[-1].decl_spec, yyvsp[0].declarator);
	}
break;
case 91:
#line 565 "grammar.y"
{
	    check_untagged(&yyvsp[0].decl_spec);
	    yyval.parameter = new_parameter(&yyvsp[0].decl_spec, NULL);
	}
break;
case 92:
#line 573 "grammar.y"
{
	    new_ident_list(&yyval.param_list);
	}
break;
case 94:
#line 581 "grammar.y"
{
	    new_ident_list(&yyval.param_list);
	    add_ident_list(&yyval.param_list, &yyval.param_list, yyvsp[0].text.text);
	}
break;
case 95:
#line 586 "grammar.y"
{
	    add_ident_list(&yyval.param_list, &yyvsp[-2].param_list, yyvsp[0].text.text);
	}
break;
case 96:
#line 593 "grammar.y"
{
	    yyval.declarator = new_declarator(yyvsp[0].text.text, "", yyvsp[0].text.begin);
	}
break;
case 97:
#line 597 "grammar.y"
{
	    yyval.declarator = yyvsp[0].declarator;
	    sprintf(buf, "%s%s", yyvsp[-1].text.text, yyval.declarator->text);
	    free(yyval.declarator->text);
	    yyval.declarator->text = xstrdup(buf);
	    yyval.declarator->begin = yyvsp[-1].text.begin;
	}
break;
case 99:
#line 609 "grammar.y"
{
	    yyval.declarator = yyvsp[-1].declarator;
	    sprintf(buf, "(%s)", yyval.declarator->text);
	    free(yyval.declarator->text);
	    yyval.declarator->text = xstrdup(buf);
	    yyval.declarator->begin = yyvsp[-2].text.begin;
	}
break;
case 100:
#line 617 "grammar.y"
{
	    yyval.declarator = yyvsp[-1].declarator;
	    sprintf(buf, "%s%s", yyval.declarator->text, yyvsp[0].text.text);
	    free(yyval.declarator->text);
	    yyval.declarator->text = xstrdup(buf);
	}
break;
case 101:
#line 624 "grammar.y"
{
	    yyval.declarator = new_declarator(yyvsp[0].text.text, "", yyvsp[0].text.begin);
	}
break;
case 102:
#line 628 "grammar.y"
{
	    yyval.declarator = new_declarator("%s()", "", yyvsp[-3].declarator->begin);
	    yyval.declarator->params = yyvsp[-1].param_list;
	    yyval.declarator->func_stack = yyvsp[-3].declarator;
	    yyval.declarator->head = (yyvsp[-3].declarator->func_stack == NULL) ? yyval.declarator : yyvsp[-3].declarator->head;
	    yyval.declarator->func_def = FUNC_ANSI;
	}
break;
case 103:
#line 636 "grammar.y"
{
	    yyval.declarator = new_declarator("%s()", "", yyvsp[-2].declarator->begin);
	    yyval.declarator->func_stack = yyvsp[-2].declarator;
	    yyval.declarator->head = (yyvsp[-2].declarator->func_stack == NULL) ? yyval.declarator : yyvsp[-2].declarator->head;
	    yyval.declarator->func_def = FUNC_ANSI;
	}
break;
case 104:
#line 643 "grammar.y"
{
	    Declarator *d;
	    
	    d = new_declarator("", "", yyvsp[-2].text.begin);
	    yyval.declarator = new_declarator("%s()", "", yyvsp[-2].text.begin);
	    yyval.declarator->params = yyvsp[-1].param_list;
	    yyval.declarator->func_stack = d;
	    yyval.declarator->head = yyval.declarator;
	    yyval.declarator->func_def = FUNC_ANSI;
	}
break;
case 105:
#line 654 "grammar.y"
{
	    Declarator *d;
	    
	    d = new_declarator("", "", yyvsp[-1].text.begin);
	    yyval.declarator = new_declarator("%s()", "", yyvsp[-1].text.begin);
	    yyval.declarator->func_stack = d;
	    yyval.declarator->head = yyval.declarator;
	    yyval.declarator->func_def = FUNC_ANSI;
	}
break;
#line 1253 "y_tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
