/****************************************************************
* FILE:	load.c
* DESC:	This program loads a PCX file or a list of them.
*		It crams as many into memory as it can, then it flips
*		quickly through them.
* 
* HISTORY:	Created	 7/05/1994
* LAST CHANGED:  7/06/1994
* 
*	Copyright (c) 1994 by Scott Anderson
*
****************************************************************/

/* ----------------------INCLUDES----------------------------- */

#include <conio.h>
#include <stdio.h>
#include <io.h>
#include <math.h>
#include <graph.h>
#include <string.h>

#include "define.h"

/* ----------------------EXTERNALS---------------------------- */

/* External functions */
extern int	quitCheck();
extern LINKED_LIST	*rootSequence(int argc, char *argv[]);

/* External variables */
extern int	Wait;
extern int 	Key;
extern int	EndWait;

/* ----------------------GLOBAL DATA-------------------------- */

PICTURE *Src[MAX_FILES];			/* source picture pointer */

/*****************************************************************
* FUNC: main (int argc, char *argv[])
* 
* DESC: Display the file or sequence passed on the command line.
*		Read in as many files as will fit in memory, then display
*		them in a loop, forward and backward.
*****************************************************************/

main (int argc, char *argv[])
{
	int file, fileNum;
	int direction;
	int i;
	LINKED_LIST *pcxList;
	LINKED_LIST *pcxListHead;
	
	if (argc == 1) {
		printf("Usage: load <name>\n\n");
		printf("Where: <name> is the root name of a sequence\n");
		exit(23);
	}
	setGraphicsMode();

	file = 1;
	pcxListHead =  rootSequence(argc, argv);
	for (pcxList=pcxListHead; pcxList; pcxList = pcxList->next) {
		Src[file] = loadPicture(pcxList->str);
		if (Src[file] == NULL)
			break;
		displayPicture(Src[file++]);
	}

	fileNum = file - 1;
	if (fileNum == 1)	/* there's only one file */ 
		waitForKey();	/* so wait for the user to quit */
	else if (fileNum > 1) {
		file = 1;
		direction = 1;
		while (!(quitCheck())) {
			if ((file += direction) >= fileNum)
				direction = -1;
			if (file <= 1)
				direction = 1;
			displayPicture(Src[file]);
			if (EndWait && (file == 1 || file == fileNum))
				wait(Wait);
		}
	}
	/* Reset to original mode, then quit */
	setTextMode();
}
