#include <stdio.h>
#include <conio.h>

#include "fixfloat.h"

/*

  Examples of how to use fixpoint arithmetic functions
  provided by fixfloat.asm.

  Compile under Watcom C/C++ 10.0, 32 bit Protected Mode

  Author :    Arne Steinarson, email arst@ludd.luth.se

*/



// 
// Small func to print a fixfloat with dec representation
//
void fix_outd(long ff){
  char buf[20];

  fftoa(ff,buf);
  puts(buf);
  }

// 
// Small func to print a fixfloat with hex representation
//
void fix_outh(long ff){
  char buf[20];

  fftoah(ff,buf);
  puts(buf);
  }

// 
// Small func to input a fixfloat with a lead text
//
long fix_in(char *lead){
  float f;

  if(lead) puts(lead);
  scanf("%f",&f);
  return f*65536;
  }


void main(){

  long   a,b,c,d;

  printf("\nASSIGNMENT AND REPRESENTATION");
  a = 3.1415 * 65536;
  printf("\nassigning a = 3.1415 * 65536 \n");
  printf("\n a in decimal form          %d",a);
  printf("\n a in hexadecimal form      0x%X",a);
  printf("\n a printed with fftoa conversion  "); fix_outd(a);
  printf(" a printed with fftoah conversion 0x"); fix_outh(a);


  getch();
  printf("\nFIXFLOAT TO INTEGER");
  printf("\nTaking integer part of a through a>>16 : %d\n", a>>16);


  getch();


  printf("\nADDITION");
  a = 8.7 * 65536;
  b = 2.2 * 65536;

  printf("\n a is now "); fix_outd(a);
  printf(" b is now "); fix_outd(b);
  printf(" Executing c = b + a :"); 
  c = b + a;
  printf("\n c is now "); fix_outd(c);


  getch();


  printf("\nINLINE ASSEMBLY SIGNED MULTIPLICATION");
  a = 3.3 * 65536;
  b = -3.0 * 65536;

  printf("\n a is now "); fix_outd(a);
  printf(" b is now "); fix_outd(b);
  printf(" Executing c = iffsmul(a, b) :"); 
  c = iffsmul(a, b);
  printf("\n c is now "); fix_outd(c);


  getch();


  printf("\nUNSIGNED MULTIPLICATION THROUGH FUNCTION CALL");
  a = 3.3 * 65536;
  b = 1000.0 * 65536;

  printf("\n a is now "); fix_outd(a);
  printf(" b is now "); fix_outd(b);
  printf(" Executing c = ffmul(a, b) :"); 
  c = ffmul(a, b);
  printf("\n c is now "); fix_outd(c);


  getch();


  printf("\nINLINE ASSEMBLY SIGNED DIVISION");
  a = 15.5 * 65536;
  b = -5.0 * 65536;

  printf("\n a is now "); fix_outd(a);
  printf(" b is now "); fix_outd(b);
  printf(" Executing c = iffsdiv(a, b) :"); 
  c = iffsdiv(a, b);
  printf("\n c is now "); fix_outd(c);


  getch();


  printf("\nUNSIGNED DIVISION THROUGH FUNCTION CALL");
  a = 10.0 * 65536;
  b = 4.0 * 65536;

  printf("\n a is now "); fix_outd(a);
  printf(" b is now "); fix_outd(b);
  printf(" Executing c = ffdiv(a, b) :"); 
  c = ffdiv(a, b);
  printf("\n c is now "); fix_outd(c);


  getch();


  printf("\nThe functions ffdiv & ffsdiv have protection ");
  printf("\nagainst divide overflows, for example 7/0");
  printf("\nThis simplifies programming sometimes but ");
  printf("\ndivision takes longer time due to argument checking ");
  printf("\n\nEXAMPLE : ");

  a = -7.0 * 65536;
  b = 0.0 * 65536;

  printf("\n a is now "); fix_outd(a);
  printf(" b is now "); fix_outd(b);
  printf(" Executing c = ffsdiv(a, b) :"); 
  c = ffsdiv(a, b);
  printf("\n c is now "); fix_outd(c);

  getch();




  printf("\nAs we move to transcendental functions");
  printf("\nTables have to be initialized by gen_fixfloat_tables()");

  gen_fixfloat_tables();
  getch();


  printf("\n\n\nIn fixfloat universe there are 65536 degrees ");
  printf("\non a circle ( integer perspective ) or 1 degree");
  printf("\n( fixfloat perspective ). Here are some degrees ");
  printf("\nin 360 degree scale, 1 degree scale and 65536");
  printf("\ndegree scale\n");

  printf("\n360 CIRCLE   65536 CIRCLE    1.00 CIRCLE \n\n");

  for(a=0; a<=65536; a+=8192){  
    printf(" %4d         %5d         ", a * 360 / 65536, a);
    fix_outd(a);
    }

  getch();


  printf("\n\nTRIGONOMETRIC FUNCTIONS\n ");

  a = 45 * 65536 / 360;

  printf("\n a is now "); fix_outd(a);
  printf("corresponing to %d degrees ", a*360/65536); 

  printf(" Executing c = ffsin(a) :"); 
  c = ffsin(a);
  printf("\n c is now "); fix_outd(c);

  getch();

  printf("\n Lets go the other way : ");
  printf(" Executing a = ffasin(c) :"); 
  a = ffasin(c);

  printf("\n a is now "); fix_outd(a);
  printf("corresponing to %d degrees ", a*360/65536); 

  getch();

  printf("\n\nThe functions ffcos, ffacos, fftan, ffatan");
  printf("\nworks in a similar way");


  getch();


  printf("\n\nThe function ff_vec_to_ang tells what direction");
  printf("\na certain vector is pointing, the coordinate system");
  printf("\nhave increasing x to the right and increasing y upward :");

  a = 4.0 *65536;
  b = 2.0 * 65536;

  printf("\n a is now "); fix_outd(a);
  printf(" b is now "); fix_outd(b);
  printf(" Executing c = ff_vec_to_ang(a, b) :"); 
  c = ff_vec_to_ang(a, b);
  printf("\n c is now "); fix_outd(c);
  printf("corresponing to %d degrees ", c*360/65536); 


  getch();


  printf("\n\nLOGARITHMIC & EXPONENTIAL FUNCTIONS\n ");
    
  a = 1024 *65536;

  printf("\n a is now "); fix_outd(a);
  printf(" Executing c = fflog2(a) :"); 
  c = fflog2(a);
  printf("\n c is now "); fix_outd(c);

  getch();

  printf("\n Lets go the other way : ");
  printf(" Executing a = ffexp2(c) :"); 
  a = ffexp2(c);

  printf("\n a is now "); fix_outd(a);

  
  getch();


  printf("\nThere's also an exp function to raise ");
  printf("\nan arbitrary number to another arbitrary");
  printf("\nnumber, range is very limited with fixfloat though.");
 
  printf("\n\nEXPONENTIAL FUNTION");
  a = 9.0 * 65536;
  b = 2.5 * 65536;

  printf("\n a is now "); fix_outd(a);
  printf(" b is now "); fix_outd(b);
  printf(" Executing c = ffpow(a , b) :"); 
  c = ffpow(a , b);
  printf("\n c is now "); fix_outd(c);

  getch();


  printf("\nSQUARE ROOT : ");
  a = 625 * 65536;

  printf("\n a is now "); fix_outd(a);
  printf(" Executing c = ffsqrt(a) :"); 
  c = ffsqrt(a);
  printf("\n c is now "); fix_outd(c);


  getch();


  printf("\n\nA sad fact in 16.16 fixfloat universe is that");
  printf("\nwhen squaring a number >=256.0 32 bits will overflow.");
  printf("\nSort of a cure is to use 64 bit intermediate ");
  printf("\nquantities, because in the end one will want to");
  printf("\ntake the root of it all or divide by a ");
  printf("\nfairly large number. Asm language handles 64 bit"); 
  printf("\nquantities well, not C however.");

  printf("\n\nFunctions ffhyp, fftrihyp, ffmmd, ffmuldiv");
  printf("\nff_solve_2nd_poly will NEVER overflow because they");
  printf("\nuse intermediate 64 bit quantities.");

  getch();

  printf("\n\n2 DIM DISTANCE FUNCTION ( c = sqrt( a*a + b*b )): ");
  a = 3 * 65536;
  b = 4 * 65536;

  printf("\n a is now "); fix_outd(a);
  printf(" b is now "); fix_outd(b);
  printf(" Executing c = ffhyp(a,b) :"); 
  c = ffhyp(a,b);
  printf("\n c is now "); fix_outd(c);


  getch();


  printf("\nMany times one needs just a very rough approximation");
  printf("\nto the distance between 2 points, if an accuracy of");
  printf("\n10 to 15 percent is enough, squaring & rooting is quite");
  printf("\na waste of time. ffalmosthyp() might come in handy here");
  printf("\nit executes in roughly 18 clocks and works just as");
  printf("\nwell with integers input to it");

  getch();

  printf("\n\n2 DIM DISTANCE FUNCTION ( c = max(a, b) - min(a, b)/2): ");
  a = 3 * 65536;
  b = 4 * 65536;

  printf("\n a is now "); fix_outd(a);
  printf(" b is now "); fix_outd(b);
  printf(" Executing c = ffalmosthyp(a,b) :"); 
  c = ffalmosthyp(a,b);
  printf("\n c is now "); fix_outd(c);


  getch();


  printf("\n\n3 DIM DISTANCE FUNCTION ( c = sqrt( a*a + b*b + c*c)): ");
  a = 3 * 65536;
  b = 4 * 65536;
  c = 4 * 65536;

  printf("\n a is now "); fix_outd(a);
  printf(" b is now "); fix_outd(b);
  printf(" c is now "); fix_outd(b);
  printf(" Executing d = fftrihyp(a,b,c) :"); 
  d = fftrihyp(a,b,c);
  printf("\n d is now "); fix_outd(d);


  getch();


  printf("\n\n INTEGER SQUARE ROOT");

  a = 120000;

  printf("\n a is now %d",a );
  printf(" Executing c = isqrt(a) :"); 
  c = isqrt(a);
  printf("\n c is now %d",c );


  getch();


  printf("\n\n RANDOM NUMBER FUNCTIONS ");

  printf("\nThere are three random number functions for");
  printf("\ndifferent situations : ");

  printf("\n\nrand32       generates a full 32 bit random number");

  printf("\n\nrandinter    generates a random number in a");
  printf("\n             speced interval");

  printf("\n\nrandpowint   does the same but gets some help by");
  printf("\n             the user providing the 2 power value-1");
  printf("\n             closest above the desired interval");
  printf("\n             This makes it speedier.");

  getch();

  printf("\n\n Here comes a few 32 bit random numbers  ");
  printf("\n generated by rand32() : ");

  for(a=0;a<10;a++)
    printf("\n%10d",rand32());

  getch();

  printf("\n\n Here comes a few random numbers between 0 and 49 : ");
  printf("\n generated by randinter(50) : ");

  for(a=0;a<10;a++)
    printf("\n%3d",randinter(50));

  getch();

  printf("\n\n Here comes a few random numbers between 0 and 49 : ");
  printf("\n generated by randpowint(63,50) : ");

  for(a=0;a<10;a++)
    printf("\n%3d",randpowint(63,50));


  getch();


  printf("\n\nThere are more functions which are documented");
  printf("\nin textfile fixfloat.doc.");
  printf("\n\nIf you find bugs let me know so I can fix them. ");
  printf("\nIf you write some nice fast asm functions ");
  printf("\nworking with fixfloat numbers why not email ");
  printf("\nCODE & DOC to me = arst@ludd.luth.se  ;-) .");

  printf("\n\n If your code dont execute ...");
  printf("\n\n ... try compiling it !");
  getch();
  }







