/*

BBS.C

This is a sample BBS program that you can use as a building block..

					Adrian J. Michaud
*/

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "promodem.h"

void main(void);

/* High Speed modem, 14.4k, use 2400 for 2400 baud modems */
#define MAX_BAUD_RATE  38400

#define EXIT_BBS       1     /* Used to check if operator quits BBS */

int  InitSystemModem (void);
int  WaitForCaller   (void);
void MainOptionsMenu (void);
void Delay           (int delay);
void Modem           (char *string);
int  Input           (char *buffer, int maxIn);
void ChatMode        (void);

AJMS controlBlock;
int  onLine = 0;   /* Set to 0 for local logon, set to 1 for remote logon */

void main(void)
{
int retCod;
int baseAddress=0, irq=0, comPorm;
char com_port[255];

while (!irq && !baseAddress)
  {
  printf("\nEnter Com port [1 or 2]: ");
  gets(com_port);

  if (strstr(com_port, "1"))
     {
     baseAddress = 0x3f8;
     irq          = 4;
     }

  else
  if (strstr(com_port, "2"))
     {
     baseAddress = 0x2f8;
     irq          = 3;
     }
  }

#define BUFFER_SIZE 4096  /* Use a 4K receive IRQ Buffer */

/* Set up a communication control block that is used by all library functions */
retCod = SetupControlBlock(&controlBlock, baseAddress, irq, BUFFER_SIZE);
if (retCod != SUCCESSFUL)                 /* Check for errors  */
   {
   printf("\nUnable to set up Communication Control Block!\n");
   exit(1);
   }

/* Open the com port for communication */
retCod = OpenCom(&controlBlock);
if (retCod != SUCCESSFUL)                 /* Check for errors  */
   {
   printf("\nUnable to open COM port!\n");
   exit(1);
   }

SetBaudRate(&controlBlock, MAX_BAUD_RATE);
SetDataFormat(&controlBlock, BITS_8 | STOP_BITS_1 | NO_PARITY);

 for ( ; ; )  /* Endless LOOP */
 {
 if (InitSystemModem() == EXIT_BBS) break;
 if (WaitForCaller()   == EXIT_BBS) break;
 MainOptionsMenu();
 }
DropDTR(&controlBlock);
CloseCom(&controlBlock);
}

int InitSystemModem(void)
{
char ch;
char buffer[80];
int counter=0;

printf("\nInitilizing System Modem...\n");
Delay(10);

SendString(&controlBlock, "ATE1");
SendCharacter(&controlBlock, 13);

   for ( ; ; )
    {
    ch = WaitForCharacter(&controlBlock, 8.00);
    if (ch == WAIT_TIME_OUT)
       {
       printf("\nModem is not Responding - Try a different COM port.\n");
       return(EXIT_BBS);
       }
    if (ch == 10)
       {
       buffer[counter]=0;
       strupr(buffer);
       if (strstr(buffer, "OK")) break;
       counter=0;
       }
    buffer[counter++] = ch;
    printf("%c", ch);
    }

printf("\n");
Delay(10);
ClearQueue(&controlBlock);
counter=0;

SendString(&controlBlock, "ATH0Q0V1E1X1S0=0S10=40&C1M1");
SendCharacter(&controlBlock, 13);

   for ( ; ; )
    {
    ch = WaitForCharacter(&controlBlock, 8.00);
    if (ch == WAIT_TIME_OUT)
       {
       printf("\nModem is not Responding - Try a different COM port.\n");
       return(EXIT_BBS);
       }
    if (ch == 13)
       {
       buffer[counter]=0;
       strupr(buffer);
       if (strstr(buffer, "OK")) break;
       counter=0;
       }
    buffer[counter++] = ch;
    printf("%c", ch);
    }
return(0);
}

int WaitForCaller(void)
{
int ch;
char buffer[80];
int  counter=0;

printf("\n\nWaiting for a call up to %ld baud.\n", MAX_BAUD_RATE);
printf("\nPress [ESC] to exit BBS, space bar to logon local.\n");

printf("\nModem responses:\n");
ClearQueue(&controlBlock);

for ( ; ; )
   {
   if (kbhit())
      {
      ch = (char)getch();
      if (ch == 27) return(EXIT_BBS);
      if (ch == 32) break;
      }
   if (CheckQueue(&controlBlock) == CHARACTERS_WAITING)
     {
     ch = GetCharacter(&controlBlock);
     printf("%c", ch);
     if (ch == 10)
       {
       buffer[counter]=0;
       strupr(buffer);
       if (strstr(buffer, "RING"))
	  {
	  Delay(20);
	  counter=0;
	  SendString(&controlBlock, "ATA");
	  SendCharacter(&controlBlock, 13);
	  }
       if (strstr(buffer, "CONNECT"))
	  {
	  onLine=1;
	  break;
	  }
       }
     buffer[counter++] = ch;
     }
   }
return(0);
}

void MainOptionsMenu(void)
{
char buffer[255],ch;
FILE *fp;

if (onLine)
Delay(40);    /* Give remote users modem a chance to connect correctly */

for ( ; ; )   /* Endless Loop */
 {
 Modem("\n\nWelcome to a sample BBS written using ProModem!\n");
 Modem("\nYour options are:\n");
 Modem("\n[V]iew PROMODEM.DOC on-line!");
 Modem("\n[E]nter chat mode.");
 Modem("\n[H]ang-up.\n");

 Modem("\nChoice: ");
 Input(buffer, 3);          /* input prompt */
 if (onLine)
 if (GetCarrierDetect(&controlBlock) == NO_CARRIER) break;

 strupr(buffer);            /* convert input to uppercase */

 if (!strcmp(buffer, "V"))
    {
    fp = fopen("PROMODEM.DOC", "r");
    if (!fp)
       {
       Modem("\n\nPROMODEM.DOC file not found!\n");
       continue;
       }
    while (!feof(fp))
      {
      if (CheckQueue(&controlBlock) == CHARACTERS_WAITING)
	 {
	 ClearQueue(&controlBlock);
	 break;
	 }
      if (kbhit())
	{
	getch();
	break;
	}

      ch = fgetc(fp);
      if (ch == 13) ch = 10;
      if (onLine)
      SendCharacter(&controlBlock, ch);
      printf("%c", ch);
      }
    fclose(fp);
    continue;
    }

 if (!strcmp(buffer, "E"))
    {
    Modem("\nChat Mode Entered!\n");
    ChatMode();
    continue;
    }

 if (!strcmp(buffer, "H"))
    {
    Modem("\n\nGoodbye!\n");
    Delay(20);
    DropDTR(&controlBlock);
    Delay(5);
    SetDTR(&controlBlock);
    return;
    }
  } /* end of for ( ; ; ) */
}

void   Delay(int timeout)
{
clock_t current;
int total=0;

current = clock();
for ( ; ; )
 {
 while( current == clock());
 current = clock();
 if (total++ >= timeout) break;
 }
}

void Modem(char *string)
{
int i,len;
int temp;

len = strlen(string);

for (i=0; i<len; i++)
  {
  if (onLine)
  SendCharacter(&controlBlock, string[i]);
  printf("%c", string[i]);

  if (string[i] == 10)
    {
  if (onLine)
  SendCharacter(&controlBlock, 13);
    printf("%c", 13);
    }
  }
}

void ChatMode(void)
{
unsigned char ch;

printf("\n\nSysOp: Press ESC to abort chat..\n");

for ( ; ; )
   {
   if (onLine)
   if (GetCarrierDetect(&controlBlock) == NO_CARRIER) break;

   if (kbhit())                   /* Check if Key Press */
     {
     ch = (char)getch();          /* Get Character from Keyboard */
     if (ch == 27) break;         /* if ESC, ABORT!              */
     if (ch == 13) ch = 10;
     printf("%c",ch);
     if (onLine)
     SendCharacter(&controlBlock, (unsigned char)ch); /* Send character to modem     */
     }
   if (CheckQueue(&controlBlock)==CHARACTERS_WAITING)  /* Check IRQ buffer for chars */
      {
      if (onLine)
	 {
	 ch = GetCharacter(&controlBlock);
	 if (ch == 13) ch = 10;
	 printf("%c", ch); /* Display Them */
	 SendCharacter(&controlBlock, ch);
	 }
      }
   } /* end of for ( ; ; ) */
}

int Input(char *buffer, int max_in)
{
int ch;
char backspace[10];
int i=0;

ClearQueue(&controlBlock);  /* Clear any characters that might be in the queue */
for ( ; ; )
  {
  while (!kbhit() && CheckQueue(&controlBlock) != CHARACTERS_WAITING)
      {
      if (onLine)
      if (GetCarrierDetect(&controlBlock) == NO_CARRIER)
	 {
	 buffer[0] = 0;
	 return(0);
	 }
      }   /* Wait for a key press from modem or keyboard */

  if (kbhit())            /* Get Keypress from keyboard */
    ch = getch();
  else
   if (onLine)           /* Get character from modem */
    ch = GetCharacter(&controlBlock);

  if (ch == 8 && i == 0) continue;

  if (ch == 8) {
	       i--;
	       sprintf(backspace, "%c%c%c",8,32,8);
	       Modem(backspace);
	       continue;
	       }

  if (ch == 13) {
		buffer[i] = 0;
		i=0;
		break;
		}

  if (max_in > 1 && i == max_in-1) continue;

  if (ch <32) continue;
  i++;

  printf("%c",ch);                   /* Display character to screen */
  if (onLine)
  SendCharacter(&controlBlock, (unsigned char)ch);  /* Send character to modem */
  buffer[i-1] =(char)ch;

  if (max_in == 1) {
		   buffer[i] = 0;
		   break;
		   }
  }
return(0);
}

