#define MAX_IRQ_ROUTINES    10

typedef struct serialControlBlock
	{
	int com_data;
	int com_ier;
	int com_ists;
	int com_setings;
	int com_mcr;
	int com_sts;
	int com_dunno;
	int pointer1,pointer2;
	int com_int;
	char *irq_buffer;
	int bufferSize;
	int irqIndex;
	long status;
	} AJMS;

int  OpenCom             (AJMS *controlBlock);
int  CloseCom            (AJMS *controlBlock);
int  SendCharacter       (AJMS *controlBlock, unsigned char ch);
int  CheckQueue          (AJMS *controlBlock);
int  GetCharacter        (AJMS *controlBlock);
void ClearQueue          (AJMS *controlBlock);
int  GetCarrierDetect    (AJMS *controlBlock);
void SetBaudRate         (AJMS *controlBlock, unsigned long baudRate);
void SetDTR              (AJMS *controlBlock);
void DropDTR             (AJMS *controlBlock);
void SetDataFormat       (AJMS *controlBlock, int options);
int  SendString          (AJMS *controlBlock, char *string);
int  SetFIFOMode         (AJMS *controlBlock);
int  WaitForCharacter    (AJMS *controlBlock, double seconds);
int  SetFIFOTriggerLevel (AJMS *controlBlock, unsigned char parameter);
void DisableIRQ          (AJMS *controlBlock);
void EnableIRQ           (AJMS *controlBlock);


int SetupControlBlock(AJMS *controlBlock,
		      unsigned int baseAddress,
		      int irq,
		      unsigned int bufferSize);

#define BIT_0          1
#define BIT_1          2
#define BIT_2          4
#define BIT_3          8
#define BIT_4          16
#define BIT_5          32
#define BIT_6          64
#define BIT_7          128

#define I_IRQ3         0x0b
#define I_IRQ4         0x0c

#define PIC_MASK       0x21
#define PIC_EOI        0x20
#define PIC_OFFSET     0x08
#define INT_MASK       0x08

/* Parameters for SetFIFOTriggerLevel */
#define FIFO_1_TRIGGER            (unsigned char)0
#define FIFO_4_TRIGGER            (unsigned char)64
#define FIFO_8_TRIGGER            (unsigned char)128
#define FIFO_16_TRIGGER           (unsigned char)192

/* Parameters for SetDataFormat */
#define  BITS_5        0     /* Neither Bit 0 or 1 is set         */
#define  BITS_6        1     /* Bit 0 of Data Format Register     */
#define  BITS_7        2     /* Bit 1 of Data Format Register     */
#define  BITS_8        3     /* Bit 0 & 1 of Data Format Register */
#define  STOP_BITS_1   0     /* Bit 2 not Set in Data Format Register */
#define  STOP_BITS_2   4     /* Bit 2 Set in Data Format Register     */
#define  PARITY_ON     8     /* Bit 3 set in Data Format Register     */
#define  NO_PARITY     0     /* Bit 3 not set in Data Format Register */
#define  EVEN_PARITY   16    /* Bit 4 set in Data Format Register     */
#define  ODD_PARITY    0     /* Bit 4 not set in Data Format Register */
#define  STICK_PARITY  32    /* Bit 5 set in Data Format Register     */
#define  SET_BREAK     64    /* Bit 6 set in Data Format Register     */

/* Error Codes for SetupControlBlock */
#define SUCCESSFUL               0
#define TOO_MANY_IRQS            1

/* Return Codes for OpenCom */
#define SUCCESSFUL               0
#define BUFFER_ALLOCATION_ERROR  1
#define COM_ALREADY_OPEN         2

/* Return Codes for CloseCom */
#define SUCCESSFUL         0
#define COM_PORT_NOT_OPEN  1

/* Return Codes for SendCharacter */
#define CARRIER                  1
#define NO_CARRIER               0

/* Return Codes for CheckQueue */
#define CHARACTERS_WAITING       1
#define QUEUE_EMPTY              0

/* Return Codes for GetCarrierDetect */
#define CARRIER                  1
#define NO_CARRIER               0

/* Return Codes for SetFIFOMode */
#define FIFO_ENABLED             1
#define NO_FIFO_PRESENT          0

/* Return Codes for WaitForCharacter */
#define WAIT_TIME_OUT                 0

/* Return Codes for SetFIFOTriggerLevel */
#define INVALID_TRIGGER_LEVEL         1
#define SUCCESSFUL                    0

