/* simple rhyming wheel program -- finds rhymes for an input word.
  12/30/96 -- w.howell (CIS 70215,206, whowell@superlink.net)
  My girlfriend's son brought home a rhyming wheel from school -- it makes
  up words by combining various prefixes (fronts) with suffixes (backs)
  of words.  I've implemented the wheel as a simple C program, and added
  a few suffixes.  The program is self-dimensioning in both the front
  and back tables, so please feel free to add to either (I added ell to
  the back table to find rhymes for my name (Well).
  works for me in Microsoft C (8.00c) -- ENJOY -- HAPPY NEW YEAR!
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void main(int, char **);
void help(int, char *, char *);                   /* user help & exit */

/* front of rhyming words (prefix) */
char front[][4] = { "b", "bl", "br", "c", "ch", "cl", "cr", "d", "dr", "f",
  "fl", "fr", "g", "gl", "gn", "gr", "h", "j", "k", "kn", "l", "m", "n", "p",
  "ph", "pl", "pr", "qu", "r", "rh", "s", "sc", "sch", "scr", "sh", "sk", "sl",
  "sm", "sn", "sp", "st", "str", "sw", "t", "th", "thr", "tr", "tw", "v", "w",
  "wh", "wr", "xy", "y", "z" };
/* number of entries in front table */
int n_front = sizeof(front) / sizeof(front[0]);

/* back of rhyming words (suffix) */
char back[][5] = { "able", "ack", "ad", "ail", "ake", "ale", "all", "am", "ame",
  "an", "and", "ank", "ar", "at", "ate", "ave", "ay", "e", "ea", "each", "eat",
  "eck", "ed", "edge", "ee", "eel", "ell", "en", "end", "est", "ew", "ice",
  "ick", "ide", "ig", "ight", "ill", "im", "ime", "in", "ing", "ip", "ite", "o",
  "oar", "oat", "ock", "od", "oe", "og", "old", "om", "ome", "on", "oo", "ool",
  "op", "or", "ost", "ot", "ough", "ow" };
/* number of entires in back table */
int n_back = sizeof(back) / sizeof(back[0]);

void main( int argc, char *argv[] )
{
    int f,     /* subscript into front table */
        b,     /* subscript into back table */
        wlen,  /* word length */
        blen,  /* back entry length */
        w_back;/* subscript of word back to match with fronts */
    char word[20];  /* the word we're trying to rhyme -- output work area */

    if(argc != 2) help(1,"No Word", " "); /* MUST have a word on command line */
    strcpy(word, argv[1]);
    wlen = strlen(word);
    w_back = -1;

    for(b=0; b<n_back; b++) {    /* loop thru the suffixes (backs) for match */
       blen = strlen(back[b]);
       if(blen >= wlen) continue;      /* no use unles word longer than back */
       if(strcmp(&back[b][0], &word[wlen - blen]) == 0) { w_back = b; break; }
       }

   if(w_back == -1)  help(2,"No Suffix", word);                   /* no joy */

   for(f=0; f<n_front; f++) {    /* show the back with all fronts -- 6/line */
      strcpy(word,front[f]);  strcat(word, back[w_back]);
      if(f % 6 == 0) printf("\n%12s", word);
      else           printf("%12s",   word);
      }
   printf("\n");
}

/* ===================== HELP ==================== */
void help(int helpno, char *helptext, char *ar)
{
 switch(helpno) {
    case(1):
    case(2):
      fprintf(stderr,"Bad command-line = %s -- %s\n", ar, helptext);
      break;
    default: break;
    }
 fprintf(stderr,"Help called with code %d\n", helpno);
 printf("usage: rhyme  WORD\n");
 printf("  WORD = a word you wish to find rhymes for\n");
 exit(1);
}
