/* syntax.c Program running a quick syntax check on C source
   code Version 1.11  J. Tomasik; created 05/23/87

   From BYTE magazine - September 1987

*/

#include <stdio.h>

main(argc, argv)
int argc;
char *argv[];
{
        FILE *fopen(), *infile;
        char c;
        int lbrace = 0, rbrace = 0;
        int squote = 0, dquote = 0;
        int lpar = 0, rpar = 0;
        int lbrkt = 0, rbrkt = 0;
        int bytecount = 0, errorcount = 0;

        if (argc != 2) {
          printf("SYNTAX checker for C source code, version 1.11\n");
          printf("Copyright (C) J. Tomadik 1987, 1988\n\n");
          printf("Usage: syntax fname.ext \n");
        exit(1);
        }
infile = fopen(argv[1],"r");
if (infile == NULL) {
        printf("Cannot open %s \n", argv[1]);
        exit(2);
}

while ((c = fgetc(infile)) != EOF) {
        ++bytecount;
        if (c == '{') ++lbrace;
       else
        if (c == '}') ++rbrace;
       else
        if (c == '\'') ++squote;
       else
        if (c == '\"') ++dquote;
       else
        if (c == '(') ++lpar;
       else
        if (c == ')') ++rpar;
       else
        if (c == '[') ++lbrkt;
       else
        if (c == ']') ++rbrkt;
}

fclose(infile);
printf("The file length is %d \n", bytecount);


if (lbrace != rbrace) {
        printf("There are %3d left and %3d right braces \n",
                lbrace, rbrace);
        ++errorcount;
}

if (lpar != rpar) {
        printf("There are %3d left and %3d right parentheses \n",
                lpar, rpar);
        ++errorcount;
}

if (lbrkt != rbrkt) {
        printf("There are %3d left and %3d right brackets \n",
                lbrkt,rbrkt);
        ++errorcount;
}

if (squote %2) {
        printf("The single quote marks are not paired \n");
        ++errorcount;
}

if (dquote %2) {
        printf("The double quote marks are not paired \n");
        ++errorcount;
}

if (errorcount == 0) {
        printf("No error found, OK to compile \n");
}
else
        exit(errorcount);
}
