/***********************************************************************/
/* EDIT.C - The body of the program.                                   */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1995 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Id: edit.c 2.0 1995/01/26 16:30:53 MH Release MH $
*/

#include <stdio.h>
#include <time.h>

#include "the.h"
#include "proto.h"

/*#define TRACE*/
 bool prefix_changed=FALSE;
/***********************************************************************/
#ifdef PROTO
void editor(void)
#else
void editor()
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern VIEW_DETAILS *vd_first;
 extern short file_start;
 extern CHARTYPE *dirfilename;
 extern bool error_on_screen;
 extern CHARTYPE file_disposition;
 extern CHARTYPE number_of_files;
 extern WINDOW *foot,*error_window;
/*--------------------------- local data ------------------------------*/
 int key=0;
 unsigned short x=0,y=0;
 short rc=RC_OK;
 CHARTYPE string_key[2];
 VIEW_DETAILS *save_vd=vd_current;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("edit.c:    editor");
#endif
/*---------------------------------------------------------------------*/
/* For each view, calculate the current_row value. This has to be done */
/* AFTER initscr() so that the size of the filearea is known.          */
/*---------------------------------------------------------------------*/
 CURRENT_VIEW = vd_first;
 do
   {
    CURRENT_VIEW->current_row = calculate_actual_row(CURRENT_VIEW->current_base,
                                                     CURRENT_VIEW->current_off,
                                                     CURRENT_SCREEN.rows[WINDOW_MAIN]);
    CURRENT_VIEW = NEXT_VIEW;
   }
 while(CURRENT_VIEW);
 CURRENT_VIEW = save_vd;
/*---------------------------------------------------------------------*/
/* whoutrefresh() is called here so that the first call to getch() on  */
/* stdscr does not clear the screen.                                   */
/*---------------------------------------------------------------------*/
 wnoutrefresh(stdscr);

 if (CURRENT_WINDOW_ARROW != (WINDOW *)NULL)
   {
    touchwin(CURRENT_WINDOW_ARROW);
    wnoutrefresh(CURRENT_WINDOW_ARROW);
   }
/*---------------------------------------------------------------------*/
/* Put the cursor into the column between file time and file name for  */
/* the special DIR.DIR file.                                           */
/*---------------------------------------------------------------------*/
 if (strcmp(CURRENT_FILE->fname,dirfilename) == 0)
    wmove(CURRENT_WINDOW_MAIN,CURRENT_VIEW->current_row,file_start-1);
 else
    wmove(CURRENT_WINDOW_MAIN,CURRENT_VIEW->current_row,0);
/*---------------------------------------------------------------------*/
/* Display the current view(s)...                                      */
/*---------------------------------------------------------------------*/
 build_current_screen(); 
 display_current_screen();
 show_footing();
 if (CURRENT_WINDOW_PREFIX != NULL)
    wnoutrefresh(CURRENT_WINDOW_PREFIX);
 if (CURRENT_WINDOW_COMMAND != (WINDOW *)NULL)
   {
    wmove(CURRENT_WINDOW_COMMAND,0,0);
    touchwin(CURRENT_WINDOW_COMMAND);
    wnoutrefresh(CURRENT_WINDOW_COMMAND);
   }
 if (file_disposition != FILE_NORMAL)
   {
    switch(file_disposition)
      {
       case FILE_NEW:
                          display_error(0,(CHARTYPE *)"New File...",TRUE);
                          break;
       case FILE_READONLY:
                          display_error(0,(CHARTYPE *)"File is read-only...",FALSE);
                          break;
       default:
                          break;
      }
/*    wnoutrefresh(error_window);*/
   }
 wrefresh(CURRENT_WINDOW);

 while (1)
   {
#if defined(USE_EXTCURSES)
    getyx(CURRENT_WINDOW,y,x);
    wmove(CURRENT_WINDOW,y,x);
    wrefresh(CURRENT_WINDOW);
#endif
    key = my_getch(stdscr);
    if (error_on_screen)
       clear_msgline();
    rc = function_key(key);
    if (number_of_files == 0)
       break;
    if (rc >= RAW_KEY)
      {
       if (rc > RAW_KEY)
          key = rc - (RAW_KEY*2);
       if (key < 256 && key >= 0)
         {
          string_key[0] = (CHARTYPE)key;
          string_key[1] = '\0';
          (void)Text(string_key);
         }
      }
    show_footing();
#if 0
    if (CURRENT_VIEW->focus_line == CURRENT_VIEW->current_line
    &&  CURRENT_VIEW->hexshow_on
    &&  CURRENT_VIEW->current_window == WINDOW_MAIN)
      {
       getyx(CURRENT_WINDOW_MAIN,y,x);
       build_current_screen(); 
       display_current_screen();
       wmove(CURRENT_WINDOW_MAIN,y,x);
      }
#endif

    refresh_current_screen();
    if (error_on_screen)
      {
       getyx(CURRENT_WINDOW,y,x);
       touchwin(error_window);
       wnoutrefresh(error_window);
       wmove(CURRENT_WINDOW,y,x);
       wnoutrefresh(CURRENT_WINDOW);
      }
    doupdate();
   }
#ifdef TRACE
 trace_return();
#endif
 return;
}
