/*
 * This software is Copyright (c) 1989, 1990, 1991 by Patrick J. Wolfe.
 *
 * Permission is hereby granted to copy, distribute or otherwise
 * use any part of this package as long as you do not try to make
 * money from it or pretend that you wrote it.  This copyright
 * notice must be maintained in any copy made.
 *
 * Use of this software constitutes acceptance for use in an AS IS
 * condition. There are NO warranties with regard to this software.
 * In no event shall the author be liable for any damages whatsoever
 * arising out of or in connection with the use or performance of this
 * software.  Any use of this software is at the user's own risk.
 *
 * If you make modifications to this software that you feel
 * increases it usefulness for the rest of the community, please
 * email the changes, enhancements, bug fixes as well as any and
 * all ideas to me. This software is going to be maintained and
 * enhanced as deemed necessary by the community.
 *
 *              Patrick J. Wolfe
 *              uunet!uiucuxc!kailand!pwolfe
 *              pwolfe@kailand.kai.com
 *
 * Additions of DOS keys and extended function key descriptions
 * made by Mark Hessling.
 *
 */

/* System V curses key names and codes returned by getch */

/*
$Id: getch.h 2.0 1995/01/26 16:31:11 MH Release MH $
*/


#ifndef KEY_MIN
#define KEY_MIN         0x101           /* Minimum curses key */
#endif
#ifndef KEY_BREAK
#define KEY_BREAK	0x101	/* Not on PC KBD		 */
#endif
#ifndef KEY_DOWN
#define KEY_DOWN	0x102	/* Down arrow key		 */
#endif
#ifndef KEY_UP
#define KEY_UP		0x103	/* Up arrow key			 */
#endif
#ifndef KEY_LEFT
#define KEY_LEFT	0x104	/* Left arrow key		 */
#endif
#ifndef KEY_RIGHT
#define KEY_RIGHT	0x105	/* Right arrow key		 */
#endif
#ifndef KEY_HOME
#define KEY_HOME	0x106	/* home key			 */
#endif
#ifndef KEY_BACKSPACE
#define KEY_BACKSPACE	0x107	/* not on pc			 */
#endif
#ifndef KEY_F0
#define KEY_F0		0x108	/* function keys. space for	 */
#define KEY_F(n)    (KEY_F0+(n))/* 64 keys are reserved.	 */
#endif
#ifndef KEY_DL
#define KEY_DL		0x148	/* not on pc			 */
#endif
#ifndef KEY_IL
#define KEY_IL		0x149	/* insert line			 */
#endif
#ifndef KEY_DC
#define KEY_DC		0x14a	/* delete character		 */
#endif
#ifndef KEY_IC
#define KEY_IC		0x14b	/* insert char or enter ins mode */
#endif
#ifndef KEY_EIC
#define KEY_EIC		0x14c	/* exit insert char mode	 */
#endif
#ifndef KEY_CLEAR
#define KEY_CLEAR	0x14d	/* clear screen			 */
#endif
#ifndef KEY_EOS
#define KEY_EOS		0x14e	/* clear to end of screen	 */
#endif
#ifndef KEY_EOL
#define KEY_EOL		0x14f	/* clear to end of line		 */
#endif
#ifndef KEY_SF
#define KEY_SF		0x150	/* scroll 1 line forward	 */
#endif
#ifndef KEY_SR
#define KEY_SR		0x151	/* scroll 1 line back (reverse)	 */
#endif
#ifndef KEY_NPAGE
#define KEY_NPAGE	0x152	/* next page			 */
#endif
#ifndef KEY_PPAGE
#define KEY_PPAGE	0x153	/* previous page		 */
#endif
#ifndef KEY_STAB
#define KEY_STAB	0x154	/* set tab			 */
#endif
#ifndef KEY_CTAB
#define KEY_CTAB	0x155	/* clear tab			 */
#endif
#ifndef KEY_CATAB
#define KEY_CATAB	0x156	/* clear all tabs		 */
#endif
#ifndef KEY_ENTER
#define KEY_ENTER	0x157	/* enter or send (unreliable)	 */
#endif
#ifndef KEY_SRESET
#define KEY_SRESET	0x158	/* soft/reset (partial/unreliable)*/
#endif
#ifndef KEY_RESET
#define KEY_RESET	0x159	/* reset/hard reset (unreliable) */
#endif
#ifndef KEY_PRINT
#define KEY_PRINT	0x15a	/* print/copy			 */
#endif
#ifndef KEY_LL
#define KEY_LL		0x15b	/* home down/bottom (lower left) */
#endif
#ifndef KEY_ABORT
#define KEY_ABORT	0x15c	/* abort/terminate key (any)	 */
#endif
#ifndef KEY_SHELP
#define KEY_SHELP	0x15d	/* short help			 */
#endif
#ifndef KEY_LHELP
#define KEY_LHELP	0x15e	/* long help			 */
#endif
#ifndef KEY_BTAB 
#define KEY_BTAB        0x15f            /* Back tab key */
#endif
#ifndef KEY_BEG  
#define KEY_BEG         0x160            /* beg(inning) key */
#endif
#ifndef KEY_CANCEL
#define KEY_CANCEL      0x161             /* cancel key */
#endif
#ifndef KEY_CLOSE 
#define KEY_CLOSE       0x162             /* close key */
#endif
#ifndef KEY_COMMAND
#define KEY_COMMAND     0x163             /* cmd (command) key */
#endif
#ifndef KEY_COPY   
#define KEY_COPY        0x164             /* copy key */
#endif
#ifndef KEY_CREATE 
#define KEY_CREATE      0x165             /* create key */
#endif
#ifndef KEY_END    
#define KEY_END         0x166             /* end key */
#endif
#ifndef KEY_EXIT   
#define KEY_EXIT        0x167             /* exit key */
#endif
#ifndef KEY_FIND   
#define KEY_FIND        0x168             /* find key */
#endif
#ifndef KEY_HELP   
#define KEY_HELP        0x169             /* help key */
#endif
#ifndef KEY_MARK   
#define KEY_MARK        0x16a             /* mark key */
#endif
#ifndef KEY_MESSAGE
#define KEY_MESSAGE     0x16b             /* message key */
#endif
#ifndef KEY_MOVE   
#define KEY_MOVE        0x16c             /* move key */
#endif
#ifndef KEY_NEXT   
#define KEY_NEXT        0x16d             /* next object key */
#endif
#ifndef KEY_OPEN   
#define KEY_OPEN        0x16e             /* open key */
#endif
#ifndef KEY_OPTIONS
#define KEY_OPTIONS     0x16f             /* options key */
#endif
#ifndef KEY_PREVIOUS
#define KEY_PREVIOUS    0x170             /* previous object key */
#endif
#ifndef KEY_REDO    
#define KEY_REDO        0x171             /* redo key */
#endif
#ifndef KEY_REFERENCE
#define KEY_REFERENCE   0x172             /* ref(erence) key */
#endif
#ifndef KEY_REFRESH  
#define KEY_REFRESH     0x173             /* refresh key */
#endif
#ifndef KEY_REPLACE  
#define KEY_REPLACE     0x174             /* replace key */
#endif
#ifndef KEY_RESTART  
#define KEY_RESTART     0x175             /* restart key */
#endif
#ifndef KEY_RESUME   
#define KEY_RESUME      0x176             /* resume key */
#endif
#ifndef KEY_SAVE     
#define KEY_SAVE        0x177             /* save key */
#endif
#ifndef KEY_SBEG     
#define KEY_SBEG        0x178             /* shifted beginning key */
#endif
#ifndef KEY_SCANCEL  
#define KEY_SCANCEL     0x179             /* shifted cancel key */
#endif
#ifndef KEY_SCOMMAND 
#define KEY_SCOMMAND    0x17a             /* shifted command key */
#endif
#ifndef KEY_SCOPY    
#define KEY_SCOPY       0x17b             /* shifted copy key */
#endif
#ifndef KEY_SCREATE  
#define KEY_SCREATE     0x17c             /* shifted create key */
#endif
#ifndef KEY_SDC      
#define KEY_SDC         0x17d             /* shifted delete char key */
#endif
#ifndef KEY_SDL      
#define KEY_SDL         0x17e             /* shifted delete line key */
#endif
#ifndef KEY_SELECT   
#define KEY_SELECT      0x17f             /* select key */
#endif
#ifndef KEY_SEND     
#define KEY_SEND        0x180             /* shifted end key */
#endif
#ifndef KEY_SEOL     
#define KEY_SEOL        0x181             /* shifted clear line key */
#endif
#ifndef KEY_SEXIT    
#define KEY_SEXIT       0x182             /* shifted exit key */
#endif
#ifndef KEY_SFIND    
#define KEY_SFIND       0x183             /* shifted find key */
#endif
#ifndef KEY_SHOME    
#define KEY_SHOME       0x184             /* shifted home key */
#endif
#ifndef KEY_SIC      
#define KEY_SIC         0x185             /* shifted input key */
#endif
#ifndef KEY_SLEFT    
#define KEY_SLEFT       0x187             /* shifted left arrow key */
#endif
#ifndef KEY_SMESSAGE 
#define KEY_SMESSAGE    0x188             /* shifted message key */
#endif
#ifndef KEY_SMOVE    
#define KEY_SMOVE       0x189             /* shifted move key */
#endif
#ifndef KEY_SNEXT    
#define KEY_SNEXT       0x18a             /* shifted next key */
#endif
#ifndef KEY_SOPTIONS 
#define KEY_SOPTIONS    0x18b             /* shifted options key */
#endif
#ifndef KEY_SPREVIOUS
#define KEY_SPREVIOUS   0x18c             /* shifted prev key */
#endif
#ifndef KEY_SPRINT   
#define KEY_SPRINT      0x18d             /* shifted print key */
#endif
#ifndef KEY_SREDO    
#define KEY_SREDO       0x18e             /* shifted redo key */
#endif
#ifndef KEY_SREPLACE 
#define KEY_SREPLACE    0x18f             /* shifted replace key */
#endif
#ifndef KEY_SRIGHT   
#define KEY_SRIGHT      0x190             /* shifted right arrow */
#endif
#ifndef KEY_SRSUME   
#define KEY_SRSUME      0x191             /* shifted resume key */
#endif
#ifndef KEY_SSAVE    
#define KEY_SSAVE       0x192             /* shifted save key */
#endif
#ifndef KEY_SSUSPEND 
#define KEY_SSUSPEND    0x193             /* shifted suspend key */
#endif
#ifndef KEY_SUNDO    
#define KEY_SUNDO       0x194             /* shifted undo key */
#endif
#ifndef KEY_SUSPEND  
#define KEY_SUSPEND     0x195             /* suspend key */
#endif
#ifndef KEY_UNDO     
#define KEY_UNDO        0x196             /* undo key */
#endif
#ifndef KEY_A1       
#define KEY_A1          0x197             /* Upper left of keypad */
#endif
#ifndef KEY_A3       
#define KEY_A3          0x198             /* Upper right of keypad */
#endif
#ifndef KEY_B2       
#define KEY_B2          0x199             /* Center of keypad */
#endif
#ifndef KEY_C1       
#define KEY_C1          0x19a             /* Lower left of keypad */
#endif
#ifndef KEY_C3       
#define KEY_C3          0x19b             /* Lower right of keypad */
#endif
#ifndef KEY_MAX      
#define KEY_MAX         0xfff             /* Maximum curses key */
#endif

#if !defined(DOS) && !defined(OS2)

/* vt220 special keys */

#define KEY_F1         KEY_F(1)
#define KEY_F2         KEY_F(2)
#define KEY_F3         KEY_F(3)
#define KEY_F4         KEY_F(4)
#define KEY_F5         KEY_F(5)
#define KEY_F6         KEY_F(6)
#define KEY_F7         KEY_F(7)
#define KEY_F8         KEY_F(8)
#define KEY_F9         KEY_F(9)
#define KEY_F10        KEY_F(10)
#define KEY_F11        KEY_F(11)
#define KEY_F12        KEY_F(12)
#define KEY_F13        KEY_F(13)
#define KEY_F14        KEY_F(14)
#define KEY_F15        KEY_F(15)
#define KEY_Help       KEY_F(15)
#define KEY_F16        KEY_F(16)
#define KEY_Do         KEY_F(16)
#define KEY_F17        KEY_F(17)
#define KEY_F18        KEY_F(18)
#define KEY_F19        KEY_F(19)
#define KEY_F20        KEY_F(20)
#ifndef KEY_SF1
# define KEY_SF1       KEY_F(21)
#endif
#ifndef KEY_SF2
# define KEY_SF2       KEY_F(22)
#endif
#ifndef KEY_SF3
# define KEY_SF3       KEY_F(23)
#endif
#ifndef KEY_SF4
# define KEY_SF4       KEY_F(24)
#endif
#ifndef KEY_SF5
# define KEY_SF5       KEY_F(25)
#endif
#ifndef KEY_SF6
# define KEY_SF6       KEY_F(26)
#endif
#ifndef KEY_SF7
# define KEY_SF7       KEY_F(27)
#endif
#ifndef KEY_SF8
# define KEY_SF8       KEY_F(28)
#endif
#ifndef KEY_SF9
# define KEY_SF9       KEY_F(29)
#endif
#ifndef KEY_SF10
# define KEY_SF10      KEY_F(30)
#endif
#define KEY_SF11       KEY_F(31)
#define KEY_SF12       KEY_F(32)
#define KEY_SF13       KEY_F(33)
#define KEY_SF14       KEY_F(34)
#define KEY_SF15       KEY_F(35)
#define KEY_SHelp      KEY_F(35)
#define KEY_SF16       KEY_F(36)
#define KEY_SDo        KEY_F(36)
#define KEY_SF17       KEY_F(37)
#define KEY_SF18       KEY_F(38)
#define KEY_SF19       KEY_F(39)
#define KEY_SF20       KEY_F(40)
#define KEY_CF1        KEY_F(41)
#define KEY_CF2        KEY_F(42)
#define KEY_CF3        KEY_F(43)
#define KEY_CF4        KEY_F(44)
#define KEY_CF5        KEY_F(45)
#define KEY_CF6        KEY_F(46)
#define KEY_CF7        KEY_F(47)
#define KEY_CF8        KEY_F(48)
#define KEY_CF9        KEY_F(49)
#define KEY_CF10       KEY_F(50)
#define KEY_CF11       KEY_F(51)
#define KEY_CF12       KEY_F(52)
#define KEY_CF13       KEY_F(53)
#define KEY_CF14       KEY_F(54)
#define KEY_CF15       KEY_F(55)
#define KEY_CHelp      KEY_F(55)
#define KEY_CF16       KEY_F(56)
#define KEY_CDo        KEY_F(56)
#define KEY_CF17       KEY_F(57)
#define KEY_CF18       KEY_F(58)
#define KEY_CF19       KEY_F(59)
#define KEY_CF20       KEY_F(60)
#define KEY_PF1        0631
#define KEY_PF2        0632
#define KEY_PF3        0633
#define KEY_PF4        0634
#define KEY_PadComma   0635
#define KEY_PadMinus   0636
#define KEY_PadPeriod  0637
#define KEY_Pad0       0641
#define KEY_Pad1       0642
#define KEY_Pad2       0643
#define KEY_Pad3       0644
#define KEY_Pad4       0645
#define KEY_Pad5       0646
#define KEY_Pad6       0647
#define KEY_Pad7       0650
#define KEY_Pad8       0651
#define KEY_Pad9       0652
#define KEY_PadEnter   0653
#define KEY_BackTab    0654
#define KEY_Find       KEY_FIND
#define KEY_InsertHere KEY_IC
#define KEY_Remove     KEY_REPLACE
#define KEY_Select     KEY_SELECT
#define KEY_PrevScreen KEY_PPAGE
#define KEY_PrevScrn   KEY_PPAGE
#define KEY_NextScreen KEY_NPAGE
#define KEY_NextScrn   KEY_NPAGE
#define KEY_CLEFT      0655
#define KEY_CRIGHT     0656
#define KEY_CUP        0657
#define KEY_CDOWN      0660
#define KEY_CHOME      0661
#define KEY_CEND       0662
#define KEY_CPGUP      0663
#define KEY_CPGDN      0664

/* ascii control codes */
/*
#define ControlA       001
#define ControlB       002
#define ControlC       003
#define ControlD       004
#define ControlE       005
#define ControlF       006
#define ControlG       007
#define ControlH       010
#define BackSpace      010
#define ControlI       011
#define Tab            011
#define ControlJ       012
#define LineFeed       012
#define ControlK       013
#define ControlL       014
#define ControlM       015
#define Return         015
#define ControlN       016
#define ControlO       017
#define ControlP       020
#define ControlQ       021
#define ControlR       022
#define ControlS       023
#define ControlT       024
#define ControlU       025
#define ControlV       026
#define ControlW       027
#define ControlX       030
#define ControlY       031
#define ControlZ       032
*/
#define Escape         033
#define Del            0177
#define CSI            0233
#endif

#if defined(DOS) || defined(OS2)
/* normal characters */
#define KEY_a      0x61
#define KEY_b      0x62
#define KEY_c      0x63
#define KEY_d      0x64
#define KEY_e      0x65
#define KEY_f      0x66
#define KEY_g      0x67
#define KEY_h      0x68
#define KEY_i      0x69
#define KEY_j      0x6a
#define KEY_k      0x6b
#define KEY_l      0x6c
#define KEY_m      0x6d
#define KEY_n      0x6e
#define KEY_o      0x6f
#define KEY_p      0x70
#define KEY_q      0x71
#define KEY_r      0x72
#define KEY_s      0x73
#define KEY_t      0x74
#define KEY_u      0x75
#define KEY_v      0x76
#define KEY_w      0x77
#define KEY_x      0x78
#define KEY_y      0x79
#define KEY_z      0x7a
#define KEY_0      0x30
#define KEY_1      0x31
#define KEY_2      0x32
#define KEY_3      0x33
#define KEY_4      0x34
#define KEY_5      0x35
#define KEY_6      0x36
#define KEY_7      0x37
#define KEY_8      0x38
#define KEY_9      0x39
#define KEY_BQUOTE      0x60
#define KEY_MINUS      0x2d
#define KEY_EQUAL      0x3d
#define KEY_LBRACKET      0x5b
#define KEY_RBRACKET      0x5d
#define KEY_BSLASH      0x5c
#define KEY_SEMICOLON      0x3b
#define KEY_FQUOTE      0x27
#define KEY_COMMA      0x2c
#define KEY_STOP      0x2e
#define KEY_FSLASH      0x2f
#define KEY_SPACE      0x20
#define KEY_RETURN     0xd
#define KEY_TAB      0x9
#define KEY_ESC      0x1b
#define KEY_BKSP      0x8
#define KEY_F1      KEY_F(1)
#define KEY_F2      KEY_F(2)
#define KEY_F3      KEY_F(3)
#define KEY_F4      KEY_F(4)
#define KEY_F5      KEY_F(5)
#define KEY_F6      KEY_F(6)
#define KEY_F7      KEY_F(7)
#define KEY_F8      KEY_F(8)
#define KEY_F9      KEY_F(9)
#define KEY_F10     KEY_F(10)
#define KEY_F11     KEY_F(41)
#define KEY_F12     KEY_F(42)
#define KEY_PGUP      KEY_PPAGE
#define KEY_PGDN      KEY_NPAGE
#define KEY_CURU      KEY_UP
#define KEY_CURD      KEY_DOWN
#define KEY_CURL      KEY_LEFT
#define KEY_CURR      KEY_RIGHT
#define KEY_INS      KEY_IC
#define KEY_DEL      KEY_DC
#define KEY_NUMCENTER      KEY_B2
#define KEY_NUMPLUS        PADPLUS
#define KEY_NUMMINUS       PADMINUS
#define KEY_NUMSLASH       PADSLASH
#define KEY_NUMSTAR        PADSTAR
#define KEY_NUMENTER       PADENTER
/* shifted characters */
#define KEY_S_a      0x41
#define KEY_S_b      0x42
#define KEY_S_c      0x43
#define KEY_S_d      0x44
#define KEY_S_e      0x45
#define KEY_S_f      0x46
#define KEY_S_g      0x47
#define KEY_S_h      0x48
#define KEY_S_i      0x49
#define KEY_S_j      0x4a
#define KEY_S_k      0x4b
#define KEY_S_l      0x4c
#define KEY_S_m      0x4d
#define KEY_S_n      0x4e
#define KEY_S_o      0x4f
#define KEY_S_p      0x50
#define KEY_S_q      0x51
#define KEY_S_r      0x52
#define KEY_S_s      0x53
#define KEY_S_t      0x54
#define KEY_S_u      0x55
#define KEY_S_v      0x56
#define KEY_S_w      0x57
#define KEY_S_x      0x58
#define KEY_S_y      0x59
#define KEY_S_z      0x5a
#define KEY_S_0      0x29
#define KEY_S_1      0x21
#define KEY_S_2      0x40
#define KEY_S_3      0x23
#define KEY_S_4      0x24
#define KEY_S_5      0x25
#define KEY_S_6      0x5e
#define KEY_S_7      0x26
#define KEY_S_8      0x2a
#define KEY_S_9      0x28
#define KEY_S_BQUOTE      0x7e
#define KEY_S_MINUS      0x5f
#define KEY_S_EQUAL      0x2b
#define KEY_S_LBRACKET      0x7b
#define KEY_S_RBRACKET      0x7d
#define KEY_S_BSLASH      0x7c
#define KEY_S_SEMICOLON      0x3a
#define KEY_S_FQUOTE      0x22
#define KEY_S_COMMA      0x3c
#define KEY_S_STOP      0x3e
#define KEY_S_FSLASH      0x3f
#define KEY_S_TAB     KEY_BACKTAB
#define KEY_S_F1      KEY_F(11)
#define KEY_S_F2      KEY_F(12)
#define KEY_S_F3      KEY_F(13)
#define KEY_S_F4      KEY_F(14)
#define KEY_S_F5      KEY_F(15)
#define KEY_S_F6      KEY_F(16)
#define KEY_S_F7      KEY_F(17)
#define KEY_S_F8      KEY_F(18)
#define KEY_S_F9      KEY_F(19)
#define KEY_S_F10     KEY_F(20)
#define KEY_S_F11     KEY_F(43)
#define KEY_S_F12     KEY_F(44)
#define KEY_S_HOME    KEY_HOME
#define KEY_S_PGUP    KEY_PGUP
#define KEY_S_PGDN    KEY_PGDN
#define KEY_S_CURU    KEY_CURU
#define KEY_S_CURD    KEY_CURD
#define KEY_S_CURL    KEY_CURL
#define KEY_S_CURR    KEY_CURR
#define KEY_S_END     KEY_END
#define KEY_S_INS     KEY_INS
#define KEY_S_DEL     KEY_DEL
#define KEY_S_NUM0     0x30
#define KEY_S_NUM1     0x31
#define KEY_S_NUM2     0x32
#define KEY_S_NUM3     0x33
#define KEY_S_NUM4     0x34
#define KEY_S_NUM5     0x35
#define KEY_S_NUM6     0x36
#define KEY_S_NUM7     0x37
#define KEY_S_NUM8     0x38
#define KEY_S_NUM9     0x39
#define KEY_S_NUMSTOP  SHF_PADSTOP
#define KEY_S_NUMCENTER  KEY_5
/* control characters */
/* Control-A to Control-Z at end */
#define KEY_C_2      0x0
#define KEY_C_6      0x1e
#define KEY_C_MINUS      0x1f
#define KEY_C_LBRACKET      0x1b
#define KEY_C_RBRACKET      0x1d
#define KEY_C_BSLASH      0x1c
#define KEY_C_ENTER   CTL_ENTER
#define KEY_C_TAB     CTL_TAB
#define KEY_C_BKSP    CTL_BKSP
#define KEY_C_F1      KEY_F(21)
#define KEY_C_F2      KEY_F(22)
#define KEY_C_F3      KEY_F(23)
#define KEY_C_F4      KEY_F(24)
#define KEY_C_F5      KEY_F(25)
#define KEY_C_F6      KEY_F(26)
#define KEY_C_F7      KEY_F(27)
#define KEY_C_F8      KEY_F(28)
#define KEY_C_F9      KEY_F(29)
#define KEY_C_F10     KEY_F(30)
#define KEY_C_F11     KEY_F(45)
#define KEY_C_F12     KEY_F(46)
#define KEY_C_HOME    CTL_HOME
#define KEY_C_PGUP    CTL_PGUP
#define KEY_C_PGDN    CTL_PGDN
#define KEY_C_CURU    CTL_UP
#define KEY_C_CURD    CTL_DOWN
#define KEY_C_CURL    CTL_LEFT
#define KEY_C_CURR    CTL_RIGHT
#define KEY_C_END     CTL_END
#define KEY_C_INS     CTL_INS
#define KEY_C_DEL     CTL_DEL
#define KEY_C_NUM0    CTL_INS
#define KEY_C_NUM1    CTL_END
#define KEY_C_NUM2    CTL_DOWN
#define KEY_C_NUM3    CTL_PGDN
#define KEY_C_NUM4    CTL_LEFT
#define KEY_C_NUM5    CTL_PADCENTER
#define KEY_C_NUM6    CTL_RIGHT
#define KEY_C_NUM7    CTL_HOME
#define KEY_C_NUM8    CTL_UP
#define KEY_C_NUM9    CTL_PGUP
#define KEY_C_NUMSTOP  CTL_PADSTOP
#define KEY_C_NUMCENTER  CTL_PADCENTER
#define KEY_C_NUMPLUS    CTL_PADPLUS
#define KEY_C_NUMMINUS   CTL_PADMINUS
#define KEY_C_NUMSLASH   CTL_PADSLASH
#define KEY_C_NUMSTAR    CTL_PADSTAR
#define KEY_C_NUMENTER   CTL_PADENTER
/* alt characters */
#define KEY_A_a      ALT_A
#define KEY_A_b      ALT_B
#define KEY_A_c      ALT_C
#define KEY_A_d      ALT_D
#define KEY_A_e      ALT_E
#define KEY_A_f      ALT_F
#define KEY_A_g      ALT_G
#define KEY_A_h      ALT_H
#define KEY_A_i      ALT_I
#define KEY_A_j      ALT_J
#define KEY_A_k      ALT_K
#define KEY_A_l      ALT_L
#define KEY_A_m      ALT_M
#define KEY_A_n      ALT_N
#define KEY_A_o      ALT_O
#define KEY_A_p      ALT_P
#define KEY_A_q      ALT_Q
#define KEY_A_r      ALT_R
#define KEY_A_s      ALT_S
#define KEY_A_t      ALT_T
#define KEY_A_u      ALT_U
#define KEY_A_v      ALT_V
#define KEY_A_w      ALT_W
#define KEY_A_x      ALT_X
#define KEY_A_y      ALT_Y
#define KEY_A_z      ALT_Z
#define KEY_A_0      ALT_0
#define KEY_A_1      ALT_1
#define KEY_A_2      ALT_2
#define KEY_A_3      ALT_3
#define KEY_A_4      ALT_4
#define KEY_A_5      ALT_5
#define KEY_A_6      ALT_6
#define KEY_A_7      ALT_7
#define KEY_A_8      ALT_8
#define KEY_A_9      ALT_9
#define KEY_A_BQUOTE      ALT_BQUOTE
#define KEY_A_MINUS       ALT_MINUS
#define KEY_A_EQUAL       ALT_EQUAL
#define KEY_A_LBRACKET    ALT_LBRACKET
#define KEY_A_RBRACKET    ALT_RBRACKET
#define KEY_A_BSLASH      ALT_BSLASH
#define KEY_A_SEMICOLON   ALT_SEMICOLON
#define KEY_A_FQUOTE      ALT_FQUOTE
#define KEY_A_COMMA       ALT_COMMA
#define KEY_A_STOP        ALT_STOP
#define KEY_A_FSLASH      ALT_FSLASH
#define KEY_A_ENTER       ALT_ENTER
#define KEY_A_TAB         ALT_TAB
#define KEY_A_ESC         ALT_ESC
#define KEY_A_BKSP        ALT_BKSP
#define KEY_A_F1      KEY_F(31)
#define KEY_A_F2      KEY_F(32)
#define KEY_A_F3      KEY_F(33)
#define KEY_A_F4      KEY_F(34)
#define KEY_A_F5      KEY_F(35)
#define KEY_A_F6      KEY_F(36)
#define KEY_A_F7      KEY_F(37)
#define KEY_A_F8      KEY_F(38)
#define KEY_A_F9      KEY_F(39)
#define KEY_A_F10     KEY_F(40)
#define KEY_A_F11     KEY_F(47)
#define KEY_A_F12     KEY_F(48)
#define KEY_A_HOME    ALT_HOME
#define KEY_A_PGUP    ALT_PGUP
#define KEY_A_PGDN    ALT_PGDN
#define KEY_A_CURU    ALT_UP
#define KEY_A_CURD    ALT_DOWN
#define KEY_A_CURL    ALT_LEFT
#define KEY_A_CURR    ALT_RIGHT
#define KEY_A_END     ALT_END
#define KEY_A_INS     ALT_INS
#define KEY_A_DEL     ALT_DEL
#define KEY_A_NUMPLUS ALT_PADPLUS
#define KEY_A_NUMMINUS ALT_PADMINUS
#define KEY_A_NUMSLASH ALT_PADSLASH
#define KEY_A_NUMSTAR      ALT_PADSTAR
#define KEY_A_NUMENTER     ALT_PADENTER
#endif

/* special definition for UNIX systems */
#ifndef KEY_RETURN
#define KEY_RETURN 0xd
#endif

#define KEY_C_a      0x1
#define KEY_C_b      0x2
#define KEY_C_c      0x3
#define KEY_C_d      0x4
#define KEY_C_e      0x5
#define KEY_C_f      0x6
#define KEY_C_g      0x7
#define KEY_C_h      0x8
#define KEY_C_i      0x9
#define KEY_C_j      0xa
#define KEY_C_k      0xb
#define KEY_C_l      0xc
#define KEY_C_m      0xd
#define KEY_C_n      0xe
#define KEY_C_o      0xf
#define KEY_C_p      0x10
#define KEY_C_q      0x11
#define KEY_C_r      0x12
#define KEY_C_s      0x13
#define KEY_C_t      0x14
#define KEY_C_u      0x15
#define KEY_C_v      0x16
#define KEY_C_w      0x17
#define KEY_C_x      0x18
#define KEY_C_y      0x19
#define KEY_C_z      0x1a
