/***********************************************************************/
/* NOREXX.C - Dummy REXX interface routines.                           */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1995 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Id: norexx.c 2.0 1995/01/26 16:31:30 MH Release MH $
*/

#if defined(PROTO) && defined(NOREXX)
#  define INCL_RXSUBCOM       /* Subcommand handler values */
#  define INCL_RXSHV          /* Shared variable support */
#  define INCL_RXSYSEXIT      /* System exit routines */
#  define INCL_DOSPROCESS     /* Process/Thread Info */
#  define INCL_RXFUNC         /* External functions */

#include "the.h"
#include "rexx.h"


/***********************************************************************/
ULONG RexxRegisterExitExe( PSZ EnvName, PFN EntryPoint, PUCHAR UserArea )
/***********************************************************************/
{
 return(RXEXIT_OK);
}
/***********************************************************************/
int RexxDeregisterExit( PSZ EnvName, PSZ ModuleName )
/***********************************************************************/
{
 return(RXEXIT_OK);
}
/***********************************************************************/
ULONG RexxRegisterSubcomExe( PSZ EnvName, PFN EntryPoint, PUCHAR UserArea )
/***********************************************************************/
{
 return(RXSUBCOM_LOADERR);                           /* force an error */
}
/***********************************************************************/
ULONG RexxDeregisterSubcom( PSZ EnvName, PSZ ModuleName )
/***********************************************************************/
{
 return(RXSUBCOM_OK);
}
/***********************************************************************/
ULONG RexxRegisterFunctionExe( PSZ name, PFN EntryPoint )
/***********************************************************************/
{
 return(RXFUNC_OK);
}
/***********************************************************************/
ULONG RexxDeregisterFunction( PSZ name )
/***********************************************************************/
{
 return(RXFUNC_OK);
}
/***********************************************************************/
LONG RexxStart( LONG ArgCount, PRXSTRING ArgList, PSZ ProgramName,
                PRXSTRING Instore, PSZ EnvName, LONG CallType,
                PRXSYSEXIT Exits, PLONG ReturnCode, PRXSTRING Result )
/***********************************************************************/
{
 return(RX_START_OK);
}
/***********************************************************************/
ULONG RexxVariablePool( PSHVBLOCK RequestBlockList )
/***********************************************************************/
{
 return(RXSHV_OK);
}
# if defined(MSWIN)
/***********************************************************************/
int APIENTRY RexxThread( UINT task, int action )
/***********************************************************************/
{
 return(THREAD_NOT_REGISTERED);                      /* force an error */
}
# endif
#endif
