/*
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   This program illustrates the use of TRAN.  The program generates 10,000
variates from the uniform and beta densities and then presents the mean and
variance of the sample.
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/

#include <stdio.h>
#include <tran.h>

typedef unsigned int uint;
typedef unsigned long ulong;

ulong __far *timer = (ulong __far *)0x46c;    //Pointer to timer tick

void main(void)
{
  ulong i, n;
  double x, mean, var;

  n = 10000;               //n = sample size

  setseed(*timer);         //Use timer tick as seed for random numbers

  mean = 0.0;              //Compute mean and variance of uniform
  var = 0.0;
  for(i = 0; i < n; i++)
  {
    x = rndu();
    mean = mean + x;
    x = x - 0.5;
    var = var + x * x;
  }
  mean = mean / n;
  var = var / n;

  printf("Uniform Sample Mean:       %10.5f\nUniform Sample Variance:   %10.5f\n\n", mean, var);

  parm_beta(2.0, 2.0);     //Parameterize beta generator with a = 2, b = 2

  mean = 0.0;              //Compute mean and variance of beta
  var = 0.0;
  for(i = 0; i < n; i++)
  {
    x = rnd_beta();
    mean = mean + x;
    x = x - 0.5;
    var = var + x * x;
  }
  mean = mean / n;
  var = var / n;

  printf("Beta(2,2) Sample Mean:     %10.5f\nBeta(2,2) Sample Variance: %10.5f\n\n", mean, var);

}
