/*
 *	unix2dos.c -- 
 *
 *	converts unix text files to MS-DOS text files...
 *
 *	that means:	\n converted to \r\n
 *			^z added at EOF
 *
 *	USAGE:	unix2dos <filename>  ... if <filename> is not specified,
 *	unix2dos reads from stdin.  In either case, all output is directed
 *	to stdout.
 *
 *	If the first \n encountered is part of a \r\n pair, unix2dos assumes
 *	that the file is already in DOS format, and just "cats" the thing out.
 *
 *ver	user	date		comments
 *1.00	cbo	03/06/90	first draft
 */

# include <stdio.h>
#define NAME "unix2dos"
static void	err_report();		/* error reporting function */
static FILE	*Fpi;			/* input file pointer */

main(argc, argv)
int	argc;
char	**argv;
{
	register int data = 0;
	register int lastdata = 0;
	register int already_dos = 0;

	/* open input file */
	switch (argc) {
	case 1: 
		{
			Fpi = stdin;
			break;
		}
	case 2: 
		{
			if ((Fpi = fopen(*++argv, "r")) == NULL)
				err_report(1);
			break;
		}
	default: 
		err_report(0);		/* usage */
	}

	while ( ! feof(Fpi)) {
		lastdata = data;
		data = fgetc(Fpi);
		if (data == EOF) break;		/* screen out nasty EOF */
		if (! already_dos) {
			if (data == '\n') {
				if (lastdata != '\015')		/* a CR */
					(void) fputc('\015',stdout);
				else
					++already_dos;
			}
		}
		(void) fputc(data,stdout);
	}

	if ( ! already_dos)
		(void) fputc('\026',stdout);		/* a control-Z */

	(void) fclose(Fpi);
	exit(0);
}


static void err_report(n)
int	n;
{
	switch (n)  {
	case 0: 
		(void) fprintf(stderr,"Usage: %s <file> \n",NAME);
		break;
	case 1: 
		(void) fprintf(stderr,"%s: Unable to open input file.\n",NAME);
		break;
	}

	exit(1);
}

/* EOF */
