page	, 128
.286
;---------------------------------------------------------------------
; L H A L I B . L I B
; Library to be used in Microsoft windows Programs
; makes it possible to extract LHA-Archives.
;
; (C) Bernd Herd / Heidelberger Landstr. 316 / 64297 Darmstadt
;     Tel u. Fax 0049-6151/591216 FIDO 2:244/7202.10
;
; Version 1.1 with temporary Data Segment
; Version 1.2 fixed problem with Files containing attributes
; Version 1.3 Allows for Extraction of a given File-Handle and Position
;	      by using MAKEINTRESOURCE( hFile ) as the Archiv Filename
; Version 1.4 Added UserParam-Field in call to LHAExpand
;---------------------------------------------------------------------
; Usage:
; int FAR PASCAL LHAExpand(const char far *ArchivName, const char far *FileName, int Options,
;			   FARPROC PeekProc, DWORD UserData)
;
; with:
; ArchivName : FileName of LHA-Archivfile. Extension is recommended.
; DestPath   : Directory Pathname for Destination File
; PeekProc   : Application-supplied callback-Routine to enable Multitasking
;
; Options may be:
; LHA_OVERWRITE		Overwrite existing Files without warning
; LHA_ATTRIB		Set File attributes
;
include c:\borlandc\include\windows.inc

;------------- Stack usage ---------------------
; BP+16 4 char *  ArchivNAme
; BP+12 4 char *  DestPath
; BP+10 2 int     Options
; BP+6  4 FARPROC PeekProc
; BP+2	4 	  return  Adress
; BP+0	2 	  old BP  Value
; 14 Bytes for Parameters at all

;------------- Windows Procedures used ---------
extrn	PASCAL _LOPEN    : far
extrn   PASCAL _LREAD    : far
extrn	PASCAL _LWRITE   : far
extrn   PASCAL _LCLOSE   : far
extrn	PASCAL _LLSEEK   : far
extrn	PASCAL OPENFILE  : far
extrn   PASCAL MESSAGEBOX: far
extrn   PASCAL GETFOCUS  : far
extrn   PASCAL LSTRCPY   : far
extrn   PASCAL LSTRCAT   : far

extrn   PASCAL GLOBALUNLOCK : far
extrn   PASCAL GLOBALFREE   : far
extrn   PASCAL GLOBALALLOC  : far
extrn   PASCAL GLOBALLOCK   : far
extrn   PASCAL GLOBALHANDLE : far

;------------- Codes for Options-Parameter -----
LHA_OVERWRITE		= 0001H		; Do not Ask before overwriting File
LHA_ATTRIB		= 0010H		; Set File Attributes

;------------- Error Codes ---------------------
; The Errorcode are selected to be between 2000 and 2100, so it's easyer
; to store the error text in an Resource File
LHAE_ARCHIVNOTFOUND	= 2020		; Archiv File not Found
LHAE_BROKEN		= 2021		; Broken Archiv
LHAE_METHOD		= 2022		; Compression Method not supported
LHAE_WRITE		= 2023		; Error creating/writing File
LHAE_CRC		= 2024		; CRC error
LHAE_CALLBACK		= 2025		; Callbackroutine returned LHAN_STOP
LHAE_NOTANARCHIV        = 2026		; Not an LHA-Archiv


;------------- Callback-Notification-Codes -----
LHAN_OK			= 0		; Nothing special
LHAN_IGNOREFILE		= 1		; Used with LHAM_NEXTFILE : Irgnore this File
LHAN_STOP		= 2		; Used with LHAM_PEEK     : Stop Decompression of Archive immediatly

;------------- Callback Messages ---------------
LHAM_PEEK		= 1		; Nothing special
LHAM_NEXTFILE		= 2		; Start processing next File

;------------- _llseek-Flags -------------------
SEEK_SET		= 0
SEEK_CUR		= 1
SEEK_END		= 2

_TEXT	segment byte public 'CODE'
_TEXT	ends

;_BSS	group	_BSS
		assume	cs:_TEXT, ds:Nothing

CRC16			equ		0a001h
BufSiz			equ		04000h

NC			=		(200h - 2)
NP			=		14
NT			=		19
NPT			=		080h

CBIT		=		9
PBIT		=		4
TBIT		=		5

DSIZ		=		2000h
DSIZ2		=		DSIZ * 2

LzHead	struc
		HeadSiz  db		?
		HeadChk  db		?
		HeadID	 db		3 dup (?)
		Method	 db		?
			 db		?
		PacSiz	 dd		?
		OrgSiz	 dw		2 dup (?)
		FTime	 dw		?
		FDate	 dw		?
		FAttr	 dw		?
		FnLen	 db		?
		Fname	 db		80h dup (?)
		FileSize dw		2 dup (?)		; File Size when Ready
		UserData dd		?			; Last Parameter from LHAExpand
		ArcSize  dd		?			; Size of Archiv-File
                ArcRead  dd		?			; Current Position in Archiv-File
LzHead	ends

;_BSS	segment public
_BSS	segment at 0h

text_			db		DSIZ2 dup (?)
inpbuf			db		BufSiz dup (?)
crctbl			dw		100h dup (?)
cpyhdr			LzHead	1 dup (<?>)
FullName		db		100h dup (?)		; Full Pathname of dest. File
dummy			OpenStruc ?
inpptr			dw		1 dup (?)
infile			dw		1 dup (?)		; File Handle of input File
outfile			dw		1 dup (?)
orgcrc			dw		1 dup (?)
curcrc			dw		1 dup (?)
blocksize_		dw		1 dup (?)

len_cnt			dw		17 dup (?)
start			dw		17 dup (?)
weight			dw		17 dup (?)

cmethod			db		?			; Compression Method
PeekP			dd		?			; Callback-Procedure of Application
PeekDS			dw		?			; Data Segment of Application
PeekResult		dw		?			; Result of Callback-Routine

attrlen			dw 		?			; Attribute Header Size

public	len_cnt
public	start
public	weight


left_			dw		2 * NC - 1 dup (?)
right_			dw		2 * NC - 1 dup (?)

c_table_		dw		4096 dup (?)
pt_table_		dw		256 dup (?)
c_len_			db		NC dup (?)
pt_len_			db		NPT dup (?)

public	left_
public	right_
public	c_table_
public	pt_table_
public	c_len_
public	pt_len_

bitbuf_			dw		1 dup (?)
subbitbuf_		db		1 dup (?)
bitcount_		db		1 dup (?)

myname			db		80h dup (?)
fnnext			dw		1 dup (?)
fnptr			dw		1 dup (?)
swchar			db		1 dup (?)

_BSS			ends

_TEXT	segment byte public 'CODE'

		assume	cs:_TEXT

;PeekProc   equ DWORD PTR ss:[BP+6]
;Options    equ  WORD PTR ss:[BP+8]
;DestPath   equ DWORD PTR ss:[BP+12]
;ArchivName equ DWORD PTR ss:[BP+16]

OverWtText	db "Diese Datei existiert bereits. Soll sie ueberschrieben werden", 0
broken		db 'Archiv zerstoert ', 0

		public LHAEXPAND

LHAExpand	Proc Pascal Far
		arg ArchivName : DWord, DestPath : DWord, Options : Word, PeekProc : DWord, UserDat : DWord 

		cld			; Clear Direction Flag once
 ;		Push Bp			; Save old BP-Value
 ;		Mov  Bp,Sp              ; Make Procedure Parameters Adressable

		Push Ds			; Save other Registers
		Push Si
		Push Di
		Push Bx

		Push Ds			; Store Applications Data Segment

;		Mov Ax, _BSS		; We like to use our own Data-Segment
;		Mov Ds, Ax

		call GlobalAlloc PASCAL , GHND , 0 offset EndBss
		call GlobalLock  PASCAL , AX
		Mov  Ds, Dx
		Assume Ds:_Bss

		Pop Bx			; Save applications Data Segmenz -> BX
		Mov PeekDS, Bx		; Application's Data Segment
		LEs Ax, PeekProc	; Store Applications Callback Routine
		Mov Word Ptr PeekP,Ax
		Mov Word Ptr PeekP+2,Es

		Mov Ax, Word Ptr UserDat
		Mov Word Ptr CpyHdr.UserData  , Ax
		Mov Ax, Word Ptr UserDat+2
		Mov Word Ptr CpyHdr.UserData+2, Ax

		Call OpenInput		; Try to open Input File
		Jc ReturnError		; -> Input File not found

		Call GetHeader		; Read Archiv Header
		Jc ReturnError		; -> Broken File

		Call MakeCRC		; Prepare CRC-Table

FilesLoop:		Call GetFHeader		; Read in File Header
			Jc ReturnError
			Je EndArchiv		; -> End of Archiv reached

			Call Extract		; Extract File Data
			Jc ReturnError

		Jmp short FilesLoop	; -> MainLoop, next File

;------ Regular End of Archiv reached, No Error -----------------
EndArchiv:      Mov Ax, Word Ptr ArchivName+2	; Get HIghByte to Test for Zero
		or Ax, Ax
		je NoClose			; Version 1.3 : don't close Files automatically

		   Call _lclose PASCAL , InFile	; Close output File

   NoClose:	Xor Ax,Ax		; Return Value

;------ Jump here, if Error occured during Decompression --------
ReturnError:	Push Ax			; Save return Value

		Call GlobalHandle PASCAL , ds
		Push Ax
		Call GlobalUnlock PASCAL , Ax
		Pop Ax
		Call GlobalFree   PASCAL , Ax

		Pop Ax

		Pop Bx
		Pop Di
		Pop Si

		Pop Ds
;		Pop Bp
;		ret 14
		ret

LHAExpand	EndP


;/- OpenInput -------------------------------\
;| Try to open the Archive Input File        |
;| returns Errorcode and Carry set on Error  |
;\-------------------------------------------/
OpenInput	Proc Near

		; Version 1.3: If HIWORD of Pointer to the Filename equals zero, the LOWORD is the File-Handle itself!

		Mov Ax, Word Ptr ArchivName+2	; Get HIghByte to Test for Zero
		or Ax, Ax
		Mov Ax, Word Ptr ArchivName	; Get LoByte to use as Handle
		je UseAsHandle

    		   Xor Ax,Ax			; Mov Ax, OF_READ
;		   Call _lopen PASCAL , ArchivName, Ax
		   Call OpenFile PASCAL , ArchivName , ds offset dummy , OF_READ

   UseAsHandle:	Mov  InFile, Ax			; return File Handle

		Inc Ax
		Jne OpenInOk			; -> No Error Occured

			Stc				; Set Carry Flag
			Mov Ax,LHAE_ARCHIVNOTFOUND	; Errorcode : Archiv not found

			Ret				; Return with an Error-Code

OpenInOk:       Dec Ax
		Push Ax
		  Call _llseek PASCAL, Ax, 0 0, 2	; Seek End of File -> Get Size of File
		  Mov Word Ptr cpyhdr.ArcSize  ,Ax
		  Mov Word Ptr cpyhdr.ArcSize+2,Dx

		Pop Ax
		Call _llseek PASCAL, Ax, 0 0, 0		; Reposition to Start of File
                Clc
		Ret

OpenInput	EndP



;/- GetHeader -------------------------------\
;| Read Archive File Header                  |
;| 1. Find start of Archiv                   |
;| 2. Position File to Archiv Header         |
;\-------------------------------------------/
GetHeader	Proc near

		Call _lread PASCAL , InFile, DS offset inpbuf , BufSiz

		Mov Cx, Ax		; Count of Bytes read

		Inc Ax
		Je GetHdErr		; -> Error in _lread

;		Search for start of Archive Header, so EXE-Archives may be
;		decompressed
		mov		si, offset inpbuf

GetHdSearch:		Cmp  word ptr [si],'l-'
			Jne  GetHdNxt
			Cmp  Byte ptr [si+4],'-'
			Je   GetHdFnd

GetHdNxt:		Inc  Si
			Loop GetHdSearch
		Jmp  GetHdErr			; -> Broken Archiv Error

GetHdFnd:       ; Sub  si, (offset inpbuf + 2)
		; Call _llseek PASCAL , InFile, 0 Si , 0   ; DOS-Function: Seek in File to Position CX:DX Handle BX

		; Changed in Version 1.3: Use relative File-Adressing
		Mov Ax, -2
		Sub Ax, Cx
		Call _llseek PASCAL , InFile, -1 Ax , SEEK_CUR   ; DOS-Function: Seek in File to Relative Position CX:DX Handle BX

		Inc Ax
		Jne GetHdEnd			; -> if File is OK

GetHdErr:       Stc
		Mov Ax, LHAE_NOTANARCHIV	; Not an LHA-Archiv
;		Mov Ax, LHAE_BROKEN		; Broken Archiv

GetHdEnd:	Ret

GetHeader	EndP


;/- MakeCRC ---------------------------------\
;| Prepare CRC Table                         |
;\-------------------------------------------/
MakeCRC		Proc Near

		push		ds
		pop		es
		mov		di, offset crctbl
		xor		dx, dx
MakeCRCOuter:
			mov		ax, dx
			mov		cx, 8
MakeCRCInner:
				shr		ax, 1
				jnc		MakeCRCXor
					xor		ax, CRC16
MakeCRCXor:
			Loop MakeCrcInner

			stosw
			inc dl
		jne MakeCRCOuter

		Ret

MakeCrc		EndP


;/- GetFHeader ------------------------------\
;| Read Archive File Header                  |
;| 1. Read Header Length Byte		     |
;| 2. Read rest of File Header               |
;| 3. Test Header Checksum		     |
;\-------------------------------------------/
GetFHeader	Proc near

; Get Header ---------------------------
		call _lread PASCAL , InFile, ds offset cpyhdr.HeadSiz, 1
		Dec Al                  ; Had to read exactly one Byte
		Jne GetFEnd		; -> if error or End of File

		Mov Al, cpyhdr.HeadSiz
		Xor Ah, Ah
		Or  Al, al
		Je  GetFEnd		; -> End of File

		Inc Al
		call _lread PASCAL , InFile, ds offset cpyhdr.HeadSiz+1, ax
		Inc Ax
		Je  GetFErr		; -> if error

; Test Header Sum ----------------------
			Mov		Si, offset cpyhdr.HeadSiz
			Mov		Cl, Byte Ptr [Si]
			Xor		Ch, Ch
			Inc		Si
			LodsB					; Load Header Checksum
			Inc		Cl
;			Dec		Cl
;			Dec		Cl

			Dec		Si
TestHead:               Inc		si
			sub		al, [si]
			Loop		TestHead

			Jne		GetFErr

		Mov Ax, CpyHdr.OrgSiz		; Get Size of Original File
		Mov CpyHdr.FileSize  , Ax
		Mov Ax, CpyHdr.OrgSiz+2		; Get Size of Original File
		Mov CpyHdr.FileSize+2, Ax
		Inc Ax
		Jmp short GetFEnd

GetFErr:	Stc
		Mov Ax,LHAE_BROKEN
		Or Ax,AX

GetFEnd:	Ret

GetFHeader	EndP


;/- MakeFullName ----------------------------\
;| Combine Pathname and Filename             |
;\-------------------------------------------/
MakeFullName	Proc Near

		call lstrcpy PASCAL , ds offset FullName , DestPath
		call lstrcat PASCAL , ds offset FullName , ds offset cpyhdr.FName

		ret

MakeFullName	EndP



;/- Extract ---------------------------------\
;| Extract File from Archive                 |
;| 1. Test Header ID         		     |
;| 2. Get original CRC                       |
;| 3. Test for existing File		     |
;\-------------------------------------------/
Extract		Proc


		Mov	Si, offset CpyHdr.HeadId	; Prepare Header Adress in SI ----------

		Call	TestHeader			; Test Header
		Jc	ExtractEnd			; -> if Errornous Header or Method not supported

		Call	GetOrgCrc			; Get Original CRC

		Call MakeFullName			; Make Full Filename from PathName and Header

; Test Special File ? ------------------
;			cmp		cx, 2101h				; 01h, '!'

;			Jne		NotMn7

;				mov		ax, 1
;				jmp		StartDecode

;NotMn7:
; Display File name --------------------
;			mov		word ptr [bx], 0 * 256 + ' '
;			mov		bx, dx
;			call	disp					; output file name
;			mov		byte ptr [bx - 1], 0

;			jcxz	mn9						; !.BAT ?

; Check Existence of File --------------
			Call 		CheckOverwrite			; Test if File exists, Overwrite if neccessarry
			Je		ExtractEnd

; Overwrite ? --------------------------
;			mov		bx, offset overwt	; prompt
;			call	mesout
;			call	getyn
;			je		CreateNewFile

;mn9:
;			mov		cs:autoflg, 0dh

; Create a New File --------------------
			Call CreateTheFile			; Create New Output File
			Jc   ExtractErr				; -> if Error

;			mov		cx, 0020h
;			mov		ah, 3ch
;			int		21h					; Create a File
;			Jc		ExtractErrWrite

; Decode -------------------------------
			xor		ax, ax
			mov		curcrc, ax
			dec		ax
			mov		inpptr, ax

			push	dx
;			or bp,bp
			test cMethod, 0ffh
			Push Bp
			jz Method0

				call	decode
			Jmp	Short AfterDecode

Method0:			call	copyall		; File only stored, Copy all

AfterDecode:            pop		Bp
			pop		si
			Jc	ExtractErrWrite		; Jump if Error mark set

			Call TimeStamp			; Set File Time and Date

			Call _lclose PASCAL , OutFile	; Close output File
;			call	close

; Check CRC ----------------------------
			mov		ax, curcrc
			cmp		ax, orgcrc
			Mov		Ax, LHAE_CRC
			jne		ExtractErr

			call	setattr			; Set File attributes
			Or Al,Al			; Reset Carry
			Jmp ExtractEnd


;			jmp		mn6
;mn8:
;			call	getyn
;			jne		exit1
;mn6:
;		Jmp	MainLoop		; -> Process next File of Archive

;		mov		bx, infile	; ???????????????????
;		call	close

;		public	exit
;exit:
;		call	@autoexec

;		public	_autoexec
;_autoexec:
;exit1:
;		xor		al, al
;exit2:
;		mov		ah, 4ch
;		int		21h

ExtractErrWrite:        Push Ax			; Save Error Code
				Call _lclose  PASCAL , outfile
				Call OpenFile PASCAL , ds offset FullName , ds offset dummy , OF_DELETE
			Pop  Ax			; Retrieve Error Code
			Jmp  Short ExtractEnd
ExtractErrCreate:      	Mov Ax, LHAE_WRITE
ExtractErr:		Stc
ExtractEnd:		Ret

Extract		EndP



;/- TestHeader ------------------------------\
;| Test Header and extract ID                |
;\-------------------------------------------/
TestHeader	Proc near

		lodsw
		cmp ax, 'l-'
		Jne TestHdErr		; -> Broken File

			lodsw		; Get Compression Method
			xchg	al, ah
			sub		ax, 'h0'
			mov		cMethod, al	; Store Compression Method
			je		NoErrMth	; -> if Method is OK
			sub		ax, 4
			je		NoErrMth	; -> if Method is OK
			dec		ax
			jne		ErrMth		; -> if Method is not OK

NoErrMth:		lodsb
			sub al, '-'
			je		TestHdEnd

; Error in Header
TestHdErr:	Stc
		Mov Ax, LHAE_BROKEN
		Jmp short TestHdEnd

; Compression Method not supported -----
ErrMth:		Stc
		Mov Ax, LHAE_METHOD

TestHdEnd:	ret

TestHeader	EndP


;/- GetOrgCrc -------------------------------\
;| Get Original CRC -> ORGCRC                |
;\-------------------------------------------/
GetOrgCrc		Proc near

			Xor Ax,Ax

			mov		bx, offset cpyhdr.Fname
			mov		dx, bx
			mov		cx, [bx - 1]
			add		bl, cl				; doesn't carry up

			xchg	ax, [bx]			; ax = 0, [bx] = CRC
			mov		orgcrc, ax
			mov		fnptr, dx

;			---- 12.1.95 : Test, if attrlen-Data field is Included in the Header
			Mov    Ax, [bx+3]                       ; Get Attribute Header Size (If included!)
			Sub    Bx, offset cpyhdr.HeadSiz	; Test, if AttrHeaderSize-Field is included in the Header
			Sub    Bl, cpyhdr.HeadSiz
			Cmp    Bl, 3
			Jae    HasAttrLen			; -> Jump if Header Has in fact Attribute Length Field

			    Xor Ax,Ax

HasAttrLen:		Mov	AttrLen, Ax			; Store attribute Header Size

			Ret

GetOrgCrc		EndP

;/- CheckOverwrite --------------------------\
;| Check, if file should be Overwritten,     |
;| ask User if neccessary    		     |
;\-------------------------------------------/
CheckOverwrite		Proc near

			Mov   Ax, LHAM_NEXTFILE				; Ask Applications Callback Routine
			Call  AppCallBack
			Mov   Ax, PeekResult
			Cmp   Ax, LHAN_IGNOREFILE			; Skip This File ?
			Je    SkipThisFile				; -> if File not wanted
			Cmp   Ax, LHAN_STOP				; End Decompression immediatly
			Mov   Ax, LHAE_CALLBACK
			Stc
			Je    CheckOverEnd

			Test		Options, LHA_OVERWRITE		; If this Flag not set, ask before overwriting
			Jne		CreateNewFile			; -> Create File, do not Ask

				Call OpenFile PASCAL , ds dx , ds offset dummy , OF_EXIST
				Inc Ax					; Test File existence
				Je	CreateNewFile			; -> Create File, do not Ask

					Call OverWtMessage		; Ask User, if File should be overwritten

					je	CreateNewFile		; -> Create New FIle

SkipThisFile:				Call SkipThis			; Skip File Data
					Xor Ax, Ax			; Give Return Code
					Jmp Short CheckOverEnd

CreateNewFile:		Inc Ax

CheckOverEnd:		Ret

CheckOverwrite		EndP

;			mov		ax, 4300h				; get file attr
;			int		21h						;	(for MS-DOS 3.3)
;			jc		CreateNewFile
;			Jmp CreateNewFile


;/- OverWtMessage ---------------------------\
;| Ask User, if File should be overwritten   |
;\-------------------------------------------/
OverWtMessage		Proc near

			Call GetFocus PASCAL

			Call MessageBox PASCAL , AX , cs offset OverWtText , ds offset FullName , MB_YESNO OR MB_ICONQUESTION
			Cmp  Ax, IDYES

			Ret

OverWtMessage		EndP



;/- SkipThis --------------------------------\
;| Skip File Data to next File               |
;\-------------------------------------------/
SkipThis		Proc near

			call _llseek PASCAL , InFile , CpyHdr.PacSiz , SEEK_CUR

			Ret

;			mov		dx, cpyhdr.PacSiz		; skip file
;			mov		cx, cpyhdr.PacSiz + 2

;			mov		bx, infile
;			mov		ax, 4201h 			; seek to relative position
;			int		21h					; Move a File Pointer
;			jmp		mn6

SkipThis		EndP


;/- TimeStamp -------------------------------\
;| 1. Set output File Time and Date          |
;\-------------------------------------------/
TimeStamp		Proc Near

			mov		bx, outfile
;			cmp		bx, 1					; file '!' ?
;			je		mn8

			mov		dx, cpyhdr.FDate
			mov		cx, cpyhdr.FTime
			mov		ax, 5701h				; set date
			int		21h

			ret

TimeStamp		EndP

;/- CreateTheFile ---------------------------\
;| Create a new File and Store Handle	     |
;\-------------------------------------------/
CreateTheFile		Proc Near

			call OpenFile PASCAL , ds offset FullName , ds offset dummy , OF_CREATE OR OF_WRITE
                        Inc Ax
			Jne NewFileOk		; If File Creation successfull
			  Mov Ax,LHAE_WRITE
			  Stc
                          Jmp short NewFileEnd	
NewFileOk:		Dec Ax
			mov		outfile, ax		; Store new file handle
newFileEnd:		Ret


CreateTheFile		EndP


;/- SetAttr ---------------------------------\
;| 2. Set File attributes		     |
;\-------------------------------------------/
SetAttr		Proc near

; Set File Attributes ------------------
		Test Options, LHA_ATTRIB		; Set File attributes ?
		Je  NoSetAttr

			mov		dx, offset FullName
			mov		cl, byte ptr cpyhdr.FAttr
			xor		ch, ch
			mov		ax, 4301h
			int		21h				; Set File Attributes

NoSetAttr:	ret

SetAttr		EndP


;/- AppCallback ------------------------------\
;| Execute Applications Callback-Function Once|
;\--------------------------------------------/
AppCallback	Proc near

		Push Bx

		Mov  PeekResult, 0

		Mov  Bx, Word Ptr PeekP
		Or   Bx, Word Ptr PeekP+2
		Je   AppCallEnd

		Push Es
		PushA
		Push Ds

		Push Ax			; Save Usage Command

		Push ds			; Parameter Actual File pos.
		Push offset cpyhdr	; Save Adress of Info Structure

		Mov  Ax, Ds
		Mov  Es, Ax

		Mov  Ds, PeekDS
		Call es:PeekP

		Pop Ds
		Mov  PeekResult, Ax	; Result of Callback-Routine

		PopA
		Pop Es

AppCallEnd:     Pop Bx
		ret


AppCallback	EndP



;-----------------------------------------------
;		Output Error Text
;-----------------------------------------------

brokenerr:      Call GetFocus PASCAL

		Call MessageBox PASCAL , AX , cs offset broken, ds offset FullName , MB_OK OR MB_ICONHAND
		mov		al, 1
		mov		ah, 4ch	; Immediatly exit Program via DOS
		int		21h

;-----------------------------------------------
;		obt@̏o
;-----------------------------------------------
putbuf	proc	near
	xor		dx, dx	;	mov		dx, offset text_
	mov		cx, di
	sub		cx, dx
putbuf2:
	jcxz	return
	call _lwrite PASCAL , outfile , ds dx , cx
	Sub  Ax, Cx			; Test successfull write
	Jne  PutErr			; -> Error in PutBuf
;	mov		bx, outfile
;	mov		ah, 40h
;	int		21h
;	$_if <sub ax, cx>, NE
;SUB AX, CX
;jNE $_133
;jmp $_132
;$_133:
;		cmp		bx, 1
;		jne		errwrite
;	$_endif
;$_132:
calccrc:
	mov		si, dx
	mov		bx, curcrc
;	xor		ah, ah						; ah = 0
;	cld
$_134:
		lodsb
		xor		bl, al
		mov		al, bh
		mov		bh, ah
		shl		bx, 1
		mov		bx, crctbl[bx]
		xor		bx, ax
;	$_until <LOOP>
;	$_until <LOOP>
LOOP $_134
	mov		curcrc, bx
	mov		di, dx

;	cmp		outfile, 1
;	je		return
;	mov		ah, 02h
;	mov		dl, '.'
;	jmp		short int21_ret					; int	21h
	ret

PutErr:	Stc
	Mov Ax, LHAE_WRITE
	ret

putbuf	endp

;-----------------------------------------------
;		Copy File Data, no compression
;-----------------------------------------------
		public	copyall
copyall proc	near
		xor		di, di

CopyLoop:			mov		bx, offset cpyhdr.OrgSiz
				sub		[bx], di
				sbb		word ptr 2[bx], 0
				mov		cx, DSIZ2

				Jnz		$_136
						mov		ax, [bx]
						or		ax, ax
						jz		cpyend
				cmp ax,cx
				jnb		$_136

						mov		cx, ax
$_136:

				mov		dx, offset text_
				mov		bx, infile
				mov		ah, 3fh
				int		21h
				push	cx
				call	putbuf2
				pop		di
				Jc	cpyend		;-> if Error writing output File
		Jmp CopyLoop
cpyend:
		ret
copyall endp


;-----------------------------------------------
;		Delete incomplete Files
;-----------------------------------------------
		public	unlink
unlink	proc	near

		mov		dx, fnptr
		mov		ah, 41h							; unlink
		int		21h
return:
		ret
unlink	endp




;-----------------------------------------------
;		getc
;			ax: 1 byte (return)
;-----------------------------------------------
		public	getc
getc	proc	near
		mov		bx, inpptr
		cmp 		bx, offset inpbuf + BufSiz
		jnae		NoBufEmpty		; -> if buffer not empty now

	;-----------------------------------------------
	;		buffer 
	;-----------------------------------------------
			public	getbuf
	getbuf	proc	near
			push	cx
			push	dx
			mov		dx, offset inpbuf
			mov		cx, BufSiz
			mov		bx, offset cpyhdr.PacSiz
			sub		[bx], cx
			sbb		word ptr 2[bx], 0
			Jnc   MoreThanOneBlock
				add		cx, [bx]	; If there is only one Data Block left
MoreThanOneBlock:
			Add Word Ptr CpyHdr.ArcRead  , Cx
			Adc Word Ptr CpyHdr.ArcRead+2, 0

			Call _lread PASCAL , InFile, DS offset inpbuf , cx

			mov		bx, offset inpbuf
			pop		dx
			pop		cx
	getbuf	endp
	;-----------------------------------------------
NoBufEmpty:
		mov		al, [bx]
		inc		bx
		mov		inpptr, bx
		ret
getc	endp


;-----------------------------------------------
;		extract routines
;-----------------------------------------------
		public	decode
decode proc	near
	xor		ax, ax
	mov		blocksize_, ax
	mov		bitbuf_   , ax
	mov		subbitbuf_, al
	mov		bitcount_ , al


	Mov   Cx,AttrLen
        Add   Cx, Cx	

	;------------ Ignore Bytes that are added depending on attributes (Don't know why ...)
attrlp:	  jcxz  attrend
	  Mov Al,16
          Call getc
	  Loop attrlp
attrend:


	mov		al,16
	call	fillbuf_			; Make 16 Bit available in bitbuf

	mov		di, offset text_	; Destination Data Adress
	jmp		$entry

$loop:
		Mov	Ax,LHAM_PEEK		; Command : Nothing special
		Call	AppCallback		; Execute Applications Callback-Routine
		Cmp	PeekResult, LHAN_STOP	; Test: Callback-Routine wants to stop Immediatly?
		Je	StopDecomp

		call	decode_c_st1_
		or	ah, ah
		Jnz	ElseDecode

			stosb
			cmp di, offset text_[DSIZ2]
			Jne $entry
				call	putbuf	; Store Buffer in Output File
				Jc	DecodeEndErr	; -> If Error 
$entry:
			sub		word ptr cpyhdr.OrgSiz, 1
			jnc		$loop
		Jmp $_144
ElseDecode:
			mov		cx, ax
			sub		cx, 100h - 3
			call	decode_p_st1_
			mov		si, di
			stc
			sbb		si, ax
			push	cx
$_148:
				and		si, DSIZ2 - 1
				movsb
				test	di, DSIZ2
				Jz      $_150

					push	cx
					push	si
					call	putbuf
					pop		si
					pop		cx
					Jc	DecodeEndPop
$_150:
			Loop $_148

			pop		cx
			sub		word ptr cpyhdr.OrgSiz, cx
			jnc		$loop
;		$_endif
$_144:
		sbb		word ptr cpyhdr.OrgSiz + 2, 0
		jnc		$loop
	$endloop:
	call		putbuf
	Jmp short DecodeEnd

StopDecomp:	Stc		;Mark Error
		Mov Ax, LHAE_CALLBACK
		Jmp short DecodeEnd

DecodeEndPop:	pop cx
DecodeEndErr:	Mov Ax,LHAE_WRITE
DecodeEnd:	ret

decode endp


;	static void read_pt_len(short nn, short nbit, short i_special)
;public	read_pt_len_
read_pt_len_	proc	near
	push	si
	mov		al, dl
	call	getbits_
;	$_if <cmp ax, si>, A
CMP AX, SI
jA $_153
jmp $_152
$_153:
		jmp		brokenerr
;	$_endif
$_152:
	mov		di, offset pt_len_
;	$_if <or ax, ax>, Z
OR AX, AX
jZ $_155
jmp ElseRead
$_155:
		pop		cx
		rep		stosb
		mov		al, dl
		call	getbits_
		mov		cx, 256
		mov		di, offset pt_table_
		rep		stosw
		ret
;	$_else
ElseRead:	mov		dx, cx			; dl = i_special
		add		dx, di
		mov		si, di
		add		si, ax			; ax = n
$_156:
			mov		al, 3
			call	getbits_
;			$_if <cmp al, 7>, E
CMP AL, 7
jE $_159
jmp $_158
$_159:
				mov		bx, bitbuf_
WhileRead:			shl bx,1
				jnc EndWhileRead
					inc		ax
					Jmp short WhileRead
EndWhileRead:			push	ax
				sub		al, 6
				call	fillbuf_
				pop		ax
;			$_endif
$_158:
			stosb
;			$_if <cmp di, dx>, E
CMP DI, DX
jE $_161
jmp $_160
$_161:
				mov		al, 2
				call	getbits_
				mov		cx, ax
				xor		al, al
				rep		stosb
;			$_endif
$_160:
;		$_until <cmp di, si>, AE
;		$_until <cmp di, si>, AE
CMP DI, SI
jAE $_157
jmp $_156
$_157:
		pop		si						; nn
		mov		bp, offset pt_len_
		lea		cx, [bp + si]	;	lea		cx, pt_len_[si]
		sub		cx, di
		xor		al, al
		rep		stosb
		mov		ax, si
		mov		cx, 8
		mov		di, offset pt_table_
		jmp		make_table_
;	$_endif
$_154:
read_pt_len_	endp

;	static void read_c_len(void)
;public	read_c_len_
read_c_len_	proc	near
	mov		al, CBIT
	call	getbits_
;	$_if <cmp ax, NC>, A
CMP AX, NC
jA $_163
jmp $_162
$_163:
		jmp		brokenerr
;	$_endif
$_162:
	mov		di, offset c_len_
;	$_if <or ax, ax>, Z
OR AX, AX
jZ $_165
jmp ElseLen
$_165:
		mov		cx, NC
		rep		stosb
		mov		al, CBIT
		call	getbits_
		mov		cx, 4096
		mov		di, offset c_table_
		rep		stosw
		ret
;	$_else
ElseLen:	mov		dx, di
		add		dx, ax			; ax = n
		push	di
$_166:
			mov		ax, bitbuf_
			mov		bl, ah
			xor		bh, bh
			shl		bx, 1
			mov		bx, pt_table_[bx]

			mov		si, offset read_c_len_1
			mov		cx, NT
			jmp		tree1

if 0
			$_while <cmp bx, NT>, AE
;				$_if <shl al, 1>, C
SHL AL, 1
jC $_169
jmp $_168
$_169:
					mov		bx, right_[bx]
				$_else
					mov		bx, left_[bx]
;				$_endif
$_168:
			$_enddo
endif

read_c_len_1:
			push	bx
			mov		al, pt_len_[bx]
			call	fillbuf_
			pop		ax
;			$_if <sub ax, 2>, BE
SUB AX, 2
jBE $_171
jmp ElseLen4
$_171:
;				$_if , Z

jZ $_173
jmp ElseLen2
$_173:
					mov		al, CBIT
					call	getbits_
					add		ax, 20
					mov		cx, ax
					Jmp		$_172
;				$_else
ElseLen2:
;					$_if <inc ax>, Z
INC AX
jZ $_175
jmp ElseLen3
$_175:
						mov		al, 4
						call	getbits_
						add		ax, 3
						mov		cx, ax
						Jmp		$_174
;					$_else
ElseLen3:						mov		cx, 1
;					$_endif
$_174:
;				$_endif
$_172:
				xor		al, al
				rep		stosb
				Jmp		$_170
;			$_else
ElseLen4:				stosb
;			$_endif
$_170:
;		$_until <cmp di, dx>, AE
;		$_until <cmp di, dx>, AE
CMP DI, DX
jAE $_167
jmp $_166
$_167:
		mov		cx, offset c_len_ + NC
		sub		cx, di
		xor		al, al
		rep		stosb
		mov		ax, NC
		pop		bp
		mov		cx, 12
		mov		di, offset c_table_
		jmp		make_table_
;	$_endif
$_164:
read_c_len_	endp

;	ushort decode_c_st1(void)
decode_c	proc	near
;	not entry here
decode_c_st1_2:
	push	di
	mov		al, 16
	call	getbits_
	dec		ax
	mov		blocksize_, ax
	mov		si, NT
	mov		dl, TBIT
	mov		cx, 3
	call	read_pt_len_
	call	read_c_len_
	mov		si, NP
	mov		dl, PBIT
	mov		cx, -1
	call	read_pt_len_
	pop		di
	jmp		decode_c_st1_3
;
;	entry here
;
public	decode_c_st1_
decode_c_st1_:
	sub		blocksize_, 1
	jc		decode_c_st1_2
decode_c_st1_3:
	mov		bx, bitbuf_
	mov		cl, 4
	shr		bx, cl
	shl		bx, 1
	mov		bx, c_table_[bx]
;	$_if	<cmp bx, NC>, B
CMP BX, NC
jB $_177
jmp $_176
$_177:
decode_c_st1_1:
		push	bx
		mov		al, c_len_[bx]
		call	fillbuf_
		pop		ax
		ret
;	$_endif
$_176:
	mov		ax, bitbuf_
	shl		al, cl
	mov		si, offset decode_c_st1_1
	mov		cx, NC
tree0:
$_178:
;		$_if <shl al, 1>, C
SHL AL, 1
jC $_181
jmp ElseDec1
$_181:
			mov		bx, right_[bx]
			Jmp $_180
;		$_else
ElseDec1:		mov		bx, left_[bx]
;		$_endif
$_180:
tree1:
;	$_until <cmp bx, cx>, B
;	$_until <cmp bx, cx>, B
CMP BX, CX
jB $_179
jmp $_178
$_179:
	jmp		si
decode_c	endp

;	ushort decode_p_st1(void)
public	decode_p_st1_
decode_p_st1_	proc	near
;---------------------------------------------------------------
;	ushort decode_p_st1(void)
;---------------------------------------------------------------
	push	cx
	xor		bh, bh
	mov		bl, byte ptr bitbuf_ + 1
	shl		bx, 1
	mov		bx, pt_table_[bx]
;	$_if	<cmp bx, NP>, B
CMP BX, NP
jB $_183
jmp $_182
$_183:
decode_p_st1_1:
		push	bx
		mov		al, pt_len_[bx]
		call	fillbuf_
		pop		ax
;		$_if <cmp al, 1>, A
CMP AL, 1
jA $_185
jmp $_184
$_185:
			dec		ax
			mov		cx, ax
			call	getbits_
			mov		bx, 1
			shl		bx, cl
			or		ax, bx
;		$_endif
$_184:
		pop		cx
		ret
;	$_endif
$_182:
	mov		al, byte ptr bitbuf_
	mov		si, offset decode_p_st1_1
	mov		cx, NP
	jmp		tree0

if 0
$_186:
;		$_if <shl al, 1>, C
SHL AL, 1
jC $_189
jmp $_188
$_189:
			mov		bx, right_[bx]
		$_else
			mov		bx, left_[bx]
;		$_endif
$_188:
;	$_until <cmp bx, NP>, B
;	$_until <cmp bx, NP>, B
CMP BX, NP
jB $_187
jmp $_186
$_187:
	jmp		decode_p_st1_1
endif
decode_p_st1_	endp


;---------------------------------------------------------------
;	void make_table(short nchar, uchar bitlen[],
;	                         ax            bp
;					short tablebits, ushort _table[])
;	                             cx            di
;---------------------------------------------------------------
_BSS	segment ;at 000h ; para public 'BSS'
;	org 0h
;_BSS	segment para public 'BSS'
avail_mt		dw		1 dup (?)
nchar			dw		1 dup (?)
bitlen			dw		1 dup (?)
tablebits		dw		1 dup (?)
_table			dw		1 dup (?)
restbits		db		1 dup (?)

public	avail_mt
public	nchar
public	bitlen
public	tablebits
public	_table
public	restbits
_BSS	ends

	public	make_table_
make_table_	proc	near
	mov		nchar, ax
	shl		ax, 1
	mov		avail_mt, ax
	mov		tablebits, cx
	mov		_table, di
	mov		al, 16
	sub		al, cl
	mov		restbits, al

	mov		ax, 1
	shl		ax, cl
	mov		cx, ax
	xor		ax, ax
	rep		stosw

	xor		si, si
	mov		bx, 8000h
	mov		dx, 1
$_190:
		mov		di, bp
		mov		cx, nchar
$_192:
			mov		al, dl
			repne	scasb
			jne		mt1
			mov		ax, di
			sub		ax, bp
			dec		ax
			push	cx
			push	di
;			; bx = weight
;			; si = code
;			; dx = len
			mov		cl, restbits
			mov		di, si
			shr		di, cl
			shl		di, 1
			add		di, _table
			push	bx
;			$_if <cmp dx, tablebits>, BE
CMP DX, TABLEBITS
jBE $_195
jmp ElseTab1
$_195:
				shr		bx, cl
				mov		cx, bx
				rep		stosw
				Jmp		$_194
;			$_else
;		/*  n  tree  */
;				; di = taddr
;				; si =
;				; cx =
;				; ax = char
ElseTab1:			push	si
				mov		cx, tablebits
				shl		si, cl
				neg		cx
				add		cx, dx
$_196:
;					$_if <cmp word ptr [di], 0>, E
CMP WORD PTR [DI], 0
jE $_199
jmp $_198
$_199:
;				/* }܂тĂȂ΍ */
						mov		bx, avail_mt
						mov		right_[bx], 0
						mov		left_[bx], 0
						mov		[di], bx
						add		avail_mt, 2
;					$_endif
$_198:
					mov		di, [di]
;					$_if <shl si, 1>, C
SHL SI, 1
jC $_201
jmp ElseTab2
$_201:
						add		di, offset right_
;					$_else
						Jmp $_200
ElseTab2:					add		di, offset left_
;					$_endif
$_200:
;				$_until <LOOP>
;				$_until <LOOP>
LOOP $_196
				mov		[di], ax
				pop		si
;			$_endif
$_194:
			pop		bx
			pop		di
			pop		cx
			add		si, bx
			jc		mt2
;		$_until <or cx, cx>, Z
;		$_until <or cx, cx>, Z
OR CX, CX
jZ $_193
jmp $_192
$_193:
mt1:
		inc		dx
		shr		bx, 1
;	$_until , C
;	$_until , C

jC $_191
jmp $_190
$_191:
public mt2
mt2:
	ret
make_table_	endp

;-----------------------------------------------
;		͂炎rbg𓾂
;-----------------------------------------------
;
;ushort getbits(uchar n)
;{
	public	getbits_
getbits_:		
	push	cx
	mov		cl, 16
	sub		cl, al
	push	bitbuf_
	call	fillbuf_
	pop		ax
	shr		ax, cl
	pop		cx
	ret

;
;void fillbuf(uchar n)  /* Shift bitbuf n bits left, read n bits */
;{

;/- Fillbuf --------------------------------------------------------------\
;| read in AL Bits from input File into BitBuf and SubBitBuf		  |
;\------------------------------------------------------------------------/
fillbuf_	proc near

	push	cx
	push	dx
	mov		ch, al
	mov		cl, bitcount_
	mov		dx, bitbuf_
	mov		al, subbitbuf_

	cmp		ch, cl		; Count of Bits wantet > Count of Bits stored ?
	Jna		NoFillNew	; -> If enough Bits available in bitbuf
	
		sub		ch, cl	; Compute count of bits to load
		shl		dx, cl	; Rotate available Data to the left ??
		rol		al, cl	;                                   ??
		add		dl, al  ; Combine LSB/MSB                   ??
		mov		cl, 8	;
fb1:
		call	getc		; Get one Byte -> AL
		cmp	ch, cl		; Are there enough Bits available now ?
                Jna	EndFillLoop	; -> Enough bits available, don't add more

			sub		ch, cl	; Subtract count of bits read
			mov		dh, dl	; Shift in new Data Byte to DH:DL:AL
			mov		dl, al
	jmp		fb1			; -> Read in next Byte

EndFillLoop:
NoFillNew:                              ; DH:DL:AL contains Data Bits, CL=Bit position in DH, CH=Rest of bits read
	sub		cl, ch		; CL=New Bit Position in DH 
	mov		bitcount_, cl	; Store new bit position
	mov		cl, ch		; Count of Bits to shift away
	xor		ah, ah		
	shl		dx, cl		; Shift Bits and combine them
	shl		ax, cl		
	add		dl, ah
	mov		bitbuf_, dx     ; Store new Bits
	mov		subbitbuf_, al	; Store LSB
	pop		dx		; Restore Register Data
	pop		cx
	ret

fillbuf_	endp


_TEXT	ends

_Bss	Segment
endBSS			label	byte
_Bss	EndS

		end
