{---------------------------------------------------------------------
  L H A L I B . L I B
  Library to be used in Microsoft windows Programs
  makes it possible to extract LHA-Archives.
 ---------------------------------------------------------------------}

Unit LhaLib;

Interface

{ ----------- Options ------------------------------------------------ }
const  LHA_OVERWRITE=  $0001;	{  Codes for Options-Parameter }
const  LHA_ATTRIB=     $0010;	{  Set File Attributes }

{ ----------- Callback Routine Messages ------------------------------ }
const  LHAM_PEEK= 	  1;		{  Nothing special }
const  LHAM_NEXTFILE= 	  2;		{  Start processing next File }

{ ------------- Error Codes ------------------------------------------- }
{  The Errorcode are selected to be between 2000 and 2100, so it's easyer }
{  to store the error text in an Resource File }

const  LHAE_ARCHIVNOTFOUND= 	 2020;		{  Archiv File not Found }
const  LHAE_BROKEN= 		 2021;		{  Broken Archiv }
const  LHAE_METHOD= 		 2022;		{  Compression Method not supported }
const  LHAE_WRITE= 		 2023;		{  Error creating/writing File }
const  LHAE_CRC= 		 2024;		{  CRC error }
const  LHAE_CALLBACK= 		 2025;		{  Callbackroutine returned LHAN_STOP }


{ ------------- Callback-Notification-Codes ----- }
const  LHAN_OK= 			 0;		{  Nothing special }
const  LHAN_IGNOREFILE= 		 1;		{  Used with LHAM_NEXTFILE : Irgnore this File }
const  LHAN_STOP= 		 2;		{  Used with LHAM_PEEK     : Stop Decompression of Archive immediatly }


type    LPLZHEAD = ^LZHEAD;      { Pointer to an LZH-Header Structure }
          LZHEAD = Record
                 	HeadSiz : Byte;		{  Header Size in Bytes }
                        HeadChk : Byte;		{  Header Checksum }
	                HeadID  : Array[0..2] of Char;	{  Header ID Code }
	                Method  : Char;		{  Compression Method }
                        free1   : Byte;
                        PacSiz  : LongInt;	{  Packed File Size }
	                OrgSiz  : LongInt;	{  Original File Size not decompressed yet }
	                FTime   : Word;		{  File Time an Date Stamp }
	                FDate   : Word;		{  File Time an Date Stamp }
	                FAttr   : Word;		{  File Attributes }
	                FnLen   : Byte;         {  Length of valid File-Name in FName }
                        FName   : Array[0..$7f] of Char;  {  File Name }
                        FileSize: LongInt;      {  Original File Size }
                        UserData: LongInt;      {  User Data from original LHAExpand-Call }
	                ArcSize : LongInt;      {  Size of LZH-Archiv File }
	                ArcRead : LongInt;	{  Count of Bytes read from Archiv until now (not Exact) }
	End;


{ Peek Proc is Type for a Pointer to a Callback-Structure }
type PeekProc = Function(Msg : Integer; lp : LPLZHEAD) : Integer;


{ Main Functionality }
Function LHAExpand( ArchivName : PChar;         { Name of the .LZH-Archiv to expand }
                    PathName   : PChar;         { Name of the Destination-Path, for example C:\Windows }
                    Options    : Integer;       { LHA_xxxx - Flags }
                    CallBackProc: PeekProc;     { Address of a Callback-Procedure }
                    UserData    : LongInt       { USer-Data accesslable in the LZHEAD-Structure on Callbacks }
                    ) : Integer; far;

{ Show a Message-Box with an Error-Message ... }
Procedure LHAMessage( nId : Integer ); far;		{  Show Error Message Box, only available for DLL Version }


implementation

Function LHAExpand( ArchivName : PChar;         { Name of the .LZH-Archiv to expand }
                    PathName   : PChar;         { Name of the Destination-Path, for example C:\Windows }
                    Options    : Integer;       { LHA_xxxx - Flags }
                    CallBackProc: PeekProc;     { Address of a Callback-Procedure }
                    UserData    : LongInt       { USer-Data accesslable in the LZHEAD-Structure on Callbacks }
                    ) : Integer;
                    external 'LHALIB';

{ Show a Message-Box with an Error-Message ... }
Procedure LHAMessage( nId : Integer ); external 'LHALIB';		{  Show Error Message Box, only available for DLL Version }

Begin
End.