page	0, 128
;---------------------------------------------------------------------
; L H A L I B . L I B
; Library to be used in Microsoft windows Programs
; makes it possible to extract LHA-Archives.
;---------------------------------------------------------------------
; Usage:
; int FAR PASCAL LHAExpand(char *ArchivName, char *FileName, int Options,
;			   FARPROC PeekProc)
;
; with:
; ArchivName : FileName of LHA-Archivfile. Extension is recommended.
; FileName   : Optional Name of File to Extract. Should be NULL
;	       in this Version of LHALIB
; PeekProc   : Application-supplied callback-Routine to enable Multitasking
;	       Should be NULL in this Version of LHALIB
;
; Options may be:
; LHA_OVERWRITE		Overwrite existing Files without warning
; LHA_ATTRIB		Set File attributes
;
include c:\borlandc\include\windows.inc

;------------- Stack usage ---------------------
; BP+16 4 char *  ArchivNAme
; BP+12 4 char *  FileName
; BP+10 2 int     Options
; BP+6  4 FARPROC PeekProc
; BP+2	4 	  return  Adress
; BP+0	2 	  old BP  Value
; 14 Bytes for Parameters at all

;------------- Windows Procedures used ---------
extrn	PASCAL _LOPEN    : far
extrn   PASCAL _LREAD    : far
extrn	PASCAL _LWRITE   : far
extrn   PASCAL _LCLOSE   : far
extrn	PASCAL _LLSEEK   : far
extrn	PASCAL OPENFILE  : far
extrn   PASCAL MESSAGEBOX: far
extrn   PASCAL GETFOCUS  : far

;------------- Codes for Options-Parameter -----
LHA_OVERWRITE		= 0001H		; Do not Ask before overwriting File
LHA_ATTRIB		= 0010H		; Set File Attributes

;------------- Error Codes ---------------------

LHAE_ARCHIVNOTFOUND	= 20		; Archiv File not Found
LHAE_BROKEN		= 21		; Broken Archiv
LHAE_METHOD		= 22		; Compression Method not supported
LHAE_WRITE		= 23		; Error creating/writing File
LHAE_CRC		= 24		; CRC error

_TEXT	segment byte public 'CODE'
_TEXT	ends

;_BSS	group	_BSS
		assume	cs:_TEXT, ds:_BSS

CRC16			equ		0a001h
BufSiz			equ		04000h

NC			=		(200h - 2)
NP			=		14
NT			=		19
NPT			=		080h

CBIT		=		9
PBIT		=		4
TBIT		=		5

DSIZ		=		2000h
DSIZ2		=		DSIZ * 2

LzHead	struc
		HeadSiz db		?
		HeadChk db		?
		HeadID	db		3 dup (?)
		Method	db		?
			db		?
		PacSiz	dd		?
		OrgSiz	dw		2 dup (?)
		FTime	dw		?
		FDate	dw		?
		FAttr	dw		?
		FnLen	db		?
		Fname	db		80h dup (?)
LzHead	ends

_BSS	segment public

		public	crctbl
		public	cpyhdr, infile, outfile
		public	inpptr, inpbuf, text_
		public	curcrc, orgcrc
		public	myname
		public	pathname, fnnext, swchar
		public	blocksize_

text_			db		DSIZ2 dup (?)
inpbuf			db		BufSiz dup (?)
crctbl			dw		100h dup (?)
cpyhdr			LzHead	1 dup (<?>)
dummy			OpenStruc ?
inpptr			dw		1 dup (?)
infile			dw		1 dup (?)		; File Handle of input File
outfile			dw		1 dup (?)
orgcrc			dw		1 dup (?)
curcrc			dw		1 dup (?)
blocksize_		dw		1 dup (?)

len_cnt			dw		17 dup (?)
start			dw		17 dup (?)
weight			dw		17 dup (?)

cmethod			db		?			; Compression Method

public	len_cnt
public	start
public	weight


left_			dw		2 * NC - 1 dup (?)
right_			dw		2 * NC - 1 dup (?)

c_table_		dw		4096 dup (?)
pt_table_		dw		256 dup (?)
c_len_			db		NC dup (?)
pt_len_			db		NPT dup (?)

public	left_
public	right_
public	c_table_
public	pt_table_
public	c_len_
public	pt_len_

bitbuf_			dw		1 dup (?)
subbitbuf_		db		1 dup (?)
bitcount_		db		1 dup (?)

myname			db		80h dup (?)
pathname		db		80h dup (?)
fnnext			dw		1 dup (?)
fnptr			dw		1 dup (?)
swchar			db		1 dup (?)
endBBS			label	byte
_BSS			ends

_TEXT	segment byte public 'CODE'

		assume	cs:_TEXT

PeekProc   equ DWORD PTR ss:[BP+6]
Options    equ  WORD PTR ss:[BP+8]
FileName   equ DWORD PTR ss:[BP+12]
ArchivName equ DWORD PTR ss:[BP+16]

OverWtText	db "Diese Datei existiert bereits. Soll sie ueberschrieben werden", 0

		public LHAEXPAND

LHAExpand	Proc Far

		cld			; Clear Direction Flag once
		Push Bp			; Save old BP-Value
		Mov  Bp,Sp              ; Make Procedure Parameters Adressable

		Push Ds			; Save other Registers
		Mov Ax, _BSS		; We like to use our own Data-Segment
		Mov Ds, Ax

		Call OpenInput		; Try to open Input File
		Jc ReturnError		; -> Input File not found

		Call GetHeader		; Read Archiv Header
		Jc ReturnError		; -> Broken File

		Call MakeCRC		; Prepare CRC-Table

FilesLoop:	Call GetFHeader		; Read in File Header
		Jc ReturnError

		Call Extract		; Extract File Data
		Jc ReturnError

		Xor Ax,Ax		; Return Value

ReturnError:
		Pop Ds
		Pop Bp
		ret 14

LHAExpand	EndP


;/- OpenInput -------------------------------\
;| Try to open the Archive Input File        |
;| returns Errorcode and Carry set on Error  |
;\-------------------------------------------/
OpenInput	Proc Near

		Xor Ax,Ax			; Mov Ax, OF_READ
		Call _lopen PASCAL , ArchivName, Ax

		Mov  InFile, Ax			; return File Handle

		Inc Ax
		Jne OpenInOk			; -> No Error Occured

			Stc				; Set Carry Flag
			Mov Ax,LHAE_ARCHIVNOTFOUND	; Errorcode : Archiv not found

OpenInOk:	Ret

OpenInput	EndP



;/- GetHeader -------------------------------\
;| Read Archive File Header                  |
;| 1. Find start of Archiv                   |
;| 2. Position File to Archiv Header         |
;\-------------------------------------------/
GetHeader	Proc near

		Call _lread PASCAL , InFile, DS offset inpbuf , BufSiz

		Mov Cx, Ax		; Count of Bytes read

		Inc Ax
		Je GetHdErr		; -> Error in _lread

;		Search for start of Archive Header, so EXE-Archives may be
;		decompressed
		mov		si, offset _BSS:inpbuf

GetHdSearch:		Cmp  word ptr _BSS:[si],'l-'
			Jne  GetHdNxt
			Cmp  Byte ptr _BSS:[si+4],'-'
			Je   GetHdFnd

GetHdNxt:		Inc  Si
			Loop GetHdSearch
		Jmp  GetHdErr			; -> Broken Archiv Error

GetHdFnd:       Sub  si, (offset _BSS:inpbuf + 2)
		Call _llseek PASCAL , InFile, 0 Si , 0   ; DOS-Function: Seek in File to Position CX:DX Handle BX

		Inc Ax
		Jne GetHdEnd			; -> if File is OK

GetHdErr:       Stc
		Mov Ax, LHAE_BROKEN		; Broken Archiv

GetHdEnd:	Ret

GetHeader	EndP


;/- MakeCRC ---------------------------------\
;| Prepare CRC Table                         |
;\-------------------------------------------/
MakeCRC		Proc Near

		push		ds
		pop		es
		mov		di, offset crctbl
		xor		dx, dx
MakeCRCOuter:
			mov		ax, dx
			mov		cx, 8
MakeCRCInner:
				shr		ax, 1
				jnc		MakeCRCXor
					xor		ax, CRC16
MakeCRCXor:
			Loop MakeCrcInner

			stosw
			inc dl
		jne MakeCRCOuter

		Ret

MakeCrc		EndP


;/- GetFHeader ------------------------------\
;| Read Archive File Header                  |
;| 1. Read Header Length Byte		     |
;| 2. Read rest of File Header               |
;| 3. Test Header Checksum		     |
;\-------------------------------------------/
GetFHeader	Proc near

; Get Header ---------------------------
		call _lread PASCAL , InFile, ds offset cpyhdr.HeadSiz, 1
		Dec Al                  ; Had to read exactly one Byte
		Jne GetFEnd		; -> if error or End of File

		Mov Al, cpyhdr.HeadSiz
		Xor Ah, Ah
		Or  Al, al
		Je  GetFEnd		; -> End of File

		Inc Al
		call _lread PASCAL , InFile, ds offset cpyhdr.HeadSiz+1, ax
		Inc Ax
		Je  GetFErr		; -> if error

; Test Header Sum ----------------------
			Mov		Si, offset _BSS:cpyhdr.HeadSiz
			Mov		Cl, Byte Ptr [Si]
			Xor		Ch, Ch
			Inc		Si
			LodsB					; Load Header Checksum
			Inc		Cl
;			Dec		Cl
;			Dec		Cl

			Dec		Si
TestHead:               Inc		si
			sub		al, [si]
			Loop		TestHead

			Je		GetFEnd

GetFErr:	Stc
		Mov Ax,LHAE_BROKEN

GetFEnd:	Ret

GetFHeader	EndP



;/- Extract ---------------------------------\
;| Extract File from Archive                 |
;| 1. Test Header ID         		     |
;| 2. Get original CRC                       |
;| 3. Test for existing File		     |
;\-------------------------------------------/
Extract		Proc


		Mov	Si, offset CpyHdr.HeadId	; Prepare Header Adress in SI ----------

		Call	TestHeader			; Test Header
		Jc	ExtractEnd			; -> if Errornous Header or Method not supported

		Call	GetOrgCrc			; Get Original CRC

; Test Special File ? ------------------
;			cmp		cx, 2101h				; 01h, '!'

;			Jne		NotMn7

;				mov		ax, 1
;				jmp		StartDecode

;NotMn7:
; Display File name --------------------
;			mov		word ptr [bx], 0 * 256 + ' '
;			mov		bx, dx
;			call	disp					; output file name
;			mov		byte ptr [bx - 1], 0

;			jcxz	mn9						; !.BAT ?

; Check Existence of File --------------
			Call 		CheckOverwrite			; Test if File exists, Overwrite if neccessarry
			Je		ExtractEnd

; Overwrite ? --------------------------
;			mov		bx, offset overwt	; prompt
;			call	mesout
;			call	getyn
;			je		CreateNewFile

;mn9:
;			mov		cs:autoflg, 0dh

; Create a New File --------------------
			call OpenFile PASCAL , ds offset CpyHdr.FName , ds offset dummy , OF_CREATE OR OF_WRITE
			Cmp Ax,-1
			Je ExtractErrCreate

;			mov		cx, 0020h
;			mov		ah, 3ch
;			int		21h					; Create a File
;			Jc		ExtractErrWrite

; Decode -------------------------------
StartDecode:		mov		outfile, ax		; Store new file handle
			xor		ax, ax
			mov		curcrc, ax
			dec		ax
			mov		inpptr, ax

			push	dx
;			or bp,bp
			test cMethod, 0ffh
			Push Bp
			jz Method0

				call	decode
			Jmp	AfterDecode

Method0:			call	copyall		; File only stored, Copy all

AfterDecode:            pop		Bp
			pop		si
			Jc	ExtractEnd		; Jump if Error mark set

			Call TimeStamp			; Set File Time and Date

			Call _lclose PASCAL , OutFile	; Close output File
;			call	close

; Check CRC ----------------------------
			mov		ax, curcrc
			cmp		ax, orgcrc
			Mov		Ax, LHAE_CRC
			jne		ExtractErr

			call	setattr			; Set File attributes
			Or Al,Al			; Reset Carry
			Jmp ExtractEnd


;			jmp		mn6
;mn8:
;			call	getyn
;			jne		exit1
;mn6:
;		Jmp	MainLoop		; -> Process next File of Archive

;		mov		bx, infile	; ???????????????????
;		call	close

;		public	exit
;exit:
;		call	@autoexec

;		public	_autoexec
;_autoexec:
;exit1:
;		xor		al, al
;exit2:
;		mov		ah, 4ch
;		int		21h

ExtractErrWrite:
ExtractErrCreate:      	Mov Ax, LHAE_WRITE
ExtractErr:		Stc
ExtractEnd:		Ret

Extract		EndP



;/- TestHeader ------------------------------\
;| Test Header and extract ID                |
;\-------------------------------------------/
TestHeader	Proc near

		lodsw
		cmp ax, 'l-'
		Jne TestHdErr		; -> Broken File

			lodsw		; Get Compression Method
			xchg	al, ah
			sub		ax, 'h0'
			mov		cMethod, al	; Store Compression Method
			je		NoErrMth	; -> if Method is OK
			sub		ax, 4
			je		NoErrMth	; -> if Method is OK
			dec		ax
			jne		ErrMth		; -> if Method is not OK

NoErrMth:		lodsb
			sub al, '-'
			je		TestHdEnd

; Error in Header
TestHdErr:	Stc
		Mov Ax, LHAE_BROKEN
		Jmp short TestHdEnd

; Compression Method not supported -----
ErrMth:		Stc
		Mov Ax, LHAE_METHOD

TestHdEnd:	ret

TestHeader	EndP


;/- GetOrgCrc -------------------------------\
;| Get Original CRC -> ORGCRC                |
;\-------------------------------------------/
GetOrgCrc		Proc near

			mov		bx, offset _BSS:cpyhdr.Fname
			mov		dx, bx
			mov		cx, [bx - 1]
			add		bl, cl				; doesn't carry up

			xchg	ax, [bx]			; ax = 0, [bx] = CRC
			mov		orgcrc, ax
			mov		fnptr, dx

			Ret

GetOrgCrc		EndP

;/- CheckOverwrite --------------------------\
;| Check, if file should be verwritten,      |
;| ask User if neccessary    		     |
;\-------------------------------------------/
CheckOverwrite		Proc near

			Test		Options, LHA_OVERWRITE		; If this Flag not set, ask before overwriting
			Jne		CreateNewFile			; -> Create File, do not Ask

				Call OpenFile PASCAL , ds dx , ds offset dummy , OF_EXIST
				Inc Ax					; Test File existence
				Je	CreateNewFile			; -> Create File, do not Ask

					Call OverWtMessage		; Ask User, if File should be overwritten

					je	CreateNewFile		; -> Create New FIle

					Call SkipThis			; Skip File Data
					Xor Ax, Ax			; Give Return Code
					Jmp Short CheckOverEnd

CreateNewFile:		Inc Ax

CheckOverEnd:		Ret

CheckOverwrite		EndP

;			mov		ax, 4300h				; get file attr
;			int		21h						;	(for MS-DOS 3.3)
;			jc		CreateNewFile
;			Jmp CreateNewFile


;/- OverWtMessage ---------------------------\
;| Ask User, if File should be overwritten   |
;\-------------------------------------------/
OverWtMessage		Proc near

			Call GetFocus PASCAL

			Call MessageBox PASCAL , AX , cs offset OverWtText , ds offset CpyHdr.FName , MB_YESNO OR MB_ICONQUESTION
			Cmp  Ax, IDYES

			Ret

OverWtMessage		EndP



;/- SkipThis --------------------------------\
;| Skip File Data to next File               |
;\-------------------------------------------/
SkipThis		Proc near

			call _llseek PASCAL , InFile , CpyHdr.PacSiz , 1

			Ret

;			mov		dx, _BSS:cpyhdr.PacSiz		; skip file
;			mov		cx, _BSS:cpyhdr.PacSiz + 2

;			mov		bx, infile
;			mov		ax, 4201h 			; seek to relative position
;			int		21h					; Move a File Pointer
;			jmp		mn6

SkipThis		EndP


;/- TimeStamp -------------------------------\
;| 1. Set output File Time and Date          |
;\-------------------------------------------/
TimeStamp		Proc Near

			mov		bx, outfile
;			cmp		bx, 1					; file '!' ?
;			je		mn8

			mov		dx, _BSS:cpyhdr.FDate
			mov		cx, _BSS:cpyhdr.FTime
			mov		ax, 5701h				; set date
			int		21h

			ret

TimeStamp		EndP


;/- SetAttr ---------------------------------\
;| 2. Set File attributes		     |
;\-------------------------------------------/
SetAttr		Proc near

; Set File Attributes ------------------
		Test Options, LHA_ATTRIB		; Set File attributes ?
		Je  NoSetAttr

			mov		dx, offset CpyHdr.FName
			mov		cl, byte ptr _BSS:cpyhdr.FAttr
			xor		ch, ch
			mov		ax, 4301h
			int		21h				; Set File Attributes

NoSetAttr:	ret

SetAttr		EndP

		public	start
		public	_cright, crlf, space
		public	absent, _myself, broken, extend
		public	_subver

mes_yn	equ		space - 1
space	db		' ', 0
_cright	db		"LHA's SFX 2.11"
_subver	db		"L (c) Yoshi, 1991"
crlf	db		13, 10, 0
absent	db		'Rename to '
_myself	db		'FILENAME.EXT', 0
overwt	db		'Overwrite ', 0
yesno	db		'[Y/N] ', 0
broken	db		'Broken file ', 0
write	db		'Write', 0
header	db		'Header', 0
crcmes	db		'CRC'
error	db		' Error', 0
auto	db		1, '!'
autoflg db		'.' shr 1
		db		'BAT'
extend	db		0ffh
attrib	db		0

envseg	=		002ch
cmdcnt	=		0080h
cmdline =		0081h


		public	exit
exit:

exit1:
		xor		al, al
exit2:
		mov		ah, 4ch
		int		21h

brokenerr:
			mov		bx, offset broken		; Broken file
			jmp		errout


;-----------------------------------------------
;		G[
;-----------------------------------------------
;		public	errhdr, errwrite, errout
;errcrc:
;		call	unlink
;		mov		bx, offset crcmes
;		jmp		short errout1

errwrite:
		mov		bx, outfile
		call	close
		call	unlink
		mov		bx, offset write

errout:
		call	mesout
		mov		bx, offset error
errout1:
		call	mesout
		mov		al, 1
		jmp		exit2

;-----------------------------------------------
;		get 'Y' or 'N'
;-----------------------------------------------
		public	getyn
getyn	proc	near
		mov		bx, offset yesno				; prompt
		call	mesout
$_130:
			mov		ah, 08h
			int		21h
			and		al, 0dfh
			cmp		al, 'Y'
			je		InputYes
			cmp 		al, 'N'

		jne	$_130

InputYes:	mov		bx, offset mes_yn
		mov		cs:[bx], al
		call	mesout
		cmp		al, 'Y'
		ret
getyn	endp

;-----------------------------------------------
;		obt@̏o
;-----------------------------------------------
putbuf	proc	near
	xor		dx, dx	;	mov		dx, offset _BSS:text_
	mov		cx, di
	sub		cx, dx
putbuf2:
	jcxz	return
	call _lwrite PASCAL , outfile , ds dx , cx
	Sub  Ax, Cx			; Test successfull write
	Jne  PutErr			; -> Error in PutBuf
;	mov		bx, outfile
;	mov		ah, 40h
;	int		21h
;	$_if <sub ax, cx>, NE
;SUB AX, CX
;jNE $_133
;jmp $_132
;$_133:
;		cmp		bx, 1
;		jne		errwrite
;	$_endif
;$_132:
calccrc:
	mov		si, dx
	mov		bx, curcrc
;	xor		ah, ah						; ah = 0
;	cld
$_134:
		lodsb
		xor		bl, al
		mov		al, bh
		mov		bh, ah
		shl		bx, 1
		mov		bx, crctbl[bx]
		xor		bx, ax
;	$_until <LOOP>
;	$_until <LOOP>
LOOP $_134
	mov		curcrc, bx
	mov		di, dx

;	cmp		outfile, 1
;	je		return
;	mov		ah, 02h
;	mov		dl, '.'
;	jmp		short int21_ret					; int	21h
	ret

PutErr:	Stc
	Mov Ax, LHAE_WRITE
	ret

putbuf	endp

;-----------------------------------------------
;		Copy File Data, no compression
;-----------------------------------------------
		public	copyall
copyall proc	near
		xor		di, di

CopyLoop:			mov		bx, offset _BSS:cpyhdr.OrgSiz
				sub		[bx], di
				sbb		word ptr 2[bx], 0
				mov		cx, DSIZ2

				Jnz		$_136
						mov		ax, [bx]
						or		ax, ax
						jz		cpyend
				cmp ax,cx
				jnb		$_136

						mov		cx, ax
$_136:

				mov		dx, offset _BSS:text_
				mov		bx, infile
				mov		ah, 3fh
				int		21h
				push	cx
				call	putbuf2
				pop		di
				Jc	cpyend		;-> if Error writing output File
		Jmp CopyLoop
cpyend:
		ret
copyall endp

;-----------------------------------------------
;		t@C close
;-----------------------------------------------
		public	close
close	proc	near
		mov		ah, 3eh
		int 21h
		ret
												; ret
close	endp

;-----------------------------------------------
;		Delete incomplete Files
;-----------------------------------------------
		public	unlink
unlink	proc	near

		mov		dx, fnptr
		mov		ah, 41h							; unlink
		int		21h
return:
		ret
unlink	endp

;-----------------------------------------------
;		CR, LF ̏o
;-----------------------------------------------
crlfout	proc	near
		mov		bx, offset crlf
crlfout	endp
;-----------------------------------------------
;		bZ[W̏o
;-----------------------------------------------
		public	mesout
mesout	proc	near
		push	ds
		push	cs
		pop		ds
		call	disp
		pop		ds
		ret
mesout	endp

;-----------------------------------------------
;		display ASCIZ char
;-----------------------------------------------
		public	disp
disp	proc	near
		push	ax
		push	dx
$_138:
			mov		dl, [bx]
			inc		bx
			mov		ah, 02h
			int		21h
;		$_until <cmp byte ptr [bx], 0>, E
;		$_until <cmp byte ptr [bx], 0>, E
CMP BYTE PTR [BX], 0
jE $_139
jmp $_138
$_139:
		pop		dx
		pop		ax
		ret
disp	endp

;-----------------------------------------------
;		getc
;			ax: 1 byte (return)
;-----------------------------------------------
		public	getc
getc	proc	near
		mov		bx, inpptr
;		$_if <cmp bx, offset inpbuf + BufSiz>, AE
CMP BX, OFFSET INPBUF + BUFSIZ
jAE $_141
jmp $_140
$_141:
	;-----------------------------------------------
	;		buffer 
	;-----------------------------------------------
			public	getbuf
	getbuf	proc	near
			push	cx
			push	dx
			mov		dx, offset _BSS:inpbuf
			mov		cx, BufSiz
			mov		bx, offset _BSS:cpyhdr.PacSiz
			sub		[bx], cx
			sbb		word ptr 2[bx], 0
;			$_if , C

jC $_143
jmp $_142
$_143:
				add		cx, [bx]
;			$_endif
$_142:
			mov		bx, infile
			mov		ah, 3fh
			int		21h					; Read from an Archive
			mov		bx, dx
			pop		dx
			pop		cx
	getbuf	endp
	;-----------------------------------------------
;		$_endif
$_140:
		mov		al, [bx]
		inc		bx
		mov		inpptr, bx
		ret
getc	endp

;-----------------------------------------------
;		extract routines
;-----------------------------------------------
		public	decode
decode proc	near
	xor		ax, ax
	mov		blocksize_, ax
	mov		bitbuf_, ax
	mov		subbitbuf_, al
	mov		bitcount_, al

	mov		al,16
	call	fillbuf_

	mov		di, offset _BSS:text_
	jmp		$entry

$loop:
		call	decode_c_st1_
		or	ah, ah
		Jnz	ElseDecode

			stosb
			cmp di, offset _BSS:text_[DSIZ2]
			Jne $entry
				call	putbuf
$entry:
			sub		word ptr cpyhdr.OrgSiz, 1
			jnc		$loop
		Jmp $_144
ElseDecode:
			mov		cx, ax
			sub		cx, 100h - 3
			call	decode_p_st1_
			mov		si, di
			stc
			sbb		si, ax
			push	cx
$_148:
				and		si, DSIZ2 - 1
				movsb
				test	di, DSIZ2
				Jz      $_150

					push	cx
					push	si
					call	putbuf
					pop		si
					pop		cx
$_150:
			Loop $_148

			pop		cx
			sub		word ptr cpyhdr.OrgSiz, cx
			jnc		$loop
;		$_endif
$_144:
		sbb		word ptr cpyhdr.OrgSiz + 2, 0
		jnc		$loop
	$endloop:
	jmp		putbuf
decode endp


;	static void read_pt_len(short nn, short nbit, short i_special)
;public	read_pt_len_
read_pt_len_	proc	near
	push	si
	mov		al, dl
	call	getbits_
;	$_if <cmp ax, si>, A
CMP AX, SI
jA $_153
jmp $_152
$_153:
		jmp		brokenerr
;	$_endif
$_152:
	mov		di, offset _BSS:pt_len_
;	$_if <or ax, ax>, Z
OR AX, AX
jZ $_155
jmp ElseRead
$_155:
		pop		cx
		rep		stosb
		mov		al, dl
		call	getbits_
		mov		cx, 256
		mov		di, offset _BSS:pt_table_
		rep		stosw
		ret
;	$_else
ElseRead:	mov		dx, cx			; dl = i_special
		add		dx, di
		mov		si, di
		add		si, ax			; ax = n
$_156:
			mov		al, 3
			call	getbits_
;			$_if <cmp al, 7>, E
CMP AL, 7
jE $_159
jmp $_158
$_159:
				mov		bx, bitbuf_
WhileRead:			shl bx,1
				jnc EndWhileRead
					inc		ax
					Jmp short WhileRead
EndWhileRead:			push	ax
				sub		al, 6
				call	fillbuf_
				pop		ax
;			$_endif
$_158:
			stosb
;			$_if <cmp di, dx>, E
CMP DI, DX
jE $_161
jmp $_160
$_161:
				mov		al, 2
				call	getbits_
				mov		cx, ax
				xor		al, al
				rep		stosb
;			$_endif
$_160:
;		$_until <cmp di, si>, AE
;		$_until <cmp di, si>, AE
CMP DI, SI
jAE $_157
jmp $_156
$_157:
		pop		si						; nn
		mov		bp, offset _BSS:pt_len_
		lea		cx, [bp + si]	;	lea		cx, _BSS:pt_len_[si]
		sub		cx, di
		xor		al, al
		rep		stosb
		mov		ax, si
		mov		cx, 8
		mov		di, offset _BSS:pt_table_
		jmp		make_table_
;	$_endif
$_154:
read_pt_len_	endp

;	static void read_c_len(void)
;public	read_c_len_
read_c_len_	proc	near
	mov		al, CBIT
	call	getbits_
;	$_if <cmp ax, NC>, A
CMP AX, NC
jA $_163
jmp $_162
$_163:
		jmp		brokenerr
;	$_endif
$_162:
	mov		di, offset _BSS:c_len_
;	$_if <or ax, ax>, Z
OR AX, AX
jZ $_165
jmp ElseLen
$_165:
		mov		cx, NC
		rep		stosb
		mov		al, CBIT
		call	getbits_
		mov		cx, 4096
		mov		di, offset _BSS:c_table_
		rep		stosw
		ret
;	$_else
ElseLen:	mov		dx, di
		add		dx, ax			; ax = n
		push	di
$_166:
			mov		ax, bitbuf_
			mov		bl, ah
			xor		bh, bh
			shl		bx, 1
			mov		bx, pt_table_[bx]

			mov		si, offset read_c_len_1
			mov		cx, NT
			jmp		tree1

if 0
			$_while <cmp bx, NT>, AE
;				$_if <shl al, 1>, C
SHL AL, 1
jC $_169
jmp $_168
$_169:
					mov		bx, right_[bx]
				$_else
					mov		bx, left_[bx]
;				$_endif
$_168:
			$_enddo
endif

read_c_len_1:
			push	bx
			mov		al, pt_len_[bx]
			call	fillbuf_
			pop		ax
;			$_if <sub ax, 2>, BE
SUB AX, 2
jBE $_171
jmp ElseLen4
$_171:
;				$_if , Z

jZ $_173
jmp ElseLen2
$_173:
					mov		al, CBIT
					call	getbits_
					add		ax, 20
					mov		cx, ax
					Jmp		$_172
;				$_else
ElseLen2:
;					$_if <inc ax>, Z
INC AX
jZ $_175
jmp ElseLen3
$_175:
						mov		al, 4
						call	getbits_
						add		ax, 3
						mov		cx, ax
						Jmp		$_174
;					$_else
ElseLen3:						mov		cx, 1
;					$_endif
$_174:
;				$_endif
$_172:
				xor		al, al
				rep		stosb
				Jmp		$_170
;			$_else
ElseLen4:				stosb
;			$_endif
$_170:
;		$_until <cmp di, dx>, AE
;		$_until <cmp di, dx>, AE
CMP DI, DX
jAE $_167
jmp $_166
$_167:
		mov		cx, offset _BSS:c_len_ + NC
		sub		cx, di
		xor		al, al
		rep		stosb
		mov		ax, NC
		pop		bp
		mov		cx, 12
		mov		di, offset _BSS:c_table_
		jmp		make_table_
;	$_endif
$_164:
read_c_len_	endp

;	ushort decode_c_st1(void)
decode_c	proc	near
;	not entry here
decode_c_st1_2:
	push	di
	mov		al, 16
	call	getbits_
	dec		ax
	mov		blocksize_, ax
	mov		si, NT
	mov		dl, TBIT
	mov		cx, 3
	call	read_pt_len_
	call	read_c_len_
	mov		si, NP
	mov		dl, PBIT
	mov		cx, -1
	call	read_pt_len_
	pop		di
	jmp		decode_c_st1_3
;
;	entry here
;
public	decode_c_st1_
decode_c_st1_:
	sub		blocksize_, 1
	jc		decode_c_st1_2
decode_c_st1_3:
	mov		bx, bitbuf_
	mov		cl, 4
	shr		bx, cl
	shl		bx, 1
	mov		bx, c_table_[bx]
;	$_if	<cmp bx, NC>, B
CMP BX, NC
jB $_177
jmp $_176
$_177:
decode_c_st1_1:
		push	bx
		mov		al, c_len_[bx]
		call	fillbuf_
		pop		ax
		ret
;	$_endif
$_176:
	mov		ax, bitbuf_
	shl		al, cl
	mov		si, offset decode_c_st1_1
	mov		cx, NC
tree0:
$_178:
;		$_if <shl al, 1>, C
SHL AL, 1
jC $_181
jmp ElseDec1
$_181:
			mov		bx, right_[bx]
			Jmp $_180
;		$_else
ElseDec1:		mov		bx, left_[bx]
;		$_endif
$_180:
tree1:
;	$_until <cmp bx, cx>, B
;	$_until <cmp bx, cx>, B
CMP BX, CX
jB $_179
jmp $_178
$_179:
	jmp		si
decode_c	endp

;	ushort decode_p_st1(void)
public	decode_p_st1_
decode_p_st1_	proc	near
;---------------------------------------------------------------
;	ushort decode_p_st1(void)
;---------------------------------------------------------------
	push	cx
	xor		bh, bh
	mov		bl, byte ptr bitbuf_ + 1
	shl		bx, 1
	mov		bx, pt_table_[bx]
;	$_if	<cmp bx, NP>, B
CMP BX, NP
jB $_183
jmp $_182
$_183:
decode_p_st1_1:
		push	bx
		mov		al, pt_len_[bx]
		call	fillbuf_
		pop		ax
;		$_if <cmp al, 1>, A
CMP AL, 1
jA $_185
jmp $_184
$_185:
			dec		ax
			mov		cx, ax
			call	getbits_
			mov		bx, 1
			shl		bx, cl
			or		ax, bx
;		$_endif
$_184:
		pop		cx
		ret
;	$_endif
$_182:
	mov		al, byte ptr bitbuf_
	mov		si, offset decode_p_st1_1
	mov		cx, NP
	jmp		tree0

if 0
$_186:
;		$_if <shl al, 1>, C
SHL AL, 1
jC $_189
jmp $_188
$_189:
			mov		bx, right_[bx]
		$_else
			mov		bx, left_[bx]
;		$_endif
$_188:
;	$_until <cmp bx, NP>, B
;	$_until <cmp bx, NP>, B
CMP BX, NP
jB $_187
jmp $_186
$_187:
	jmp		decode_p_st1_1
endif
decode_p_st1_	endp


;---------------------------------------------------------------
;	void make_table(short nchar, uchar bitlen[],
;	                         ax            bp
;					short tablebits, ushort _table[])
;	                             cx            di
;---------------------------------------------------------------
_BSS	segment ;at 000h ; para public 'BSS'
;	org 0h
;_BSS	segment para public 'BSS'
avail_mt		dw		1 dup (?)
nchar			dw		1 dup (?)
bitlen			dw		1 dup (?)
tablebits		dw		1 dup (?)
_table			dw		1 dup (?)
restbits		db		1 dup (?)

public	avail_mt
public	nchar
public	bitlen
public	tablebits
public	_table
public	restbits
_BSS	ends

	public	make_table_
make_table_	proc	near
	mov		nchar, ax
	shl		ax, 1
	mov		avail_mt, ax
	mov		tablebits, cx
	mov		_table, di
	mov		al, 16
	sub		al, cl
	mov		restbits, al

	mov		ax, 1
	shl		ax, cl
	mov		cx, ax
	xor		ax, ax
	rep		stosw

	xor		si, si
	mov		bx, 8000h
	mov		dx, 1
$_190:
		mov		di, bp
		mov		cx, nchar
$_192:
			mov		al, dl
			repne	scasb
			jne		mt1
			mov		ax, di
			sub		ax, bp
			dec		ax
			push	cx
			push	di
;			; bx = weight
;			; si = code
;			; dx = len
			mov		cl, restbits
			mov		di, si
			shr		di, cl
			shl		di, 1
			add		di, _table
			push	bx
;			$_if <cmp dx, tablebits>, BE
CMP DX, TABLEBITS
jBE $_195
jmp ElseTab1
$_195:
				shr		bx, cl
				mov		cx, bx
				rep		stosw
				Jmp		$_194
;			$_else
;		/*  n  tree  */
;				; di = taddr
;				; si =
;				; cx =
;				; ax = char
ElseTab1:			push	si
				mov		cx, tablebits
				shl		si, cl
				neg		cx
				add		cx, dx
$_196:
;					$_if <cmp word ptr [di], 0>, E
CMP WORD PTR [DI], 0
jE $_199
jmp $_198
$_199:
;				/* }܂тĂȂ΍ */
						mov		bx, avail_mt
						mov		right_[bx], 0
						mov		left_[bx], 0
						mov		[di], bx
						add		avail_mt, 2
;					$_endif
$_198:
					mov		di, [di]
;					$_if <shl si, 1>, C
SHL SI, 1
jC $_201
jmp ElseTab2
$_201:
						add		di, offset _BSS:right_
;					$_else
						Jmp $_200
ElseTab2:					add		di, offset _BSS:left_
;					$_endif
$_200:
;				$_until <LOOP>
;				$_until <LOOP>
LOOP $_196
				mov		[di], ax
				pop		si
;			$_endif
$_194:
			pop		bx
			pop		di
			pop		cx
			add		si, bx
			jc		mt2
;		$_until <or cx, cx>, Z
;		$_until <or cx, cx>, Z
OR CX, CX
jZ $_193
jmp $_192
$_193:
mt1:
		inc		dx
		shr		bx, 1
;	$_until , C
;	$_until , C

jC $_191
jmp $_190
$_191:
public mt2
mt2:
	ret
make_table_	endp

;-----------------------------------------------
;		͂炎rbg𓾂
;-----------------------------------------------
;
;ushort getbits(uchar n)
;{
	public	getbits_
getbits_:		
	push	cx
	mov		cl, 16
	sub		cl, al
	push	bitbuf_
	call	fillbuf_
	pop		ax
	shr		ax, cl
	pop		cx
	ret

;
;void fillbuf(uchar n)  /* Shift bitbuf n bits left, read n bits */
;{

	public	fillbuf_
fillbuf_:
	push	cx
	push	dx
	mov		ch, al
	mov		cl, bitcount_
	mov		dx, bitbuf_
	mov		al, subbitbuf_
;	$_if <cmp ch, cl>, A
CMP CH, CL
jA $_203
jmp $_202
$_203:
		sub		ch, cl
		shl		dx, cl
		rol		al, cl
		add		dl, al
		mov		cl, 8
fb1:
		call	getc
;		$_if <cmp ch, cl>, A
CMP CH, CL
jA $_205
jmp $_204
$_205:
			sub		ch, cl
			mov		dh, dl
			mov		dl, al
			jmp		fb1
;		$_endif
$_204:
;	$_endif
$_202:
	sub		cl, ch
	mov		bitcount_, cl
	mov		cl, ch
	xor		ah, ah
	shl		dx, cl
	shl		ax, cl
	add		dl, ah
	mov		bitbuf_, dx
	mov		subbitbuf_, al
	pop		dx
	pop		cx
	ret

		public	_endofshort
_endofshort:

resident:

;-----------------------------------------------
;		Get options
;-----------------------------------------------
		public	@getopt
@getopt:
		mov		ax, 3700h
		int		21h								; get switch char
		mov		si, cmdline
		mov		es:swchar, dl

		mov		es:fnnext, offset _BSS:pathname
$_208:
			lodsb
;			$_if <cmp al, ' '>, A
CMP AL, ' '
jA $_211
jmp $_210
$_211:
;				$_if <cmp al, es:swchar>, E, OR
CMP AL, ES:SWCHAR
jE $_213
				cmp al, '-'
				Je $_213
jmp $_212
$_213:
;				$_c	 <cmp al, '-'>, E
lp0:
					lodsb
					cmp		al, ' '
					jbe		lp1
					or		al, 20h
					cmp 		al, '!'
					jne 		Switch01
						shl		cs:autoflg, 1
						jmp		short EndSwitch
Switch01:				cmp		al, 'x'
					jne 		Switch02
						inc		cs:extend
						jmp		short EndSwitch
Switch02:				cmp		al, 'a'
					jne 		SwitchDef
						inc		cs:attrib
						jmp		short EndSwitch
SwitchDef:
						cmp		al, 'e'
						jne		lp0
						lodsb
EndSwitch:
;				$_endif
$_212:
				dec		si
				mov		di, offset _BSS:pathname
				push	si
				call	convert
				pop		si
				push	ax
				mov		al, '/'
				call	trans
				mov		al, '/'
				Cmp 		ah, al
				Je		NoStosb
				Cmp		ah, ':'
				je		NoStosb
					stosb
NoStosb:			mov		es:fnnext, di
				pop		ax
lp1:
;			$_endif
$_210:
;		$_until <cmp al, 0dh>, E
;		$_until <cmp al, 0dh>, E
CMP AL, 0DH
jE $_209
jmp $_208
$_209:
		ret

		public	@extended
@extended:
			mov		si, dx
			mov		di, offset auto + 1		; !.BAT ?
			cmp		cl, 5
			jne		mn5
			push	es
			push	cs
			pop		es
			xor		ch, ch
			rep		cmpsb
			pop		es
			je		mn2

; -x switch ----------------------------
mn5:
			mov		si, dx
			mov		cx, si
			call	convert
;			$_if <cmp cs:extend, 0>, E
CMP CS:EXTEND, 0
jE $_217
jmp $_216
$_217:
				mov		dx, cx			; last delim
;			$_endif
$_216:

; -eDIRECTORY --------------------------
			mov		si, dx
			mov		al, [si]
;			$_if <cmp al, '/'>, NE
CMP AL, '/'
jNE $_219
jmp ElseDir1
$_219:
				mov		di, fnnext
				call	trans
				mov		bx, di
				mov		dx, offset _BSS:pathname
				Jmp		$_218
;			$_else
ElseDir1:			mov		ax, word ptr _BSS:pathname
;				$_if <cmp ah, ':'>, E
CMP AH, ':'
jE $_221
jmp $_220
$_221:
					dec		dx
					dec		dx
					mov		di, dx
					mov		[di], ax	; brakes FnLen and
;				$_endif					;	upper byte of FAttr
$_220:
;			$_endif
$_218:

; Make Directories ---------------------
			mov		si, dx
$_222:
				lodsb
;				$_if <cmp al, '/'>, E
CMP AL, '/'
jE $_225
jmp $_224
$_225:
					mov		byte ptr [si - 1], 0
					mov		ah, 39h ; make dir
					int		21h
					mov		byte ptr [si - 1], '/'
;				$_endif
$_224:
;			$_until <cmp si, bx>, AE
;			$_until <cmp si, bx>, AE
CMP SI, BX
jAE $_223
jmp $_222
$_223:

			mov		fnptr, dx
			mov		cx, 1
mn2:
			ret

;-----------------------------------------------
;		convert '\' to '/' & terminater
;-----------------------------------------------
conv	proc	near
$_228:
;			$_if <cmp al, '\'>, E, OR
CMP AL, '\'
jE $_231
cmp al, '\'
Je $_231
jmp $_230
$_231:
;			$_c  <cmp al, '/'>, E
				mov		byte ptr -1[si], '/'
				mov		cx, si
;			$_endif
$_230:
; is kanji ---------------------
			and		al, 0e0h
			shl		al, 1
			Jnc		NoInc
			Jpo		NoInc
				inc		si
NoInc:
; ------------------------------
convert:
			lodsb
;		$_until <cmp al, ' '>, BE
;		$_until <cmp al, ' '>, BE
CMP AL, ' '
jBE $_229
jmp $_228
$_229:
		dec		si
		mov		byte ptr [si], 0
		ret
conv	endp

;-----------------------------------------------
;		transfer string
;-----------------------------------------------
trans	proc	near
$_234:
			mov		ah, al
			lodsb
			stosb
;		$_until <or al, al>, E
;		$_until <or al, al>, E
OR AL, AL
jE $_235
jmp $_234
$_235:
		dec		di
		ret
trans	endp

_TEXT	ends
		end
