Program WinLha;

{ Example for the use of the LHALIB.DLL LHA-Decompressor DLL in Pascal.
  Bernd Herd 14.7.1995
}

{$M 30000, 8000 }

uses WinTypes, WinProcs, Strings, Win31, WinCrt,
     LhaLib;

{ Define a Callback }

var ticker : Integer;

{ An Example for a Callback-Function that is used during Decompression
  (The second Call to LHAEXpand
}
Function ExpandCallback(cmd : Integer; lp : LPLZHEAD) : Integer; far;
var i : Integer;
begin
  ExpandCallback := 0;             { Initialize Return-Value }
  case cmd of
     LHAM_PEEK: Begin
                   Inc(ticker);
                   if (ticker mod 5000 = 0) then
                      writeln('File: ', lp^.FName, ' Ready: ', lp^.OrgSiz * 100 div lp^.FileSize, '%');
                End;

     LHAM_NEXTFILE: Begin
                      i := MessageBox( GetFocus,
                                      'Wollen Sie diese Datei entpacken',
                                      lp^.FName,
                                      MB_ICONQUESTION or MB_YESNOCANCEL);
                      case i of
                         IDYES    : ExpandCallback := 0;
                         IDNO     : ExpandCallback := LHAN_IGNOREFILE;
                         IDCANCEL : ExpandCallback := LHAN_STOP;
                      End;
                    end;
   End;
End;


{ An Example for a Callback-Funktion that does omit Decompression
  but lists the File-Contents instead.

  (First Call to LHAExpand in the Demo)
}

Function ListCallback(cmd : Integer; lp : LPLZHEAD) : Integer; far;
Begin
  writeln('File: ', lp^.FName, 'Size:', lp^.OrgSiz);
  ListCallback := LHAN_IGNOREFILE;
End;


var  FName : Array[0..100] of char;

Begin   { Main Program }

   writeln('WINLHA : Beispiel fuer einen auf LHALIB');
   writeln('         aufbauenden LHA-Dekomprimierer unter Windows');
   writeln('         Diese Version benutzt dir LHALIB.DLL');
   writeln('         (C) Bernd Herd 1993-1995');

   if (ParamCount=1) then Begin
      strpcopy(FName, ParamStr(1));
      if (NIL=strscan(FName, '.')) then
	   lstrcat(FName, '.LZH');

      writeln('Liste der Dateien im Archiv ', FName);
      writeln('----------------------------------------');

      LHAExpand(FName, '', 0, ListCallback, 0);

      writeln('Rckkehrcode: ', LHAExpand(FName, '', 0, ExpandCallback, 0));
   end
   else Begin
     writeln('Benutzung: Geben Sie den Dateinamen des Archives an. (Default-Extension.LZH)');
     writeln('Usage:     WINLHA <ArchivName> (Default-Extension.LZH)');
   End
End.

