{ --------------------------------------------------------------------
 |        C A L L B C K . P A S
 |
 | This is a Simple Pascal-Based Demonstration-Program for LZAPI
 |
 | It will simply copy all you INI-Files into an Archiv in the Temp
 | Directory. But in contrast to SIMPLE.PAS it will tell LZAPI
 | to use the Callback-Technology supported by LZAPI.
 | The only thing it will do is to change Cursor Type every 300 milliseconds.
 |
 | Bernd Herd 9.5.95
 ---------------------------------------------------------------------- }

Program Callbck;

uses LZAPI, WinProcs, WinTypes, Strings;


var Ctl              : LACTL;                   { Define the Control Strcture }
    WindowsDirectory : Array[0..144] of char;   { Windows-Directory with our INI-Files }
    TempDirectory    : Array[0..144] of char;   { Directory for Temp-Files }
    p                : Pchar;
    dummy            : TOFSTRUCT;               { For OpenFile }
    err              : LAERR;                   { LZAPI Error Code }



  { ----------- Definitions for Callback ------------------- }
  const Cursors : Array[0..5] of PChar =
                   ( IDC_WAIT, IDC_ARROW, IDC_CROSS, IDC_IBEAM, IDC_ICON, IDC_SIZE );
        Next    : Integer = 0;
        TickCount: LongInt =0 ;

  { ----------- Simple Callback-Routine -------------------- }
  function OurCallback(Msg : Integer; lpCtl : LPLACTL) : Integer; export;
  var Now : LongInt;
  Begin
    Now := GetTickCount;                        { Actions in Callbacks should not Depend on Call-Count, but on TIME }
    if (Now-TickCount > 300) then Begin
        TickCount := Now;
        SetCursor(LoadCursor(0, Cursors[Next mod 6]));
        Inc(Next);
    End;
    OurCallback := 0;
  End;


Begin
  { ------ Windows Directory ------------------------ }
  GetWindowsDirectory( WindowsDirectory, sizeof(WindowsDirectory) );

  { ------ Temp-Directory --------------------------- }
  GetTempFileName(#0, 'LZH', 0, TempDirectory);
  OpenFile( TempDirectory, dummy, OF_DELETE);
  strRscan(TempDirectory, '\')[1] := #0;
  strCat  (TempDirectory, 'INIS.ARC');

  { ------ Fill Control structure ------------------- }
  FillChar( Ctl, sizeof(Ctl), 0);
{  Ctl.hwndOwner       := ; This Program does not open a Window... normaly you MUST support this! }
  Ctl.lStructSize     := sizeof( Ctl );
  Ctl.lpstrArchivFile := TempDirectory;
  Ctl.lpstrWildcards  := '*.INI';
  Ctl.lpstrPath       := WindowsDirectory;
  Ctl.Flags           := LAF_SHORTNAMES;
  Ctl.lpfnCallback    := OurCallback;

  { ------ Perform Actions -------------------------- }
  err := LAAppend( @Ctl );
  MessageBeep(0);
  if (err <> LAE_OK)
      then LAErrMsg(err, @Ctl )
      else MessageBox( 0, 'Hi, this was your Success for Today ;-)', 'SIMPLE.PAS', MB_OK or MB_ICONINFORMATION);
End.
