/* SIMPLE.C ----------------------------------------------------*
 * Hello, this is a simple Example for the Usage of LZAPI
 * in a C-Application
 * It will simply copy all you INI-Files into an Archiv in the Temp
 * Directory
 * Bernd Herd 19.4.1995
 *--------------------------------------------------------------*/

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <alloc.h>

#include "lzapi.h"		   // Needed for any Program that uses LZAPI

main()
{ LACTL    Ctl;			   // LZAPI Control-Structure.
  char     TempDirectory[130],	   // File-Name for a File in the Temp Directory
	   WindowsDirectory[50];   // Directory-Name of the Windows-Directory with the INI-Files
  LAERR    err;			   // Errorcode Return-Variable from LZAPI-Function Call
  OFSTRUCT dummy;

  // ------ Get Windows Directory --------------------------
  GetWindowsDirectory( WindowsDirectory, sizeof(WindowsDirectory) );

  // ----- Get Temp-Directory ------------------------------
  GetTempFileName(0, "LZH", 0, TempDirectory);
  OpenFile( TempDirectory, &dummy, OF_DELETE);
  strrchr(TempDirectory, '\\')[1] = 0;
  strcat (TempDirectory, "INIS.LZH");

  // -------- Initialize Control Structure -----------------
  memset(&Ctl, 0, sizeof(Ctl) );
  Ctl.lStructSize = sizeof(Ctl);
  Ctl.hwndOwner   = NULL;		// This Parameter is Recommended to hold
					// Your applications main Window

  // -------- Tell it, what to do --------------------------
  Ctl.lpstrArchivFile = TempDirectory;   // For example C:\\TMP\INIS.LZH
  Ctl.lpstrPath       = WindowsDirectory;// For example C:\\WINDOWS
  Ctl.lpstrWildcards  = "*.INI";	 // All INI-Files
  Ctl.Flags	      = LAF_SHORTNAMES;  // Recommended Option


  // -------- Inform user what we are going to do ----------
  printf("SIMPLE.C ---- Simple C-Code example for LZAPI\n"
	 "I'm going to Archive %Fs\\%Fs into Archiv %Fs\n",
	 Ctl.lpstrPath,
	 Ctl.lpstrWildcards,
	 Ctl.lpstrArchivFile);

  // -------- Perform Actions ------------------------------
  err = LAAppend( &Ctl );
  if (err != LAE_OK)
	   { LAErrMsg(err, &Ctl );
	     return 5;			// Cancel immediatly
	   }
      else MessageBox( 0, "Hi, this was your Success for Today ;-)", "SIMPLE.C", MB_OK | MB_ICONINFORMATION);


  printf("I'm going to list the Archiv %Fs\n", Ctl.lpstrArchivFile); 

  // -------- Let's show what we have done -----------------
  Ctl.lpstrArchivFile = TempDirectory;	 // Leave unchanged
  Ctl.lpstrWildcards  = NULL;            // Show all Files
  Ctl.lpstrListing    = (char *) malloc(30000); // Buffer for Listing

  err = LAList( &Ctl );
  if (err != LAE_OK)
	   { LAErrMsg(err, &Ctl );
	     return 5;			// Cancel immediatly
	   }
      else MessageBox( 0, "Listing buffer has Successfully been filled", "SIMPLE.C", MB_OK | MB_ICONINFORMATION);

  printf("Archiv Listing: \n"
	 "%Fs\n",
	 Ctl.lpstrListing);

  free(Ctl.lpstrListing);

  // --------- End Program ---------------------------------
  return 0;
}

