/*----------------------------------------------------------------------*
 *                                                                      
 *	W L H A . H     -
 * (C) 1996
 *	Dipl. Ing. Bernd Herd                    Dipl. Ing Harald Nuding
 *	Niederstr 36
 *	64285 Darmstadt
 *	Tel. 06151/664717                       Fax 06151/664740
 *      EMail: herdnuding@aol.com               BBS:06151/664741
 *                                                                      
 *	(C) 1994-95 Bernd Herd
 *
 * WLHA.DLL Dynamic Link Library for Microsoft Windows 3.1
 * makes it possible to extract Files from and add Files to LHA-Archives
 * without using LHA.EXE                                                
 *
  ---------------------------------------------------------------*/




#ifndef __WLHA_H
#define __WLHA_H

#ifdef __cplusplus
extern "C" {
#endif


#ifndef __IO_H
# include <io.h>
#endif

#ifndef __WINDOWS_H
# include <windows.h>
#endif

#ifndef __TIME_H
# include <time.h>
#endif


// #include "lh.h"
// End -----------------------------

// #include "mfiles.h"
/*======================================================================================*
 *                                                                                      *
 *                                                                                      *
 *			M F i l e s . H                                                 *
 *                                                                                      *
 *  Gepufferte Dateien unter Windows ohne Einschrnkungen durch Borland-Laufzeitsystem  *
 *											*
 *======================================================================================*/


/*

Zweck:

Diese kleine Untersttzungsbibliothek fr Datei Ein/Ausgaben verfolgt zwei Ziele:

1. Im Borland-Laufzeitsystem ist in Datei "_NFILE.H" die Konstante _NFILE_ als 20 definiert.
   Bentigt ein Programm eine grere Anzahl offener Dateien, so mu die Konstante
   _FILES_ gendert werden und das Laufzeitsystem mu neu bersetzt werden. Diese nderungen
   betreffen SMTLICHE anschlieend neu bersetzten C-Programme, indem mehr Speicher fr
   Datensegment reserviert wird.

   Die MFILES arbeiten auf eine etwas andere Weise und verzichten damit auf die Reservierung
   von Puffern im Datensegment der Applikation.

   Damit kann mit der Windows-API-Funktion SetHandleCount gearbeitet werden.

2. Mittels MFILES knnen Windows-Speicherhandles wie Dateien angesprochen werden.

   D.h. ein mit mopenglobal geffneter MFILE wird wie gewohnt mit mgetc / mputc /
   mread / mwrite / mseek usw. bearbeitet, ndert aber die Daten in einem Speicherhandle.

   Ist das Handle zu klein, um weitere Daten anzunehmen, so wird es mit GlobalReAlloc neu
   zugeordnet.


3. Mittels der Funktion mjoin knnen zwei physiche Dateien / Speicherhandles als eine
   zusammenhngende Datei angesprochen werden.


HINWEISE: - 'mclose' gibt das neue Speicherhandle zurck, und sollte benutzt werden,
	    wenn auf den MFILE geschrieben wird. I.a. lautet die Freigabe daher
	    GlobalFree(mClose(fh));

	  - 'mclose' kehrt unabhngig von der Dateiart mit NULL zurck, wenn das
	    schlieen der Datei oder das Wegschreiben des Dateipuffers fehlschlug.

	  - Wird auf einen MFILE geschrieben, so darf kein anderer Programmteil mit
	    dem Handle arbeiten, das Handle darf nicht mit GlobalLock gelockt sein.
*/


typedef HGLOBAL MFILE;			// Handle fr einen MFILE

MFILE   FAR PASCAL mopen(LPCSTR lpszName, WORD wAccess);	// ffnet eine MS-DOS-Datei als MFILE
MFILE   FAR PASCAL mopenglobal(HGLOBAL hMem, DWORD dwSize);	// ffnet ein Globales Speicherhandle als MFILE
MFILE   FAR PASCAL mdopen(HFILE hf);				// Ordnet eine bereits offenes Dateihandle als MFILE zu
HGLOBAL FAR PASCAL mclose(MFILE);				// Schliet einen MFILE.
								// mopen       : Datei wird geschlossen, Rckkehrwert von _lclose
								// mopenglobal : GlobalUnlock des Handles, Rckgabewert : Handle
								// mdopen      : Rckgabewert Dateihandle, Datei bleibt offen
int     FAR PASCAL mputc(int, MFILE);
int     FAR PASCAL mgetc(MFILE);
BOOL    FAR PASCAL meof(MFILE);
int     FAR PASCAL mgets(LPSTR lszDest, int nMax, MFILE);
DWORD	FAR PASCAL mseek(MFILE, DWORD, int dummy);		// Datei positionieren
DWORD	FAR PASCAL mtell(MFILE);				// Aktuelle Dateiposition

int     FAR PASCAL mread(void FAR *ptr, int size, int n, MFILE stream);
int     FAR PASCAL mwrite(void FAR *ptr, int size, int n, MFILE stream);

int	FAR PASCAL mgetftime(MFILE, struct ftime *);		// Time-Stamp der Datei bestimmen
int	FAR PASCAL msetftime(MFILE, struct ftime *);		// Time-Stamp der Datei setzen

int 	FAR PASCAL mchmod(MFILE, int func , int attrib );	// Get/Set File attributes like Borland's _chmod

MFILE	FAR PASCAL mjoin(MFILE, MFILE);				// Erzeuge gemeinsame Sicht auf zwei MFILEs



#define MEOF (-1)

//---------------------- End of MFILES.H ----------------------------









#define LHF FAR PASCAL

//----------- Options ------------------------------------------------

  //----------- Expand-Options ---------------------------------
  #define LHA_OVERWRITE   0x0001        // Codes for Options-Parameter
  #define LHA_ATTRIB      0x0010        // Set/Get File Attributes

  //----------- Append-Options ---------------------------------
  #define LHA_CREATEARCHIV 0x0100       // Generate a New Archiv, even if there is one already
  #define LHA_SHORTNAMES   0x0200	// Filenames in Archiv without Path

//----------- Callback Routine Messages ------------------------------
#define LHM_PEEK          1             // Nothing special
#define LHM_NEXTFILE      2             // Start processing next File

//------------- Error Codes -------------------------------------------
// The Errorcode are selected to be between 2000 and 2100, so it's easier
// to store the error text in an Resource File

typedef int LHERR;

#define LHE_OK			    0		// Anything OK
#define LHE_ARCHIVNOTFOUND       2020           // Archiv File not Found
#define LHE_BROKEN               2021           // Broken Archiv
#define LHE_METHOD               2022           // Compression Method not supported
#define LHE_WRITE                2023           // Error creating/writing File
#define LHE_CRC                  2024           // CRC error
#define LHE_CALLBACK             2025           // Callbackroutine returned LHAN_STOP
#define LHE_INSTANCE             2026           // Instanz-Handling-Error
#define LHE_INFILENOTFOUND       2027           // Input File not found
#define LHE_STOPPED              2028           // Stopped by Callbac-Routine

//------------- Callback-Notification-Codes -----
#define LHN_OK                   0              // Nothing special
//#define LHN_IGNOREFILE                 1              // Used with LHAM_NEXTFILE : Irgnore this File
#define LHN_STOP                 2              // Used with LHAM_PEEK     : Stop Decompression of Archive immediatly


struct datetime {
	WORD time;
	WORD date;
};


union stamp {					/* time stamp */
	DWORD  u;
	struct ftime s;
	struct datetime t;
};

struct head {
	int			headersize;
	char 		method[6];
	DWORD		packed;
	DWORD		skip;
	DWORD		original;
	union stamp	dostime;
	time_t		utc;
	int			attr;
	int			level;
	UINT		filecrc;
	UINT		headcrc;
	int			dos;
	char	    far	*pathname;
	char	    far	*filename;
	int			dirnlen;
	int			filenlen;
	int			info;
	long		currentpos;
	char		*crcpos;
};


typedef struct head FAR *LPLHHEAD;      // Long Pointer to the Structure



typedef LHERR (CALLBACK* LHCALLBACK)(int, LPLHHEAD);    // Type declaration Callback-Function


//----------- High-Level-Routines -----------------------------

LHERR LHF LHExpand( LPCSTR    ArchivName,       // Extract Files from Archiv
		    LPCSTR    PathName,
		    LPCSTR    Wildcards,	// Wildcards (e.g. *.TXT) or NULL
                    int       Options);


LHERR LHF LHAppend( LPCSTR    ArchivName,       // Append File or Create Archive
                    LPCSTR    FileName,
                    int       Options);


LHERR LHF LHInit   (HINSTANCE);                 // Initialize for next Archiv Operation
LHERR LHF LHEnd    (HINSTANCE);                 // End of Archiv Operation

void  LHF LHMessage( LHERR eId );               // Show Error Message Box, only available for DLL Version


LHERR LHF LHSetCallback(LHCALLBACK);            // Set Callback-Routine
int   LHF LHDefCallbck( int msg, LPLHHEAD);     // Default-Callback-Routine

void  LHF LHErrMsgBox( LHERR );         // Zeigt eine Message-Box mit einer Klartext-#
                                        // Fehlermeldung an

int   LHF LHRegister(LPCSTR lpszUserName, LPCSTR lpszPassword); // Shareware-Freischaltkennwort bergeben

//----------- Medium-Level-Routines ---------------------------

LHERR LHF LHAppendNext( MFILE  marc,            // File Handle Archiv
                        MFILE  minp,            // File Handle Input File
                        LPCSTR FileName,        // FileName Inside Archiv
                        int    Options);        // Archiving Options


LHERR LHF LHExpandNext( MFILE   marc,             // File Handle of input-Archiv
			LPCSTR  Wildcards,	// Wildcards (e.g. *.TXT) or NULL
			int     Options);         // Decompression Options

#ifdef __cplusplus
}
#endif


#endif     // __WLHA_H
