{  L Z D E L P H I

   Delphi-Demo for the use of LZAPI with Delphi.

   This simple Demo let you select an Archiv File and
   shows it's contents listing.

   If you click onto a file, the file get extracted and
   a viewer will be stared. If you click on an Archiv,
   LZDelphi will use itself as viewer.

   The files get deleted after closing the Viewer.

   Note that the files Reside in the actual Directory,
   what may lead to some Troubles from time to time.

   (C) 1995 Dipl. Ing. Bernd herd
}


unit Main;

interface

uses WinTypes, WinProcs, Classes, Graphics, Controls, Menus,
  Forms, StdCtrls, Dialogs, ExtCtrls, LzApi, sysUtils, Grids, ShellApi;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Label1: TLabel;
    OpenFileDialog1: TOpenDialog;
    Panel1: TPanel;
    File1: TMenuItem;
    Open1: TMenuItem;
    Exit1: TMenuItem;
    ArchivListing: TStringGrid;

    procedure FileOpenClick(Sender: TObject);
    procedure FileExitClick(Sender: TObject);
    procedure GetArchivListing(fileName : String);
    procedure ArchivListingDblClick(Sender: TObject);
    procedure ShowExtractedFile(FileName : PChar);
    procedure FormShow(Sender: TObject);

 private
    ArchivName       : Array[0..120] of Char ;
  end;

var
  Form1: TForm1;

implementation

{ ---------------------------------------------------------------
   Fill our TStringGrid with the Contents of the Archiv-File
   Selected in the File Open Dialog
}
procedure TForm1.GetArchivListing(FileName : String);
var Ctl              : LACTL;       { LZAPI Control Structure }
    LineNo           : Integer;     { Linenumber that we are Actually thinking about }
    err              : LAERR;
    This,
    Next             : PChar;

    ScanRec          : Record
                         Name,
                         UncompressedSize,
                         CompressedSize,
                         Ratio,
                         Date,
                         Time,
                         dummy1, dummy2, dummy3: PChar;
                       End;
    ScanDst          : ^PChar;
    ScanSrc          : PChar;
    ScanColumn       : Integer;

Begin

  Label1.Caption := FileName;

  { ------ Fill Control structure ------------------- }
  strpCopy(ArchivName, FileName);

  FillChar( Ctl, sizeof(Ctl), 0);
  Ctl.hwndOwner       := Handle;
  Ctl.lStructSize     := sizeof( Ctl );
  Ctl.lpstrArchivFile := ArchivName;
  Ctl.Flags           := LAF_SHORTNAMES;
  GetMem( Ctl.lpstrListing, 32767 );

  { ------- Liste lschen --------------------------- }
  ArchivListing.Rowcount:=2;

  ArchivListing.Cells[0, 0] := 'Name';
  ArchivListing.Cells[1, 0] := 'Uncompressed';
  ArchivListing.Cells[2, 0] := 'Compressed';
  ArchivListing.Cells[3, 0] := 'Ratio';
  ArchivListing.Cells[4, 0] := 'Date';
  ArchivListing.Cells[5, 0] := 'Time';
  ArchivListing.ColWidths[0]:= 100;

  Lineno:=1;

  { ------ Perform Actions -------------------------- }
  err := LAList( @Ctl );
  if (err <> LAE_OK)
      then LAErrMsg(err, @Ctl )
      else Begin

           Next := Ctl.lpstrListing;
           while (Next<>NIL) and
                 (Next^<>#0)
                 do Begin
              This := Next;

              Next := strScan(This, #10);
              if (Next<>NIL) then Begin
                 Next^:=#0;
                 Inc(Next);
              End;

              ScanDst := @ScanRec;
              ScanSrc := this;
              while (ScanSrc <> NIL) and
                    (ScanSrc^ <> #0) do Begin

                     ScanDst^:=ScanSrc;
                     ScanSrc := strscan(ScanSrc, #9);
                     if (ScanSrc<>NIL) then Begin
                        ScanSrc^:=#0;
                        inc(ScanSrc);
                     End;
                     Inc(ScanDst);
              End;

              ArchivListing.Cells[0, LineNo] := StrPas(ScanRec.Name);
              ArchivListing.Cells[1, LineNo] := StrPas(ScanRec.UncompressedSize);
              ArchivListing.Cells[2, LineNo] := StrPas(ScanRec.CompressedSize);
              ArchivListing.Cells[3, LineNo] := StrPas(ScanRec.Ratio);
              ArchivListing.Cells[4, LineNo] := StrPas(ScanRec.Date);
              ArchivListing.Cells[5, LineNo] := StrPas(ScanRec.Time);
              Inc(LineNo);
              ArchivListing.RowCount := LineNo;


{             Memo1.Lines.Add( StrPas(This) ); }
{             writeLn(This); }
           End;

      End;
  FreeMem( Ctl.lpstrListing, 32767 );

End;


{$R *.DFM}

procedure TForm1.FileOpenClick(Sender: TObject);
begin
  with OpenFileDialog1 do
    if Execute then
    begin
      GetArchivListing(FileName);
    end;
end;

procedure TForm1.FileExitClick(Sender: TObject);
begin
  Close;
end;

{ A File from the Archiv Listing has been selected.
  Decompress it.
}
procedure TForm1.ArchivListingDblClick(Sender: TObject);
var FileNameInArchiv : String;
    Row              : Integer;
    Ctl              : LACTL;       { LZAPI Control Structure }
    err              : LAERR;
    szFileName       : Array[0..100] of char;
    hco              : HCursor;
begin
  { Get the filename of the File to extract }
  Row := ArchivListing.Row;
  if row>0 then Begin
     FileNameInArchiv := ArchivListing.Cells[0,Row];
     if length(FileNameInArchiv) > 0 then Begin
         strpcopy(szFileName, FileNameInArchiv);

       { ------ Fill Control structure ------------------- }
         FillChar( Ctl, sizeof(Ctl), 0);
         Ctl.hwndOwner       := Handle;
         Ctl.lStructSize     := sizeof( Ctl );
         Ctl.lpstrArchivFile := ArchivName;
         Ctl.Flags           := LAF_SHORTNAMES;
         Ctl.lpstrWildCards  := szFileName;

       { ------ Perform Actions -------------------------- }
         hco := SetCursor(LoadCursor(0, IDC_WAIT));
         err := LAExtract( @Ctl );
         SetCursor(hco);
           if (err <> LAE_OK)
                 then LAErrMsg(err, @Ctl )
                 else Begin
               ShowExtractedFile(szFileName);
           End;

     End
     else MessageBeep(0);
  End
  else MessageBeep(0);
end;


{ -------------------------------------------------------------
   Try to show a File that has been successfully extracted from the Archiv
   ------------------------------------------------------------ }
procedure TForm1.ShowExtractedFile(FileName : PChar);
var Instance   : THandle;
    ModuleFileName: Array[0..130] of char;

{$IFDEF WIN32}
    si : TStartupInfo;
    pi : TProcessInformation;
{$ENDIF}

Begin
  AnsiUpper(FileName);
  if (StrPos(FileName, '.LZH')<>NIL) or
     (StrPos(FileName, '.ZIP')<>NIL) or
     (StrPos(FileName, '.ARC')<>NIL) or
     (StrPos(FileName, '.ARJ')<>NIL) or
     (StrPos(FileName, '.RAR')<>NIL) or
     (StrPos(FileName, '.TAR')<>NIL)
     then Begin
       { Start a Second Instance of yourself.... }
       GetModuleFileName(HInstance, ModuleFileName, sizeof(ModuleFileName));
       strcat(ModuleFileName, ' ');
       strcat(ModuleFileName, FileName);
       Instance := WinExec(ModuleFileName, SW_SHOW);
     End
     else begin
{$IFDEF WIN32}
       { Find out which EXE cutable Program shall handle our File. }

       if (FindExecutable(FileName, '.', ModuleFileName)<32) then
          lstrcpy(ModuleFileName, 'NOTEPAD');

       lstrcat(ModuleFileName, ' ');
       lstrcat(ModuleFileName, FileName);

       FillChar(si, sizeof(si), 0); si.cb := sizeof(si);
       FillChar(pi, sizeof(pi), 0);
       if (CreateProcess(
		NIL, 			{ ImageName }
		ModuleFileName,		{ Command Line }
		NIL,			{ Process Security Attributes }
		NIL,			{ Thread Security Attributes }
		FALSE,			{ Intherit Handles }
		NORMAL_PRIORITY_CLASS,	{ fdwCreate }
		NIL,			{ Environment String }
		NIL,			{ Current Directory }
		si,			{ Startupinfo-Structure }
		pi                      { PROCESS_INFO-Structure }
         )) then Begin
               Enabled := FALSE;                 { Do not accept any Input... }
               Label1.Color := clRed;            { Make bar red to show we're deisabled }
               while (WaitForSingleObject(pi.hProcess, 200)=WAIT_TIMEOUT) do
                     Application.ProcessMessages;{ Wait for the viewer to end. }
               CloseHandle(pi.hProcess);
	       CloseHandle(pi.hThread);
               Enabled := TRUE;                  { Do not accept more Input... }
               Label1.Color := clBtnFace;
            End
            else Begin Instance := 0; MessageBox(handle, 'CreateProcess Failes', 'lzdelphi', mb_ok); End;
     End;
{$ELSE}
       { Start a Program to show us the File }
       Instance :=
       ShellExecute(Handle, 'open',
                    FileName, '.', '',
                    SW_SHOW
                   );

       if (Instance < HINSTANCE_ERROR) then Begin
          strcopy(ModuleFileName, 'NOTEPAD ');
          strcat(ModuleFileName, FileName);
          Instance := WinExec(ModuleFileName, SW_SHOW);
       End;
    end;

    {    Wait until the User closes down the initialization File. }
    if (Instance > HINSTANCE_ERROR) then Begin
        Enabled := FALSE;                 { Do not accept any Input... }
        Label1.Color := clRed;
        while (GetModuleUsage(Instance)<>0) do
          Application.ProcessMessages;
        Enabled := TRUE;                  { Do not accept more Input... }
        Label1.Color := clBtnFace;
    End;
{$ENDIF}

    { Delete the Temporary File after the user closed the Viewer Application }
    DeleteFile(strPas(FileName));
End;

{ ------------------------------------------------------------
   Program stared: Look for a Command Line
}

procedure TForm1.FormShow(Sender: TObject);
begin
  if (ParamCount>0) then
     GetArchivListing(ParamStr(1));

end;

end.
