{-----------------------------------------------------------------------*
 *                                                                      *
 *			L Z A P I . P A S     				*
 *									*
 * Include File for LZW-Archiver/Unarchiver-DLLs included in the LZAPI  *
 * DLL-System								*
 * (C) 1996                                                             *
 *	Dipl. Ing. Bernd Herd                                           *
 *	Rodulf-Virchow-Str. 8                                           *
 *	68742 BBrstadt                                                 *
 *	Tel. 06206/707775                                               *
 *	Fax. 06206/707776                                               *
 *      EMail: herdsoft@aol.com                                         *
 *----------------------------------------------------------------------}

Unit LZApi;
Interface

uses WinTypes;

{$IFDEF WIN32}
const LZAPI_DLL_NAME = 'LZAPI32.DLL';
{$ELSE}
const LZAPI_DLL_NAME = 'LZAPI';
{$ENDIF}

{ Purpose of LZAPI:
   Included in the LZAPI-Package are several Packer/Unpacker-DLLs:
   WLHA.DLL		LZH Unpacker/Packer
   WZIP.DLL             ZIP Packer
   WUNZIP.DLL		ZIP Unpacker
   WARC.DLL		ARC Unpacker/Packer
   WUNARJ.DLL		ARJ Unpacker

   LZAPI is a Common API-Definition for all this packers that make them
   all the same in the Calling Convention Usage.

   Each packer DLL has it's own more powerfull API Functionality, but
   for LZAPI all of them support at least:

   XXXList(LPLACTL)	: Copy a Listing of the Archives Contents into
			  a Specified Memory Block

   XXXExtract(LPLACTL)	: Extract one or more Files

   XXXDelete(LPLACTL)   : Delete one or more Files

   XXXAppend(LPLACTL)   : Append one or more Files

   XXX is a Placeholder for the Archiv-Type, that Means LZH/ZIP/ARJ/ARC

   The LZAPI.DLL will add to this Functionality the Automatic determination, wich
   Library will actually needed to analyze a given File, which is especially
   interesting with Self-Extracting Archives. It will also look if the DLL
   currently wantet is in fact Available.

   All the Informations are exchanged with the help of an Control-Block
   Structure, because it makes Dynamic Linking via "LoadLibrary" much easier.

}


{  ----------- Error Codes Definition -------------------- }
type   LAERR = Integer;

const  LAE_OK= 			0;		{  No Error occured }
const  LAE_ARCHIVNOTFOUND=      2020;		{  Archiv File not Found }
const  LAE_BROKEN=              2021;		{  Broken Archiv }
const  LAE_INSTANCE= 		2026;           {  Instanz-Handling-Error (i.e. tried to run more than one Process) }
const  LAE_INFILENOTFOUND=      2027;           {  Input File not found }
const  LAE_STOPPED=             2028;           {  Stopped by Callbac-Routine }
const  LAE_WRONGTYPE=           2029;		{  Wrong Type of File }
const  LAE_DLLMISSING= 		2030;		{  Dll missing or errornous }
const  LAE_DOSBOX=		2051;		{  Problem while executine a DOS-Box occured }
const  LAE_TEMPORARY=           2041;           {  Error deleting or renaming temporary File }
const  LAE_PARAMETERS=		2053;		{  Illegal Parameters (i.e. lpstrListing NULL during LAList) }
const  LAE_MEM=			2054;		{  Virtual memory exhausted }
const  LAE_WRITE=		2055;		{  Error while creating or writing destination File. }

{  ----------- Flag-Value Definitions -------------------- }
const  LAF_SHORTNAMES=		$200;		{  Recommended Option to Supress usage of Long Filenames }
const  LAF_ALLOWGROWEXIST=	$400;		{  Allow existing Archiv to Grow on Add (Supported by WZIP only)
						   This Reduces Copying so things become faster.	
						}

{ ------- Archiver-Type Constants ------------------------ }
{ Return values for "LAIsArchiv" and "ArchiverType"-Field of LACTL-Structure }
const TY_NONE =0;
const TY_LZH  =1;
const TY_ARC  =2;
const TY_ARJ  =3;
const TY_ZIP  =4;
const TY_RAR  =5;
const TY_TAR  =6;
const TY_ZOO  =7;

{  ----------- Define Control Structure ------------------ }
type  LPLACTL = ^LACTL;
        TCallback = Function(Msg : Integer; Ctl : LPLACTL) : Integer
                  {$IFDEF WIN32} stdcall {$ENDIF}
                  ;

	LACTL = RECORD
		     lStructSize : LongInt;     {  Length of the Control Structure in Bytes }
		     hwndOwner   : hWnd;        {  Handle of the Parent Window (Needed for Message-Boxes etc.) }
		     lpstrArchivFile : PChar;   {  Points to a Buffer that specifies the Name of the Archiv File }
		     lpstrWildCards  : PChar;   {  Points to a Buffer that specifies the File-Names to be listet or }
						{  Extracted, like "*.*" or "*.DOC", or NULL for ANY FILE }
		     lpstrPath       : Pchar;	{  Points to a Buffer that specifies the destination Pathname }
						{  for the extracted Files (for Example C:\\TMP) }
		     Flags           : LongInt; {  Some LA_xxxx - Flags, combined via or - Operator }

                     lpfnCallback    : TCallback;{  Pointer to Callback-Routine to support "Multitasking". }

	{  -------- Listing-Function only ------------------------ }
		     lpstrListing    : PChar;   {  Points to a Buffer that shall receive the Directory Listing }

	{  -------- Application-Reserved Fields ------------------ }
		     lParam	     : LongInt; {  These Fields may be used freely by the application Program }
		     lpVoid	     : Pointer;
		     iCounter	     : SmallInt;

	{ --------- New in Version 1.3 --------------------------- }
		     ArchiverType    : SmallInt;	{ TY_xxxx - Value to select an Archiver (TY_NONE for auto-Selection) }

	{ -------- New in Version 2.0 ---------------------------  }
	             lpstrProcessedFile : PChar;{ File that is currently processed inside of the Archiv }
	             uPercentOfFile     : Cardinal;	{ Percentage of file processed at LAM_PERCENTOFFILE - Message }
		     uPercentOfArchiv   : Cardinal;	{ Percentage of file processed at LAM_NEXTFILE      - Message }
		     Reserved           : Array[1..10] of LongInt; { Reserved for future use, must be all zero }


	end;

{  ----------- Display an Error-Message ------------------ }
procedure LAErrMsg( errId : LAErr; Ctl : LPLACTL); far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}

{  ----------- Callback-Procedure template --------------- }
{ typedef LAERR (CALLBACK* LACALLBACK)(int, LPLACTL);    {  Type declaration Callback-Function }

{ ----------- Callback Routine Messages ------------------------------ }
const  LAM_PEEK=           1;             {  Nothing special }
const  LAM_NEXTFILE=       2;             {  Start processing next File
                                             (Only handled by SOME Archivers)  }
const  LAM_PERCENTOFFILE=  3;		  {  Transfer of %-Value of file processed in Archiv
                                             (Only handled by SOME Archivers) }
const  LAM_MAPNAME=	   4;		  {  Allow to change name of File
                                             (in lpstrProcessedFile) before unzipping (WUNZIP.DLL) }

{ ------------- Callback-Notification-Codes ----- }
const  LAN_OK=                    0;              {  Nothing special }
const  LAN_STOP=                  2;              {  Used with LHAM_PEEK     : Stop Decompression of Archive immediatly }


{  ------------ Archive-Type independend Versions -------- }
function LAList(    lpCtl : LPLACTL) : LAERR; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}
function LAExtract( lpCtl : LPLACTL) : LAERR; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}
function LAAppend(  lpCtl : LPLACTL) : LAERR; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}
function LADelete(  lpCtl : LPLACTL) : LAERR; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}

{  ------------- Direct Parameter Versions --------------- }

function LAListDirect( hwndOwner : HWnd;
                       ArchivFile: PChar;
                       Wildcards : PChar;
                       Listing   : PChar;
                       Flags     : LongInt;
                       Callback  : Pointer)  : LAERR; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}

function LAExtractDirect( hwndOwner : HWnd;
                          ArchivFile: PChar;
                          DestPath  : PChar;
                          Wildcards : PChar;
                          Flags     : LongInt;
                          Callback  : Pointer) : LAERR; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}

function LAAppendDirect(  hwndOwner : HWnd;
                          ArchivFile: PChar;
                          SourcePath: PChar;
                          Wildcards : PChar;
                          Flags     : LongInt;
                          Callback  : Pointer) : LAERR; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}

function LADeleteDirect(  hwndOwner : HWnd;
                          ArchivFile: PChar;
                          Wildcards : PChar;
                          Flags     : LongInt;
                          Callback  : Pointer) : LAERR; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}



{ -------------- Support Functions ---------------------- }
function LAGetExtensionString(Compress : Boolean) : Pchar; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}
	{ Retrieves a String-Pointer to the List of
	  Currently supported extenstions "*.LZH;*.ARJ;*.ZIP;*.ARC" etc. }

function LAIsArchiv(FileName : PChar) : Integer; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}
	{ Test if the FileName given marks an Archiv that may be
	  listed or decompressed }


{ -------------- Shareware Registration -----------------}
function LARegister(lpszUserName : PChar; lpszPassword : PChar) : Boolean; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}



implementation







{  ----------- Display an Error-Message ------------------ }
procedure LAErrMsg( errId : LAErr; Ctl : LPLACTL); external LZAPI_DLL_NAME;




{  ------------ Archive-Type independend Versions -------- }
function LAList(    lpCtl : LPLACTL) : LAERR; external LZAPI_DLL_NAME;
function LAExtract( lpCtl : LPLACTL) : LAERR; external LZAPI_DLL_NAME;
function LAAppend(  lpCtl : LPLACTL) : LAERR; external LZAPI_DLL_NAME; 
function LADelete(  lpCtl : LPLACTL) : LAERR; external LZAPI_DLL_NAME;

{  ------------- Direct Parameter Versions --------------- }

function LAListDirect( hwndOwner : HWnd;
                       ArchivFile: PChar;
                       Wildcards : PChar;
                       Listing   : PChar;
                       Flags     : LongInt;
                       Callback  : Pointer)  : LAERR; external LZAPI_DLL_NAME;

function LAExtractDirect( hwndOwner : HWnd;
                          ArchivFile: PChar;
                          DestPath  : PChar;
                          Wildcards : PChar;
                          Flags     : LongInt;
                          Callback  : Pointer) : LAERR; external LZAPI_DLL_NAME;

function LAAppendDirect(  hwndOwner : HWnd;
                          ArchivFile: PChar;
                          SourcePath: PChar;
                          Wildcards : PChar;
                          Flags     : LongInt;
                          Callback  : Pointer) : LAERR; external LZAPI_DLL_NAME;

function LADeleteDirect(  hwndOwner : HWnd;
                          ArchivFile: PChar;
                          Wildcards : PChar;
                          Flags     : LongInt;
                          Callback  : Pointer) : LAERR; external LZAPI_DLL_NAME;

{ -------------- Support Functions ---------------------- }
function LAGetExtensionString(Compress : Boolean) : Pchar; external LZAPI_DLL_NAME;
	{ Retrieves a String-Pointer to the List of
	  Currently supported extenstions "*.LZH;*.ARJ;*.ZIP;*.ARC" etc. }

function LAIsArchiv(FileName : PChar) : Integer; external LZAPI_DLL_NAME;
	{ Test if the FileName given marks an Archiv that may be
	  listed or decompressed }


{ -------------- Shareware Registration -----------------}
function LARegister(lpszUserName : PChar; lpszPassword : PChar) : Boolean; external LZAPI_DLL_NAME;

End.
