{ ----------------------------------------------------------------

	Unit-Datei zur Benutzung der Microsoft CTL3D-DLL im Pascal-
        Programm. Wenn sie nicht da ist, passiert halt nix.

	Dipl. Ing. Bernd Herd
	Rudolf-Virchow-Str. 8
	68642 Brstadt


	Diese Include-Datei enthlt alle Definitionen, die Sie brauchen,
        um die CTL3D.DLL bzw. CTL3DV2.DLL in Ihrem Anwendungsprogramm zu
        verwenden.

        Ihr Programm luft auch, wenn die DLL fehlt, dann eben ohne den
        zustzlichen Showeffekt.

        Binden Sie diese Unit mit

        Uses ms3d

        in Ihr Programm ein.

        Es wird nur die Grundfunktion zum automatischen Subclassen
        untersttzt.

        - MessageBox wird grau
        - Drucker-Einrichtungs-Dialogboxen werden grau usw.
        - Sonstige DialogBoxen werden grau.

        Die CTL3D.DLL unterscheidet sich von der CTL3DV2.DLL in
        einem wesentlichen Punkt: Sie mu im Windows-System-
        Verzeichnis stehen!

   ---------------------------------------------------------------- }

unit ms3d;

interface

uses OWindows, WinTypes, WinProcs, Win31, WinAPI;



implementation


var NextExitProc : pointer;
    hiCtl3d      : THandle;             { Handle der CTL3D.DLL }
    ErrorMode    : Word;

    fnReg, fnAuto, fnUnreg : pointer;


{ Diese Routine wird beim Programmende automatisch ausgefhrt }
procedure ExitMs3dUnit; far;
begin
  ExitProc := NextExitProc;

     asm   Push HInstance
           call fnUnReg
     end;

  FreeLibrary(hiCtl3d);
end;



{ Initialisierungteil der Unit: Versuch, die CTL3D.DLL bzw. CTL3DV2.DLL zu laden }
begin
  ErrorMode := SetErrorMode( SEM_NOOPENFILEERRORBOX );

  hiCtl3d := LoadLibrary( 'CTL3DV2.DLL' );

  if (hiCtl3d < HINSTANCE_ERROR) then
     hiCtl3d := LoadLibrary( 'CTL3D.DLL' );

  if (hiCtl3d >= HINSTANCE_ERROR) then Begin
     fnReg  := GetProcAddress( hiCtl3d, 'Ctl3dRegister'     );
     fnAuto := GetProcAddress( hiCtl3d, 'Ctl3dAutoSubclass' );
     fnUnReg:= GetProcAddress( hiCtl3d, 'Ctl3dUnRegister'   );

     if (fnReg <> NIL) and
        (fnAuto <> NIL)  and
        (fnUnReg <> NIL) then Begin

         NextExitProc := ExitProc;
         ExitProc     := @ExitMs3DUnit;

         asm   Push HInstance
               call fnReg
               Push HInstance
               Call fnAuto
         End;
     End;
  End;

  SetErrorMode( ErrorMode );

end.
