/*----------------------------------------------------------------------*
 *                                                                      *
 *			L Z A P I . H    				*
 *									*
 * Include File for LZW-Archiver/Unarchiver-DLLs included in the LZAPI  *
 * DLL-System								*
 *									*
 * (C) 1996                                                             *
 *	Dipl. Ing. Bernd Herd                                           *
 *	Rodulf-Virchow-Str. 8                                           *
 *	68742 BBrstadt                                                 *
 *	Tel. 06206/707775                                               *
 *	Fax. 06206/707776                                               *
 *      EMail: herdsoft@aol.com                                         *
 *                                                                      *
 *                                                                      *
 *                                                                      *
 *----------------------------------------------------------------------*/

/* Purpose of LZAPI:
   Included in the LZAPI-Package are several Packer/Unpacker-DLLs:
   WLHA.DLL		LZH Unpacker/Packer
   WUNZIP.DLL		ZIP Unpacker
   WZIP.DLL             ZIP Packer
   WARC.DLL		ARC Packer/Unpacker
   WUNARJ.DLL		ARJ Unpacker

   LZAPI is a Common API-Definition for all this packers that make them
   all the same in the Calling Convention Usage.

   Each packer DLL has it's own more powerfull API Functionality, but
   for LZAPI all of them support at least:

   XXXList(LPLACTL)	: Copy a Listing of the Archives Contents into
			  a Specified Memory Block

   XXXExtract(LPLACTL)	: Extract one or more Files

   XXX is a Placeholder for the Archiv-Type, that Means LZH/ZIP/ARJ/ARC

   The LZAPI.DLL will add to this Functionality the Automatic determination, wich
   Library will actually needed to analyze a given File, which is especially
   interesting with Self-Extracting Archives. It will also look if the DLL
   currently wantet is in fact Available.

   All the Informations are exchanged with the help of an Control-Block
   Structure, because it makes Dynamic Linking via "LoadLibrary" much easier.

*/

#ifdef WIN32
# define ISVERSION20ORLATER(lpCtl) (TRUE)
#else
# define ISVERSION20ORLATER(lpCtl) (lpCtl->lStructSize > 42)
#endif


// -------------- Standard stuff -------------------------
#ifndef __LZAPI_H
#define __LZAPI_H

#ifdef __cplusplus
extern "C" {
#endif


// ----------- Error Codes Definition --------------------
typedef int LAERR;

#define LAE_OK			0		// No Error occured
#define LAE_ARCHIVNOTFOUND      2020		// Archiv File not Found
#define LAE_BROKEN              2021		// Broken Archiv
#define LAE_WRITE		2023		// Error while creating or writing destination File.
#define LAE_CRC                 2024            // CRC error
#define LAE_INSTANCE		2026            // Instanz-Handling-Error (i.e. tried to run more than one Process)
#define LAE_INFILENOTFOUND      2027            // Input File not found
#define LAE_STOPPED             2028            // Stopped by Callbac-Routine
#define LAE_WRONGTYPE           2029		// Wrong Type of File
#define LAE_DLLMISSING		2030		// Dll missing or errornous
#define LAE_DOSBOX		2051		// Problem while executine a DOS-Box occured
#define LAE_TEMPORARY		2052		// Error while renaming or deleting temporary File
#define LAE_PARAMETERS		2053		// Illegal Parameters (i.e. lpstrListing NULL during LAList)
#define LAE_MEM			2054		// Virtual memory exhausted

// ----------- Flag-Value Definitions --------------------
#define LAF_SHORTNAMES		0x0200		// Recommended Option to Supress usage of Long Filenames
#define LAF_ALLOWGROWEXIST	0x0400		// Allow Grow of existing Archiv (No Copy will be Done)
						// Currently supportd by WZIP only.
#define LAF_RECURSEINTO		0x0800		// Recurse into Subdirectorys during Archiv Creation (Supported by ZIP only)
#ifdef __WIN32__
#define LAF_SPACEINFILENAME     0x1000          // Allows spaces in filenames transfered in lpszWildcard (WIN32-Only).
                                                // More that one wildcards can be separated by tab (ASCII 9) characters
#endif                                                 


// ------- Archiver Type Codes ---------- ----------------
// Return values for "LAIsArchiv" and "ArchiverType"-Field of LACTL-Structure
#define TY_NONE 0
#define TY_LZH  1
#define TY_ARC  2
#define TY_ARJ  3
#define TY_ZIP  4
#define TY_RAR  5
#define TY_TAR  6
#define TY_ZOO  7


// ----------- Define Control Structure ------------------
typedef struct tagLACTL {
	DWORD	lStructSize;		// Length of the Control Structure in Bytes
	HWND	hwndOwner;		// Handle of the Parent Window (Needed for Message-Boxes etc.)

	LPCSTR	lpstrArchivFile;	// Points to a Buffer that specifies the Name of the Archiv File
	LPCSTR	lpstrWildcards;		// Points to a Buffer that specifies the File-Names to be listet or
					// Extracted, like "*.*" or "*.DOC", or NULL for ANY FILE
	LPCSTR	lpstrPath;		// Points to a Buffer that specifies the destination Pathname
					// for the extracted Files (for Example C:\\TMP)
	DWORD	Flags;			// Some LA_xxxx - Flags, combined via | - Operator

	LAERR (CALLBACK* lpfnCallback)(int, struct tagLACTL far *);    // Callback-Routine to support "Multitasking".

	// -------- Listing-Function only ------------------------
	LPSTR	lpstrListing;		// Points to a Buffer that shall receive the Directory Listing

	// -------- Application-Reserved Fields ------------------
	LPARAM	lParam;			// These Fields may be used freely by the application Program
	void FAR*lpVoid;
	short   iCounter;

	// -------- New in Version 1.3 ---------------------------
	short   ArchiverType;		// TY_xxxx- Constant to select an Archiver-Type LZAPI shall use
					// (TY_NONE for auto-Selection)

	// -------- New in Version 2.0 ---------------------------
	LPCSTR  lpstrProcessedFile;    	// File that is currently processed inside of the Archiv
	UINT	uPercentOfFile;		// Percentage of file processed at LAM_PERCENTOFFILE 	    - Message
	UINT    uPercentOfArchiv;	// Percentage of file processed at LAM_NEXTFILE/LAM_MAPNAME - Message

	DWORD   Reserved[10];		// Reserved for futire use, must be all zero

	} LACTL, FAR *LPLACTL;


void FAR PASCAL LAErrMsg( LAERR errId, LPLACTL Ctl );
	// Displays a message-Box with an error-Message informing the User
	// what happened


// ----------- Callback-Procedure template ---------------
typedef LAERR (CALLBACK* LACALLBACK)(int, LPLACTL);    // Type declaration Callback-Function

//----------- Callback Routine Messages ------------------------------
#define LAM_PEEK          1             // Nothing special
#define LAM_NEXTFILE      2             // Start processing next File                      (Only handled by SOME Archivers)
#define LAM_PERCENTOFFILE 3		// Transfer of %-Value of file processed in Archiv (Only handled by SOME Archivers)
#define LAM_MAPNAME	  4		// Allow to change name of File (in lpstrProcessedFile) before unzipping (WUNZIP.DLL)


//------------- Callback-Notification-Codes -----
#define LAN_OK                   0              // Nothing special
#define LAN_STOP                 2              // Used with LHAM_PEEK     : Stop Decompression of Archive immediatly


// ----------- Templates for all supported DLLs ----------
LAERR FAR PASCAL LZHList(LPLACTL);
LAERR FAR PASCAL LZHExtract(LPLACTL);
LAERR FAR PASCAL LZHAppend(LPLACTL);
#ifdef WIN32
LAERR FAR PASCAL LZHDelete(LPLACTL);
#endif

LAERR FAR PASCAL ZIPList(LPLACTL);
LAERR FAR PASCAL ZIPExtract(LPLACTL);
LAERR FAR PASCAL ZIPAppend(LPLACTL);
LAERR FAR PASCAL ZIPDelete(LPLACTL);

LAERR FAR PASCAL ARJList(LPLACTL);
LAERR FAR PASCAL ARJExtract(LPLACTL);

LAERR FAR PASCAL ARCList(LPLACTL);
LAERR FAR PASCAL ARCExtract(LPLACTL);
LAERR FAR PASCAL ARCAppend(LPLACTL);
LAERR FAR PASCAL ARCDellete(LPLACTL);

LAERR FAR PASCAL ZOOList(LPLACTL);
LAERR FAR PASCAL ZOOExtract(LPLACTL);
LAERR FAR PASCAL ZOOAppend(LPLACTL);
LAERR FAR PASCAL ZOODelete(LPLACTL);

typedef LAERR    (CALLBACK* LAPROC)(LPLACTL pCtl);	// Typedef for Pointers to the above Functions

// ------------ Archive-Type independend Versions --------
LAERR FAR PASCAL LAList   (LPLACTL lpCtl);		// List Files in archiv
LAERR FAR PASCAL LAExtract(LPLACTL lpCtl);		// Extract Files from Archiv
LAERR FAR PASCAL LAAppend (LPLACTL lpCtl);		// Append Files to Archiv
LAERR FAR PASCAL LADelete (LPLACTL lpCtl);		// Delete Files from Archiv

// ------------- Direct Parameter Versions ---------------
LAERR FAR PASCAL LAListDirect(
			 HWND   hwndOwner,
			 LPCSTR ArchivFile,
			 LPCSTR Wildcards,
			 LPSTR  Listing,
			 DWORD  Flags,
			 LACALLBACK Callback);
LAERR FAR PASCAL LAExtractDirect(
			 HWND   hwndOwner,
			 LPCSTR ArchivFile,
			 LPCSTR DestPath,
			 LPCSTR Wildcards,
			 DWORD  Flags,
			 LACALLBACK Callback);
LAERR FAR PASCAL LAAppendDirect(
			 HWND   hwndOwner,
			 LPCSTR ArchivFile,
			 LPCSTR SourcePath,
			 LPCSTR Wildcards,
			 DWORD  Flags,
			 LACALLBACK Callback);
LAERR FAR PASCAL LADeleteDirect(
			 HWND   hwndOwner,
			 LPCSTR ArchivFile,
			 LPCSTR Wildcards,
			 DWORD  Flags,
			 LACALLBACK Callback);


// -------------- Support Functions ----------------------
LPCSTR FAR PASCAL LAGetExtensionString(BOOL Compress);
		// Retrieves a String-Pointer to the List of
		// Currently supported extenstions "*.LZH;*.ARJ;*.ZIP;*.ARC" etc.
		// They are usefull for COMMDLG-Filter-Settings
int    FAR PASCAL LAIsArchiv(LPCSTR FileName);
		// Test if the FileName given marks an Archiv that may be
                // listed or decompressed

// -------------- Shareware Registration -----------------
BOOL   FAR PASCAL LARegister(LPCSTR lpszUserName, LPCSTR lpszPassword);

// -------------- Standard stuff -------------------------

#ifdef __cplusplus
}
#endif

#endif // __LZAPI_H
