{ --------------------------------------------------------------------
 |        S I M P L E . P A S
 |
 | This is a Simple Pascal-Based Demonstration-Program for LZAPI
 |
 | It will simply copy all you INI-Files into an Archiv in the Temp
 | Directory
 | Bernd Herd 23.3.1995
 ---------------------------------------------------------------------- }

Program Simple;

uses LZAPI, WinProcs, WinTypes, Strings;


var Ctl              : LACTL;                   { Define the Control Strcture }
    WindowsDirectory : Array[0..144] of char;   { Windows-Directory with our INI-Files }
    TempDirectory    : Array[0..144] of char;   { Directory for Temp-Files }
    p                : Pchar;
    dummy            : TOFSTRUCT;               { For OpenFile }
    err              : LAERR;                   { LZAPI Error Code }

Begin
  { ------ Windows Directory ------------------------ }
  GetWindowsDirectory( WindowsDirectory, sizeof(WindowsDirectory) );

  { ------ Temp-Directory --------------------------- }
  GetTempFileName(#0, 'LZH', 0, TempDirectory);
  OpenFile( TempDirectory, dummy, OF_DELETE);
  strRscan(TempDirectory, '\')[1] := #0;
  strCat  (TempDirectory, 'INIS.LZH');

  { ------ Fill Control structure ------------------- }
  FillChar( Ctl, sizeof(Ctl), 0);
{  Ctl.hwndOwner       := ; This Program does not open a Window... normaly you MUST support this! }
  Ctl.lStructSize     := sizeof( Ctl );
  Ctl.lpstrArchivFile := TempDirectory;
  Ctl.lpstrWildcards  := '*.INI';
  Ctl.lpstrPath       := WindowsDirectory;
  Ctl.Flags           := LAF_SHORTNAMES;

  { ------ Perform Actions -------------------------- }
  err := LAAppend( @Ctl );
  if (err <> LAE_OK)
      then LAErrMsg(err, @Ctl )
      else MessageBox( 0, 'Hi, this was your Success for Today ;-)', 'SIMPLE.PAS', MB_OK or MB_ICONINFORMATION);


End.
