/* LZDIB.H -----------------------------------------------------*
 * L Z D I B --- Implementation OWL 2.x - Support for          	*
 *		 LHA-Compressed Bitmaps				*
 *	Dipl. Ing. Bernd Herd                    Dipl. Ing Harald Nuding*
 *	Niederstr 36                                                    *
 *	64285 Darmstadt                                                 *
 *	Tel. 06151/664717                       Fax 06151/664740        *
 *      EMail: herdnuding@aol.com               BBS:06151/664741        *
 *--------------------------------------------------------------*/

/* This is our LZRES-Support for OWL 2.x tested with Borland C++ 4.5

   It implements Classes that you may want to use instead of
   "TDib" and "TBitmap". This Classes are upward-Compatible,
   that means you may use "Edit Replace" "TDib" by "TLZDib".

   The new Classes will add Consructors to generate DIBs or
   Bitmaps from a BMP-File stored in a LZH-File stored in the
   Resources of a DLL or EXE

   Note that our GRBTN Custom Control Library supports the same
   Bitmap-Compression technology with Support to display previews
   of Compressed Bitmaps in Dialogs, even when the Bitmaps has
   256 Colors. It will also Dither Bitmaps to 16 Colors if
   appreciated. It's the best Solution for Sign-Up-Bitmaps.

*/

#ifndef __LZRES_H
#  include "lzres.h"		// Definitions for the LZRES.OBJ or LZRES32.OBJ-File
#endif

#define MAPCONSTRUCTORS		// This will map the TDib-Default-Constructors to TLZDib

/* IMPLEMENTS:
   TLZDib		derived from TDib
   TLZBitmap                         TBitmap
*/





/* TLZDib is a Class derived from TDib that brings with it new construtors:

   TLZDib(HINSTANCE instance, TResID resID, const char *NameInArchiv=NULL);

      A TLZDib-Object constructed with this constructor will load
      a LZH-Compressed BMP-File from the Archiv.

   TLZDib(LPLZHEAD SourcePtr, const char *NameInArchiv=NULL);

      A TLZDib-Object constructed with this constructor will decompress
      the memory-Block "SourcePtr" and create a TDib-Object for it
*/

class _OWLCLASS TLZDib : public TDib {

public:
   TLZDib(HINSTANCE Instance, TResId resID, const char *NameInArchiv=NULL);
   TLZDib(LPLZHEAD SourcePtr, const char *NameInArchiv=NULL);

#  ifdef MAPCONSTRUCTORS
   // --------- when mapping the other Constructors, we -----
   // now will be able to change all "TDib" by "TLZDib"

    TLZDib(HGLOBAL handle, TAutoDelete autoDelete = NoAutoDelete) : TDib(handle, autoDelete) {};
    TLZDib(const TClipboard& clipboard): TDib(clipboard){};
    TLZDib(const TDib& dib) : TDib(dib){};

    TLZDib(int width, int height, int nColors, uint16 mode=DIB_RGB_COLORS) : TDib(width, height, nColors, mode){};
    TLZDib(const char* name) : TDib(name){};
   #if !defined(BI_DATA_NEAR)
    TLZDib(istream& is, bool readFileHeader = false) : TDib(is, readFileHeader) {};
   #endif
    TLZDib(const TBitmap& bitmap, const TPalette* pal = 0) : TDib(bitmap, pal) {};
#  endif

private:
   HGLOBAL GimmeADibHandle(HINSTANCE Instance, TResId resID, const char *NameInArchiv);
};








/* TLZBitmap is a Class derived from TBitmap that brings with it new construtors:

   TLZBitmap(HINSTANCE instance, TResID resID, const char *NameInArchiv=NULL);

      A TLZBitmap-Object constructed with this constructor will load
      a LZH-Compressed BMP-File from the Archiv and convert it to a TBitmap.

   TLZBitmap(LPLZHEAD SourcePtr, const char *NameInArchiv=NULL);

      A TLZBitmap-Object constructed with this constructor will decompress
      the memory-Block "SourcePtr" and create a TDib-Object for it

   NOTE: If you need Palette-Support take the long way with TLZDib.
*/

class _OWLCLASS TLZBitmap : public TBitmap {

public:
   TLZBitmap(HINSTANCE Instance, TResId resID, const char *NameInArchiv=NULL);
   TLZBitmap(LPLZHEAD SourcePtr, const char *NameInArchiv=NULL);

#  ifdef MAPCONSTRUCTORS
   // --------- when mapping the other Constructors, we -----
   // now will be able to change all "TBitmap" by "TLZBitmap"

    TLZBitmap(HBITMAP handle, TAutoDelete autoDelete = NoAutoDelete) : TBitmap(handle, autoDelete){};
    TLZBitmap(const TClipboard& clipboard) : TBitmap(clipboard){};
    TLZBitmap(const TLZBitmap& bitmap) : TBitmap(bitmap){};

    TLZBitmap(int width, int height, uint8 planes=1, uint8 bitCount=1, const void far* bits=0)
	: TBitmap(width, height, planes, bitCount) {};
    TLZBitmap(const BITMAP far* bitmap) : TBitmap(bitmap) {};
    TLZBitmap(const TDC& Dc, int width, int height, bool discardable = false) : TBitmap(Dc, width, height, discardable){};
    TLZBitmap(const TDC& Dc, const TDib& dib, uint32 usage=CBM_INIT) : TBitmap(Dc, dib, usage){};

    TLZBitmap(const TMetaFilePict& metaFile, TPalette& palette, const TSize& size) : TBitmap(metaFile, palette, size) {};
    TLZBitmap(const TDib& dib, const TPalette* palette = 0) : TBitmap(dib, palette) {};
#  endif

private:
   HBITMAP GimmeABitmapHandle(HINSTANCE Instance, TResId resID, const char *NameInArchiv);
};

