{* LZRES.PAS ---------------------------------------------------*
 * Header definition File for LZRES.OBJ				*
 * (Decompression of Resources stored inside of LZH-Arhcives)	*
 * (C) 1995 Dipl. Ing. Bernd herd Dipl. Ing. Herald Nuding	*
 * Heidelberger Landstr. 316 D-64297 Darmstadt, 0049-6151-591216*
 *--------------------------------------------------------------*}

{ LZRES.OBJ is a very well optimizes LZH-Decompressor allowing you
  to decompress an LZH-Archiv stored in

  - a Memory Block            or
  - a Resource

  directly into a GlobalAlloc-Handle that it will create.

  In addition you may Decompress a LHA-Archiv stored in a Resource and
  create a Bitmap-handle from it.

  To do that:

  - Compress the Bitmap as a BMP-File via

    LHA -h0 a <filename> <filename.bmp>

  - Include a line for the LZH-Archiv in your Resource:

    <filename> RCDATA "<filename>.LZH"

  - Use "USES LZRes" in your Pascal.Program.

  - Use LoadLZHBitmap(hInstance, '<filename>', NULL)

	as you wild with a normal LoadBitmap-Call }


Unit LZRes;

Interface
uses WinTypes, WinProcs, Win31;


function LoadLZHResource( hInst : THandle; ResId : PChar; ArcFile : PChar; iBytesToOmit : Integer ) : THandle; far;

function LoadLZHBitmap( hInst : THandle; ResId : PChar; ArcFile : PChar ) : THandle; far;

function DecompressLZH( SourcePtr : Pointer; ArcFile : PChar; iBytesToOmit : Integer ) : THandle; far;

implementation


Procedure __AHIncr; Far; External 'KERNEL' Index 114;


function LoadLZHResource( hInst : THandle; ResId : PChar; ArcFile : PChar; iBytesToOmit : Integer ) : THandle; external;

function LoadLZHBitmap( hInst : THandle; ResId : PChar; ArcFile : PChar ) : THandle; external;

function DecompressLZH( SourcePtr : Pointer; ArcFile : PChar; iBytesToOmit : Integer ) : THandle; external;

  {$L LZRES.Obj}


End.