/*

      bfile.cpp
      Btrieve class for Borland C++
      09/06/91

      Douglas J. Reilly
      Access Microsystems Inc.
      404 Midstreams Road
      Brick, New Jersey  08724
      (908) 892-2683
      CompuServe 74040,607

      Comments?  Questions?  Suggestions?
      Have a paying C/C++ programming job you need done?
      Give me a call.

      Released into the public domain.  Do with it as you see fit, but
      if you do anything really neat with it, let me know...

*/
#include "stdio.h"
#include "stdlib.h"
#include "mem.h"
#include "string.h"
#include "bfile.h"    // class description for bfile

class bfile;

/*#define TEST*/
#ifdef TEST
main()
{
   char temp[100];
   int  ret;
   temp[0]='\0';
   bfile sum("TEST.BTR",4096,"BOOO!",0);


   printf("\nsum.get_rec(temp,B_GET_LO)=%d data=%30.30s",
                                           sum.get_rec(temp,B_GET_LO),
                                           sum.get_data());
   do {
      printf("\nsum.get_rec(temp,B_GET_NEXT)=%d data=%30.30s",
                                           ret=sum.get_rec(temp,B_GET_NEXT),
                                           sum.get_data());
   } while ( ret==0 );
}
#endif

bfile::bfile(char *name,int len,char *towner,int newmode)
{
   rec_len=len;
   data=new char[rec_len];

   key_num=0;
   opened=0;
   strcpy(fname,name);
   mode=newmode;
   if ( data==0 )
   {
      printf("\nOpen failed for %s-No memory",fname);
   }
   else
   {
      if ( towner!=0 )
      {
         strcpy(data,towner);
         strcpy(owner,towner);
      }
      status=BTRV(B_OPEN,pos_blk,data,&rec_len,fname,mode);
      if ( status )
      {
         delete data;
         data=0;
         printf("\nOpen failed for %s-status %d",fname,status);
      }
      else
      {
         opened=1;
      }
   }
}
bfile::~bfile()
{
   if ( !(opened) )
   {
      return;
   }
   else
   {
      status=BTRV(B_CLOSE,pos_blk,data,&rec_len,fname,mode);
      delete data;
      data=0;
      opened=0;
   }
}

int bfile::close()
{
   if ( !(opened) )
   {
      return 0;
   }
   else
   {
      status=BTRV(B_CLOSE,pos_blk,data,&rec_len,fname,mode);
      delete data;
      data=0;
      opened=0;
      return 1;
   }
}

int bfile::open(int newmode)
{
   if ( opened )
   {
      return 0;
   }
   if ( newmode!=-1 )
   {
      mode=newmode;
   }
   opened=0;
   data=new char[rec_len];
   if ( data==0 )
   {
      printf("\nOpen failed for %s-No memory",fname);
   }
   if ( owner!=0 )
   {
      strcpy(data,owner);
   }
   status=BTRV(B_OPEN,pos_blk,data,&rec_len,fname,mode);
   if ( status )
   {
      delete data;
      data=0;
      printf("\nOpen failed for %s-status %d",fname,status);
   }
   else
   {
      opened=1;
   }
}

int bfile::get_rec(char *keystr,int op)
{
   if ( !(opened) || data==0 )
   {
      return(BERR_NO_OPEN);    // btrieve status for not opened...
   }
   status=BTRV(op,pos_blk,data,&rec_len,keystr,key_num);
   return(status);
}

int bfile::put_rec(char *keystr,int )
{
   char *tdata;
   char tkey[128];
   int  stat;

   tdata=new char[rec_len];
   memcpy(tdata,data,rec_len);
   memcpy(tkey,keystr,128);
  // This is how I save btrieve data.  I understand that there is some
  //   potential for problem with this, since by always re-establishing
  //   positioning, I won't know if someone changed the data since I last
  //   got the rec, but in things I have done, I lock the records first
  //   anyway...
   if ( (stat=get_rec(keystr))!=0 )
   {
      if ( stat!=BERR_REC_NOT_FOUND && stat!=BERR_EOF )
      {
         delete tdata;
         return(stat);
      }
     // new record?
      status=BTRV(B_INSERT,pos_blk,tdata,&rec_len,tkey,key_num);
   }
   else
   {
      status=BTRV(B_UPDATE,pos_blk,tdata,&rec_len,tkey,key_num);
   }
   if ( !(status) )
   {
      memcpy(data,tdata,rec_len);
      strcpy(keystr,tkey);
   }
   delete tdata;
   return status;
}

int bfile::del_rec(char *keystr)
{
   char *tdata;
   char tkey[128];
   int  stat;

  // use tdata so as not to destroy infor in data...
   tdata=new char[rec_len];
   memcpy(tdata,data,rec_len);
   memcpy(tkey,keystr,128);
   if ( (stat=get_rec(keystr))!=0 )
   {
      delete tdata;
      return(stat);
   }
   else
   {
      status=BTRV(B_DELETE,pos_blk,tdata,&rec_len,tkey,key_num);
   }
   if ( !(status) )
   {
      memcpy(data,tdata,rec_len);
      strcpy(keystr,tkey);
   }
   delete tdata;
   return status;
}

