/*  BOOTRCD.CPP  ...  List boot record, etc. */

//  Copyright 1992 by George H. Mealy

#include    "brecord.h"
#include	<stdlib.h>
#include	<stdio.h>
#include    <string.h>
#include    <dos.h>
#include    <ctype.h>

extern int optind, opterr;
extern char *optarg;
int getopt(int argc, char *argv[], char *options);

#define fatal(a, b) {printf(a, b); exit(-1); }

brecord *bootrcd;
int list = 0, show = 0, set = 0;
char *serial = NULL;

void showserial(), setserial(), usage();

int main(int argc, char *argv[])
{
    int ch;
    opterr = 1;
    while (ch = getopt(argc, argv, "bsS:"), ch != EOF)
        switch(ch) {
            case 'b':   list = 1; break;
            case 'S':   set = 1;  serial = strdup(optarg);
            case 's':   show = 1; break;
bailout:    case '?':   usage();  return -1;
        }
    if (argc == 1) goto bailout;
    if (*argv[optind]) bootrcd = new brecord(*argv[optind]);
    if (! bootrcd) fatal("Bad drive letter\n", NULL);
    if (list) bootrcd->listboot();
    if (set)  setserial();
    if (show) showserial();
    if (! (list | show | set)) bootrcd->listboot();
    return 0;
}

void setserial()
{
    char *p = strchr(serial, '.');          // Separate major and minor parts
    if (p) *p++ = '\0';
    bootrcd->bserial = MK_FP(atoi(serial), p? atoi(p): 0);
    abswrite(bootrcd->drive, 1, 0L, bootrcd->bjunk1); // Update the boot record
}

void showserial()
{
    printf("Serial number is %u.%u\n", FP_SEG(bootrcd->bserial),
            FP_OFF(bootrcd->bserial));
}

void usage()
{
    puts(
"\n    Copyright 1992, George H. Mealy\n"
"    USAGE: BOOTDIR [-bsS] [<serial #>] <drive letter>\n"
"    where:\n"
"       -b                          Lists bootrecord content\n"
"       -s                          Shows the volume serial number only\n"
"       -S  <serial #n>             Sets the new serial number.  It must\n"
"                                     be in the form nnnn.nnnn .\n");
}
