//		BRECORD.H

//      Copyright 1992 by George H. Mealy

#ifndef	BRECORD_H
#define BRECORD_H

#pragma	option	-a-

struct  DIR {                           // Directory entry
	unsigned char	stem[8];
	unsigned char	ext[3];
	unsigned char	fileatt;
	unsigned char	junk[10];
	unsigned 		time,
			 		date;
	unsigned 		cluster;
	unsigned long 	filesize;
};

/*
	First byte of stem:

	00	first unused entry
	2E	directory entry
	E5	erased entry

	Attribute byte:

	01	readonly
	02	hidden
	04	system
	08	volume label
	10	subdirectory
	20	modified
*/

class brecord {
  private:
    char			bjunk1[3],			// Initial jump
    				bvendor[8];			// Vendor
	unsigned		bbytes;				// Bytes per sector
	unsigned char	bsect;				// Sectors per cl
	unsigned		brsvd;				// # reserved sectors
	unsigned char	bfat;				// # FATs
	unsigned		bndir,				// # root directory entries
					btotal;				// Total # sectors
	unsigned char	btype;				// Media
	unsigned		bfatsect,			// # sectors per FAT
					btracks,			// # sectors per track
					bheads;				// # heads
	unsigned long	bhidden,			// # hidden sectors
					b32total;			// Total # sectors, when btotal == 0
										//   i.e., if partition size > 32 MB
	unsigned char 	bjunk2[3];
	unsigned void far *bserial;			// Disk serial #
	unsigned char	bvolume[11];		// Volume label
	unsigned char	btail[512-54];		// Rest of boot record
	
  protected:
    unsigned char	drive;
    unsigned        *FAT;               // File allocation table (16 bit entries)
    unsigned        *FAT12;             // Same (12 bit entries)
    DIR             *rootdict;          // The root directory
	unsigned		nFATs;
    unsigned		FATsize;
  	unsigned		endtest;
  	unsigned		data_origin;
  	unsigned		endcluster;
  	unsigned		sectorsize;
  	unsigned 		clustersize;
  	unsigned		dictsize;
  	unsigned		dictsects;
  	unsigned		is16bit;
  	unsigned		freecount;
  	unsigned		dataclusters;
  	
  public:
    brecord(char);
    ~brecord();
    void getboot();
  	void putboot();
	void listboot();
    void getrootdict();
	void getFAT();
    void derase();
	int  readdir(unsigned);
	int  writedir(unsigned);
	int	 clength(unsigned);
	unsigned	sector(unsigned);
	unsigned	FATentry(unsigned);
	void dline(DIR *);
  friend void setserial();
  friend void showserial();
};

#endif

	 
	
	
											
	
						
						
