*/              Class declarations for 
                       BUMP 1.1
        the Beginners Understandable Matrix Package
                    for Borland C++
*/

class vorm // General Class for deriving Vector or Matrix classes
{
	protected:
	int which;	// Identifier for debugging; set = to vcount at creation;
	int nr;		// Number of rows
	int nc;		// Number of columns
	int fr;		// First row
	int fc;		// First column
	int lr;		// Last row
	int lc;		// Last column
	char temp;	// temp = 'y' is vector is temporary, otherwise 'n'

	/*	freeh() frees the heap memory used for the object.  It must
		be written differently for matrices and vectors, but freet()
		(described below) looks the same for the two classes, except that the
		freeh() it calls is different.  Hence, freeh() is a good candidate to
		be a virtual function.  The user may also call freeh() to free up the
		heap that was need for an object that was needed for several uses but
		is then no longer needed after a certain point in the program. 
		Hence, freeh() is public.  */

	public:
	virtual void freeh(){return;} 

	/* 	freet() frees the heap memory used by objects created by operators
		when those objects are used by other operators. Thus, in the line
		"C = A + B;" the + first creates a temporary to hold A + B. The =
		then copies this temporary to C and deletes the temporary by a
		call to freet().  In the line "A = B", the = operator will also
		call freet, but since B is not temporary, freet() returns without
		calling freeh() to do the deletion. */

	protected:
	void freet(){if(temp == 'y') freeh();} 
	public:
	int rows(){return nr;}
	int columns(){return nc;}
	int firstrow(){return fr;}
	int firstcolumn(){return fc;}
	int lastrow(){return lr;}
	int lastcolumn(){return lc;}
	};

class Matrix;  // This line allows the "friends" of Vector to refer to Matrix.

class Vector : public vorm
{
	int nelem;	// Number of elements
	float *v;	// pointer to the vector itself

	public:
	int ReadA(char *filename); // Read ASCII from a file.
	void Display(char *title = "",int width = 8, int decimalPlaces = 2);
	Vector(int anr, int anc = 1, char atemp = 'n', int afr = 1, int afc = 1);
	Vector(Vector& a);
	 ~Vector();
	Vector& operator = (Vector& ROp);
	Vector operator - (Vector &a);
	Vector operator ~ (); // Transposition
	void freeh(); // free heap memory 
	float& operator [] (int i);	// range checked element
	friend void operator << (Matrix& a, Vector& b);
	friend Vector operator + (Vector& a, Vector& b);
	friend Matrix operator * (Vector& a, Vector& b);	// ab
	friend Vector operator * (Matrix& a, Vector& b);
	friend Vector operator * (Vector& a, Matrix& b);
	friend Vector operator * (float a, Vector& b);
	friend Vector operator / (Vector& a, float b);
	// a/b forms the product a'b without creating a'.
	friend Matrix operator / (Vector& a, Vector& b);	// a'b
	friend Vector operator / (Matrix& A, Vector& b);	// A'b
	friend Vector operator / (Vector& a, Matrix& b);	// a'B
	};

class Matrix : public vorm
{
	float **m;

	public:
	int ReadA(char *filename); // Read ASCII from a file.
	void Display(char *title = "",int width = 8, int decimalPlaces = 2);
 	/* 	Invert this matrix; return determinant.  Start row reduction with
 		the pivot in row startrow and stop when the pivot has been done
 		for row endrow.  If stratrow is 0, start with first row; if
 		endrow is 0, end with last row.  */

	double invert(int startrow = 0, int endrow = 0); 
	Matrix(int anr, int anc, char atemp = 'n', int afr = 1, int afc = 1);
	Matrix(Matrix& a);
	~Matrix();
	Matrix& operator = (Matrix& a);
	Matrix operator ~ ();  // Transposition
	Matrix operator ! ();  // Inversion
	float * operator [] (int i);	// range-checked pointer to row
	void freeh(); // free heap memory 
	friend void operator << (Matrix& a, Vector& b);
	friend Matrix operator + (Matrix& a, Matrix& b);
	friend Matrix operator - (Matrix& a, Matrix& b);
	friend Matrix operator * (Matrix& a, Matrix& b);
	friend Vector operator * (Vector& a, Matrix& b);
	friend Vector operator * (Matrix& a, Vector& b);
	friend Matrix operator * (Vector& a, Vector& b);
	friend Matrix operator * (float a, Matrix& b);
	friend Matrix operator / (Matrix& b, float a);
	friend Matrix operator / (Matrix& a, Matrix& b); // form A'B without ~A
	friend Vector operator / (Matrix& A, Vector& b); // A'b
	friend Vector operator / (Vector& a, Matrix& b); // a'B
	friend Matrix operator / (Vector& a, Vector& b); // a'b
	};
// other prototypes
int isnum(char c);
int getfloat(float& f, FILE *fp, char *s, int& j);
int min(int a, int b);
int max(int a, int b);

#define OK 1
#define ERR -1
